function swapImage(id) {
    // use document.getElementById() to get an element from our HTML using the element ids
    let img = document.getElementById(id); // get the element with the id equal to the id parameter
    let mainImg = document.getElementById("gallery-main"); // get the element with id equal to gallery-main (<img src="" title="" alt="" id="gallery-main">)
    let captionTitle = document.getElementById("title"); // get the element with id equal to title (<span class="title" id="title"></span>)
    let captionAttribution = document.getElementById("attribution"); // get the element with id equal to attribution (<span class="attribution" id="attribution"></span>)

    /*
    Set the main images attributes using the image we clicked. We are not only able
    to access the values of properties using ".", we can also update their values.
    */
    mainImg.src = img.src; // set the mainImg's src equal to img's src
    mainImg.title = img.title; // set the mainImg's title equal to img's title
    mainImg.alt = img.alt; // set the mainImg's alt equal to img's alt

    captionTitle.textContent = img.title; // set captionTitle's text equal to img's title
    /*
    JavaScript gives us the .dataset property to access the the data attributes on an element.
    In this case, we want the value of the data-attribution attribute, dataset allows us to
    access this by using .dataset.attribution.
    */
    captionAttribution.textContent = img.dataset.attribution;
}