// total keeps track of our calculator's total value
let total = 0;
// operation is the operation we are performing (+,-,*,/)
let operation = "";
/*
number is the number the user is entering, using this variable
allows the user to enter multi-digit numbers
*/
let number = "";
/*
cleared keeps track of if the calculator has been cleared,
we are setting this to true initally because the calculator
starts in a clear state
*/
let cleared = true;

// This function handles the user clicking on a number button
function setNumber(num) {
    /*
    append the number that the user clicked on to the number
    global variable
    */
    number += num;
    // update the output to show the currently entered number
    document.getElementById("output").innerText = number;
}

// This function handles the user clicking on an operation button
function setOperation(op) {
    /*
    If the calculator is in a cleared state, parse the integer
    value from number and place it in total. Now the calculator
    is no longer in a clear state, so we set the cleared variable
    to false
    */
    if(cleared) {
        /*
        We use parseInt so we don't run into the string and number
        addition issue later.
        */
        total = parseInt(number);
        cleared = false;
    }
    // Call the processOperation function
    processOperation();
    // Set the operation to whichever operation that user clicked on
    operation = op;
    /*
    When the user clicks on an operation, we want to clear out the
    number so that they can start entering a new number.
    */
    number = "";
}

// This function handles when a user clicks the equals button
function equals() {
    // Call the processOperation function
    processOperation();
    // Set operation to "" since we are not performing an operation
    operation = "";
    // Like above, clear out the number
    number = "";
}

/*
processOperation is a supplimentary function that actually does
the math using the current total, entered number and last clicked
operation
*/
function processOperation() {
    // We only want to perform the operation when there is one
    if(operation != "" && number != "") {
        if(operation == "+") {
            // Add total to number if operation is addition
            total += parseInt(number);
        } else if(operation == "-") {
            // Subtract number from total if operation is subtraction
            total -= parseInt(number);
        } else if(operation == "*") {
            // Multiply total by number if operation is multiplication
            total *= parseInt(number);
        } else if(operation == "/") {
            // Divide total by number if operation is division
            total /= parseInt(number);
        }
        // Update output with new total
        document.getElementById("output").innerText = total;
    }
}

// This function handles when user clicks the clear button
function clearCalc() {
    // Reset all the variable to their defaults
    total = 0;
    operation = "";
    number = "";
    cleared = true;
    // Set output to 0 since we are clearing the calculator
    document.getElementById("output").innerText = "0";
}
