/*
This version of the script uses events. An event is triggered when certain things happen.
This allows us to attach JavaScript to our HTML without having to add any attributes to
our HTML. While I believe that learning the onclick method is the best way to start
learning about joining HTML and JavaScript, this method has become popular because it
keeps JavaScript out of our HTML and you may run into this if you continue to learn
about JavaScript.
*/

window.addEventListener('load', () => {
    let thumbnails = Array.prototype.slice.call(document.getElementsByClassName('gallery-thumbnail'));
    thumbnails.map((img) => {
        img.addEventListener('click', function(e) {
            let mainImg = document.getElementById("gallery-main");
            let captionTitle = document.getElementById("title");
            let captionAttribution = document.getElementById("attribution");
            
            mainImg.src = this.src;
            mainImg.title = this.title;
            mainImg.alt = this.alt;
            captionTitle.textContent = this.title;
            captionAttribution.textContent = img.dataset.attribution;
        });
    });
});