	MODULE FINE_RAY_GRID
	USE SET_KIND_MODULE
!
	REAL(KIND=LDP), ALLOCATABLE :: R_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: V_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: MUV_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: Z_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: DEN_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: ETAL_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: CHIL_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: TAUL(:)
	REAL(KIND=LDP), ALLOCATABLE :: TA(:)
	REAL(KIND=LDP), ALLOCATABLE :: TB(:)
	REAL(KIND=LDP), ALLOCATABLE :: TC(:)
	REAL(KIND=LDP), ALLOCATABLE :: INDX_RAY(:)
	REAL(KIND=LDP), ALLOCATABLE :: ABS_PROF(:)
!
	REAL(KIND=LDP) :: RSTAR
	REAL(KIND=LDP) ::  STORED_DEL_V=5000.0
	INTEGER :: STORED_MAX_DEPTH=-1
	INTEGER, PARAMETER :: IONE=1
	INTEGER :: NI,NRAY
!
	SAVE
	END MODULE FINE_RAY_GRID
!
CONTAINS:
!
	SUBROUTINE SET_FINE_RAY_GRID(ETAL,CHIL,
	1     R,V,SIGMA,DEN,P_VAL,DEL_V,ND)
	USE SET_KIND_MODULE
	USE FINE_RAY_GRID
	IMPLICIT NONE
!
	INTEGER ND
	REAL(KIND=LDP) ETAL(ND)
	REAL(KIND=LDP) CHIL(ND)
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) SIGMA(ND)
	REAL(KIND=LDP) DEN(ND)
	REAL(KIND=LDP) P_VAL
	REAL(KIND=LDP) DEL_V
!
! Local variables
!
	REAL(KIND=LDP) PSQ
	REAL(KIND=LDP) Z1,Z2,CUR_Z,dZ
	INTEGER MAX_DEPTH
	INTEGER NTMP
	INTEGER NINS
	INTEGER I,J,K
!
	RSTAR=R(ND)
	MAX_DEPTH=0
	DO I=1,ND
	   IF( ABS(R(I)/P_VAL-1.0_LDP) .LT. 1.0E-06_LDP)THEN
	     MAX_DEPTH=I
	     EXIT
	   END IF
	END DO
	IF(MAX_DEPTH .EQ. 0)MAX_DEPTH=ND
	WRITE(6,*)'Maximum depth is',MAX_DEPTH
!
	IF( STORED_MAX_DEPTH .EQ. MAX_DEPTH .AND.
	1         (STORED_DEL_V/DEL_V) .LE. 1.1_LDP)THEN
	  WRITE(6,*)'Using previously computed ray grid'
	  RETURN
	END IF
!
	IF(ALLOCATED(R_RAY))DEALLOCATE(R_RAY)
	NTMP=2*(V(1)/DEL_V)+4*MAX_DEPTH
	ALLOCATE(R_RAY(NTMP))
!	WRITE(6,*)'NTMP is',NTMP
!
	PSQ=P_VAL*P_VAL
	J=1
	R_RAY(1)=R(1)
	Z2=SQRT(R(1)*R(1)-PSQ)
	CUR_Z=Z2
	DO I=2,MAX_DEPTH
	  Z1=Z2
	  IF(I .EQ. MAX_DEPTH)THEN
	    Z2=0.0_LDP
	  ELSE
	    Z2=SQRT(R(I)*R(I)-PSQ)
	  END IF
	  NINS=(Z1*V(I-1)/R(I-1)-Z2*V(I)/R(I))/DEL_V
	  IF(NINS .GT. 1)THEN
	    dZ=(Z1-Z2)/(NINS+1)
	    DO K=1,NINS
	      J=J+1
	      IF(J .GT. NTMP)THEN
	        WRITE(6,*)NINS,Z1*V(I-1),Z2*V(I),dZ
	        WRITE(6,*)'NTMP is too small',I,MAX_DEPTH
	        STOP	
              END IF
	      CUR_Z=CUR_Z-dZ
	      R_RAY(J)=SQRT(CUR_Z*CUR_Z+PSQ)
	    END DO
!	    WRITE(6,'(I5,2ES14.4,I5,2ES14.4)')I,Z1,Z2,NINS,dZ,R_RAY(J)
	  END IF
	  CUR_Z=Z2
	  J=J+1
	  IF(J .GT. NTMP)THEN
	    WRITE(6,*)'NTMP is too small',I,MAX_DEPTH
	    STOP	
          END IF
	  R_RAY(J)=R(I)
	END DO
!	WRITE(6,*)'Number of data points is',NRAY,NTMP
!
	NI=J
	IF(P_VAL .GE. R(ND))THEN
	  NRAY=2*J-1
	ELSE
	  NRAY=J
	END IF
!
	IF(ALLOCATED(V_RAY))THEN
	  DEALLOCATE(V_RAY,ETAL_RAY,CHIL_RAY)
	  DEALLOCATE(DEN_RAY,Z_RAY,MUV_RAY)
	  DEALLOCATE(TA,TB,TC,ABS_PROF)
	  DEALLOCATE(TAUL,INDX_RAY)
	END IF
!
	ALLOCATE(V_RAY(NRAY),ETAL_RAY(NRAY),CHIL_RAY(NRAY))
	ALLOCATE(DEN_RAY(NRAY),Z_RAY(NRAY),MUV_RAY(NRAY))
	ALLOCATE(TA(NRAY),TB(NRAY),TC(NRAY),ABS_PROF(NRAY))
	ALLOCATE(TAUL(NRAY),INDX_RAY(NRAY))
!
	DO I=1,MAX_DEPTH
	  WRITE(20,'(I6,3ES14.4)')I,R(I),ETAL(I),CHIL(I)
	END DO
	DO I=1,NI
	  WRITE(21,'(I5,ES14.4)')I,R_RAY(I)
	END DO
!
	CALL MON_INTERP(V_RAY,NI,IONE,R_RAY,NI,V,ND,R,ND)
	CALL MON_INTERP(ETAL_RAY,NI,IONE,R_RAY,NI,ETAL,ND,R,ND)
	CALL MON_INTERP(CHIL_RAY,NI,IONE,R_RAY,NI,CHIL,ND,R,ND)
	CALL MON_INTERP(DEN_RAY,NI,IONE,R_RAY,NI,DEN,ND,R,ND)
!
	WRITE(22,'(I5,2ES14.4)')(I,R_RAY(I),ETAL_RAY(I),I=1,NRAY)
	WRITE(23,'(I5,2ES14.4)')(I,R_RAY(I),CHIL_RAY(I),I=1,NRAY)
!
	DO I=1,NI-1
	  Z_RAY(I)=SQRT(R_RAY(I)*R_RAY(I)-PSQ)
	  MUV_RAY(I)=Z_RAY(I)*V_RAY(I)/R_RAY(I)
	END DO
	Z_RAY(NI)=0.0_LDP; MUV_RAY(NI)=0.0_LDP
!
	IF(NRAY .NE. NI)THEN
	  DO I=1,NI-1
	    J=NRAY+1-I
	    R_RAY(J)=R_RAY(I)
	    V_RAY(J)=V_RAY(I)
	    DEN_RAY(J)=DEN_RAY(I)
	    ETAL_RAY(J)=ETAL_RAY(I)
	    CHIL_RAY(J)=CHIL_RAY(I)
	    Z_RAY(J)=-Z_RAY(I)
	    MUV_RAY(J)=-MUV_RAY(I)
	  END DO
	END IF
!
	STORED_DEL_V=DEL_V
	STORED_MAX_DEPTH=MAX_DEPTH
!
	RETURN
	END
	
	SUBROUTINE NON_SOB_TAUL(VSHIFT,VDOP,LINE_FREQ,METHOD,TYPE_ATM,XAXIS,XAXIS_OPT)
	USE SET_KIND_MODULE
	USE FINE_RAY_GRID
	IMPLICIT NONE
!
	REAL(KIND=LDP) VSHIFT		!In km/s
	REAL(KIND=LDP) VDOP		!In km/s
	REAL(KIND=LDP) LINE_FREQ	!In units of 10^15 Hz
	CHARACTER(LEN=*) METHOD
	CHARACTER(LEN=*) TYPE_ATM
	CHARACTER(LEN=*) XAXIS
	CHARACTER(LEN=*) XAXIS_OPT
!
	REAL(KIND=LDP) NU_DOP
	REAL(KIND=LDP) V_DOP
	REAL(KIND=LDP) PI
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) C_KMS,SPEED_OF_LIGHT
	EXTERNAL SPEED_OF_LIGHT
	INTEGER I
!
	PI=4.0_LDP*ATAN(1.0_LDP)
	C_KMS=1.0E-05_LDP*SPEED_OF_LIGHT()
!
! Resonace zone occurrs when
!    NUL(1+vray/c) = NUZ(1-VSHIFT/C)  => NUL= NZ(1-VSHIFT)/(1+VRAY)
!
! Doppler profile (NUL-NUZ)/dNU and dNU=NUZ*dV/c
!
	NU_DOP = VDOP*(LINE_FREQ/C_KMS)
	T2=1.0E-15_LDP/SQRT(PI)/NU_DOP
	DO I=1,NRAY
	  T1=((C_KMS-VSHIFT)/(C_KMS+MUV_RAY(I))-1.0_LDP)*C_KMS/VDOP
	  ABS_PROF(I)=T2*EXP(-T1*T1)
	  TA(I)=ABS_PROF(I)*CHIL_RAY(I)
	  WRITE(24,'(I5,5ES14.4)')I,MUV_RAY(I),CHIL_RAY(I),ABS_PROF(I),T1,TA(I)
	  FLUSH(UNIT=24)
	END DO
!
	TAUL(1)=TA(1)*Z_RAY(1)
	DO I=2,NRAY
	  TAUL(I)=TAUL(I-1)+0.5_LDP*(TA(I)+TA(I-1))*(Z_RAY(I-1)-Z_RAY(I))
	END DO
!	CALL TORSCL(TAUL,TA,Z_RAY,TB,TC,NRAY,'ZERO',TYPE_ATM)
	IF(XAXIS_OPT .EQ. 'R')THEN
	  CALL DP_CURVE(NRAY,R_RAY,TAUL)
	  XAXIS='R(10\u10\d cm)'
	ELSE IF(XAXIS_OPT .EQ. 'NR')THEN
	  INDX_RAY=R_RAY/RSTAR
	  CALL DP_CURVE(NRAY,INDX_RAY,TAUL)
	  XAXIS='R/R\d*\u'
	ELSE IF(XAXIS_OPT .EQ. 'Z')THEN
	  CALL DP_CURVE(NRAY,Z_RAY,TAUL)
	  XAXIS='z(10\u10\d cm)'
	ELSE IF(XAXIS_OPT .EQ. 'NZ')THEN
	  INDX_RAY=Z_RAY/RSTAR
	  CALL DP_CURVE(NRAY,INDX_RAY,TAUL)
	  XAXIS='z/R\d*\u'
	ELSE IF(XAXIS_OPT .EQ. 'MUV')THEN
	  CALL DP_CURVE(NRAY,MUV_RAY,TAUL)
	  XAXIS='gmV(km/s)'
	ELSE IF(XAXIS_OPT .EQ. 'I')THEN
	  DO I=1,NRAY
	    INDX_RAY(I)=I
	  END DO
	  XAXIS='Index'
	  CALL DP_CURVE(NRAY,INDX_RAY,TAUL)
	ELSE
	  WRITE(6,*)'Axis option not recognized'
	END IF
!
	RETURN
	END
!
	SUBROUTINE MAX_NON_SOB_TAUL(MAX_VAL,VSHIFT,VDOP,LINE_FREQ,METHOD,TYPE_ATM)
	USE SET_KIND_MODULE
	USE FINE_RAY_GRID
	IMPLICIT NONE
!
	REAL(KIND=LDP) MAX_VAL
	REAL(KIND=LDP) VSHIFT		!In km/s
	REAL(KIND=LDP) VDOP		!In km/s
	REAL(KIND=LDP) LINE_FREQ	!In units of 10^15 Hz
	CHARACTER(LEN=*) METHOD
	CHARACTER(LEN=*) TYPE_ATM
!
	REAL(KIND=LDP) NU_DOP
	REAL(KIND=LDP) V_DOP
	REAL(KIND=LDP) PI
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) C_KMS,SPEED_OF_LIGHT
	EXTERNAL SPEED_OF_LIGHT
	INTEGER I
!
	PI=4.0_LDP*ATAN(1.0_LDP)
	C_KMS=1.0E-05_LDP*SPEED_OF_LIGHT()
!
! Resonace zone occurrs when
!    NUL(1+vray/c) = NUZ(1-VSHIFT/C)  => NUL= NZ(1-VSHIFT)/(1+VRAY)
!
! Doppler profile (NUL-NUZ)/dNU and dNU=NUZ*dV/c
!
	NU_DOP = VDOP*(LINE_FREQ/C_KMS)
	T2=1.0E-15_LDP/SQRT(PI)/NU_DOP
	DO I=1,NRAY
	  T1=((C_KMS-VSHIFT)/(C_KMS+MUV_RAY(I))-1.0_LDP)*C_KMS/VDOP
	  ABS_PROF(I)=T2*EXP(-T1*T1)
	  TA(I)=ABS_PROF(I)*CHIL_RAY(I)
	  WRITE(24,'(I5,5ES14.4)')I,MUV_RAY(I),CHIL_RAY(I),ABS_PROF(I),T1,TA(I)
	  FLUSH(UNIT=24)
	END DO
!
	TAUL(1)=TA(1)*Z_RAY(1)
	DO I=2,NRAY
	  TAUL(I)=TAUL(I-1)+0.5_LDP*(TA(I)+TA(I-1))*(Z_RAY(I-1)-Z_RAY(I))
	END DO
!	CALL TORSCL(TAUL,TA,Z_RAY,TB,TC,NRAY,'ZERO',TYPE_ATM)
	MAX_VAL=TAUL(NRAY)
!
	RETURN
	END
