	SUBROUTINE WRITE_LINE_12MAY98(TRAN_NAME,MOD_NAME,
	1             DIF,CONT_INT,FREQ,AMASS,R,V,SIGMA,T,
	1             ETA,CHI,ESEC,CHIL,ETAL,ND,LUOUT)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	CHARACTER(LEN=*) TRAN_NAME
	CHARACTER(LEN=*) MOD_NAME
!
	INTEGER ND
	INTEGER LUOUT
!
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) SIGMA(ND)
	REAL(KIND=LDP) T(ND)
	REAL(KIND=LDP) ETA(ND)
	REAL(KIND=LDP) CHI(ND)
	REAL(KIND=LDP) ESEC(ND)
	REAL(KIND=LDP) ETAL(ND)
	REAL(KIND=LDP) CHIL(ND)
!
	LOGICAL DIF
	REAL(KIND=LDP) CONT_INT
	REAL(KIND=LDP) FREQ
	REAL(KIND=LDP) AMASS
!
        REAL(KIND=LDP) VAC_LAM
        REAL(KIND=LDP) SPEED_OF_LIGHT
        EXTERNAL SPEED_OF_LIGHT
!
	INTEGER I
	CHARACTER(LEN=20) TMP_STR
	I=LEN_TRIM(MOD_NAME)
	TMP_STR=MOD_NAME
!
	VAC_LAM=1.0E-07_LDP*SPEED_OF_LIGHT()/FREQ
!
	IF(TRAN_NAME .EQ. 'Continuum')THEN
	  IF(I .GT. 20)TMP_STR=MOD_NAME(I-19:I)
   	  WRITE(LUOUT,'(1X,A,T25,A,T40,A)')'12-May-1998','[Date]','Revised format date'
   	  WRITE(LUOUT,'(1X,A,T25,A,T40,A)')TRIM(TMP_STR),'[MOD_ID]','Model'
	  WRITE(LUOUT,'(1X,A,T25,A,T40,A)')'Continuum:','[TR_ID]','Transition identification'
 	  WRITE(LUOUT,'(1X,A,T25,A,T40,A)')DIF,'[DIF]','Diffusion approximation'
	  WRITE(LUOUT,'(1X,1PE15.8,T25,A,T40,A)')FREQ,'[FREQ]','Frequency (10^15 Hz)'
	  WRITE(LUOUT,'(1X,1PE12.5,T25,A,T40,A)')VAC_LAM,'[LAM]','Wavelength (Ang)(vacuum)'
	  WRITE(LUOUT,'(1X,1PE15.8,T25,A,T40,A)')CONT_INT,'[IC]','Schuster intensity'
	  WRITE(TMP_STR,'(I5)')ND; TMP_STR=ADJUSTL(TMP_STR)
          WRITE(LUOUT,'(1X,A,T25,A,T40,A)')TRIM(TMP_STR),'[ND]','Number of depth points'

	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'R',(R(I),I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'T',(T(I),I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'SIGMA',(SIGMA(I),I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'V',(V(I),I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'ETA',(ETA(I),I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'CHI_TH',( (CHI(I)-ESEC(I)) ,I=1,ND)
	  WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'ESEC',(ESEC(I),I=1,ND)
!
	ELSE
          WRITE(LUOUT,'(1X,A,T25,A,T40,A)')TRIM(TRAN_NAME),'[TR_ID]','Transition identification'
          WRITE(LUOUT,'(1X,1PE15.8,T25,A,T40,A)')FREQ,'[FREQ]','Frequency (10^15 Hz)'
          WRITE(LUOUT,'(1X,1PE12.5,T25,A,T40,A)')VAC_LAM,'[LAM]','Wavelength (Ang)(vacuum)'
          WRITE(LUOUT,'(1X,F6.2,T25,A,T40,A)')AMASS,'[AMASS]','Atomic mass'
	  WRITE(LUOUT,'(1X,1PE15.8,T25,A,T40,A)')CONT_INT,'[IC]','Schuster intensity'
          WRITE(LUOUT,*)' '
          WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'ETAL',(ETAL(I),I=1,ND)
          WRITE(LUOUT,'(1X,A,/,(1P,1X,9E14.6))')'CHIL',(CHIL(I),I=1,ND)
	END IF
	CLOSE(UNIT=LUOUT)
!
	RETURN
	END
