	SUBROUTINE COMPUTE_DUST_OPACITY(CHI_ABS_DUST,CHI_SCAT_DUST,DENSITY,CONT_FREQ,ND)
	USE SET_KIND_MODULE
	USE DUST_MOD
	IMPLICIT NONE
!
! Created 12-Feb-2023
!
	INTEGER I,ND
	REAL(KIND=LDP) CHI_ABS_DUST(ND)
	REAL(KIND=LDP) CHI_SCAT_DUST(ND)
	REAL(KIND=LDP) DENSITY(ND)
	REAL(KIND=LDP) CONT_FREQ
!
! Local constants
!
	REAL(KIND=LDP) XKAP
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) LAMBDA
	INTEGER IDUST
!
        COMMON/CONSTANTS/ CHIBF,CHIFF,HDKT,TWOHCSQ
        COMMON/LINE/ OPLIN,EMLIN
        REAL(KIND=LDP) CHIBF,CHIFF,HDKT,TWOHCSQ,OPLIN,EMLIN
!
	CHI_ABS_DUST(1:ND) = 0.0_LDP
	CHI_SCAT_DUST(1:ND) = 0.0_LDP
	IF (MOD_INCL_DUST) THEN
	  IF (USE_DUST_FILE) THEN
	    LAMBDA = HZ_TO_MICRON / CONT_FREQ
!
! Scatttering component
!
	    IDUST=0
	    IF ((DUST_TYPE .EQ. 'MIX') .OR. (DUST_TYPE .EQ. 'SCA')) THEN 
              IF ( LAMBDA .GE. LAM_DUST_IN(N_DUST_FILE) ) THEN
                XKAP = KAP_SCAT_DUST_IN(N_DUST_FILE) 
              ELSE IF ( LAMBDA .LE. LAM_DUST_IN(1) ) THEN
	        XKAP = KAP_SCAT_DUST_In(1)
	      ELSE
	        IDUST = MAX( MINLOC( (LAM_DUST_IN-LAMBDA), 1, (LAM_DUST_IN-LAMBDA) .GT. 0 )-1,1 )
	        T1 = (KAP_SCAT_DUST_IN(IDUST+1)-KAP_SCAT_DUST_IN(IDUST)) / (LAM_DUST_IN(IDUST+1)-LAM_DUST_IN(IDUST))
	        XKAP  =  KAP_SCAT_DUST_IN(IDUST)  + (LAMBDA-LAM_DUST_IN(IDUST)) * T1
              END IF
	      CHI_SCAT_DUST(1:ND) = XKAP * LOCAL_DUST_TO_GAS_RATIO(1:ND)*DENSITY(1:ND)*1.0E+10_LDP
              WHERE(CHI_SCAT_DUST .LE. 0.0_LDP)CHI_SCAT_DUST=1.0E-60_LDP
	    END IF
!
! Absorption component
!
	     IF ((DUST_TYPE .EQ. 'MIX') .OR. (DUST_TYPE .EQ. 'ABS')) THEN
               IF ( LAMBDA .GE. LAM_DUST_IN(N_DUST_FILE) ) THEN
	         XKAP = KAP_ABS_DUST_IN(N_DUST_FILE)
	       ELSE IF ( LAMBDA .LE. LAM_DUST_IN(1) ) THEN
	         XKAP = KAP_ABS_DUST_IN(1)
	       ELSE
	         IF(IDUST .EQ. 0)IDUST = MAX( MINLOC( (LAM_DUST_IN-lambda), 1, (LAM_DUST_IN-LAMBDA) .GT. 0 )-1,1 )			     
                 T1 = (KAP_ABS_DUST_IN(IDUST+1)-KAP_ABS_DUST_IN(IDUST))/(LAM_DUST_IN(IDUST+1)-LAM_DUST_IN(IDUST))
                 XKAP  =  KAP_ABS_DUST_IN(IDUST)  + (LAMBDA-LAM_DUST_IN(IDUST)) * T1
               END IF
               CHI_ABS_DUST(1:ND) = XKAP * LOCAL_DUST_TO_GAS_RATIO(1:ND)*DENSITY(1:ND)*1.0E10_LDP
	     END IF
	   END IF
!			
	END IF
!
	RETURN
	END
