	SUBROUTINE SET_DUST_EJECTA_PROPERTIES(R,V,DENSITY,CLUMP_FAC,ND)
	USE SET_KIND_MODULE
	USE DUST_MOD
	IMPLICIT NONE
!
! Created 12-Feb-2023
!
	INTEGER ND
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) DENSITY(ND)
	REAL(KIND=LDP) CLUMP_FAC(ND)
!
	REAL(KIND=LDP), ALLOCATABLE :: WRK(:)
	REAL(KIND=LDP), ALLOCATABLE :: WRK_ABS(:)
	REAL(KIND=LDP), ALLOCATABLE :: WRK_SCAT(:)
!
	REAL(KIND=LDP) T1
	INTEGER I,UNIT_DUST
!
	IF (USE_DUST_FILE) THEN
	  CALL RD_DUST_FILE
	  ALLOCATE (WRK(ND), WRK_ABS(ND),WRK_SCAT(ND))
	  ALLOCATE (LOCAL_DUST_TO_GAS_RATIO(ND)) ; LOCAL_DUST_TO_GAS_RATIO=0.0_LDP
!
	  IF(DUST_DIST_LAW .EQ. 'OUTER_SHELL')THEN
	    DO I=1,ND
	      IF(V(I) .LT. VMIN_DUST)THEN
	        LOCAL_DUST_TO_GAS_RATIO(I) = FIXED_DUST_TO_GAS_RATIO*EXP(-(VMIN_DUST-V(I))/DV_DUST )
	      ELSE IF(V(I) .GT. VMAX_DUST)THEN
	        LOCAL_DUST_TO_GAS_RATIO(I)=FIXED_DUST_TO_GAS_RATIO*EXP(-(V(I)-VMAX_DUST)/DV_DUST )
	      ELSE 
	        LOCAL_DUST_TO_GAS_RATIO(I) = FIXED_DUST_TO_GAS_RATIO
	      END IF
	    END DO
	  ELSE IF(DUST_DIST_LAW .EQ. 'SHELL')THEN
	    DO I=1,ND 
	      T1 = (V(I)-V_SHELL_LOC) / dV_SHELL
	      IF (DABS(T1) .GT. 10.0_LDP) THEN
	        LOCAL_DUST_TO_GAS_RATIO(I) = 0.0_LDP
	      ELSE
	        LOCAL_DUST_TO_GAS_RATIO(I) = DEXP(-T1*T1)
	      ENDIF
	    END DO
	  ELSE
	     IF (DV_DUST .GT. 1D10) THEN		  
	       LOCAL_DUST_TO_GAS_RATIO(1:ND) = 1.0D0
	     ENDIF
	     IF (VMIN_DUST.LE.0.) THEN
	       DO I=1,ND
	         IF (V(I).LT.VMAX_DUST) THEN 
	   	   LOCAL_DUST_TO_GAS_RATIO(I) = 1.0D0
	         ELSE
		   LOCAL_DUST_TO_GAS_RATIO(I) = 1.0D0 - (1.0D0-DEXP(-(V(I)-VMAX_DUST)/DV_DUST))
	         ENDIF
	       ENDDO
	     ENDIF
	  END IF
!   
	  WRK = LOCAL_DUST_TO_GAS_RATIO * DENSITY * CLUMP_FAC * R * R
	  CALL LUM_FROM_ETA_V2(WRK,R,'LINMON',ND)
	  T1 = 4.*acos(-1.0_LDP)*sum(WRK)/1.989E3_LDP
!	  WRITE(6,*)LOCAL_DUST_TO_GAS_RATIO(1:ND)
	  FLUSH(UNIT=6)
	  IF(MASS_DUST .NE. 0)THEN
	    LOCAL_DUST_TO_GAS_RATIO(1:ND) = LOCAL_DUST_TO_GAS_RATIO(1:ND) * MASS_DUST / T1
	    WRITE(6,*)'Mass of dust before scaling',T1
	  END IF
	  WRITE(6,*)'Final mass of dust' 
!
	  WRITE(6,'(/,A,/)')' Summary of dust properties written do CMF_DUST_SUMMARY'
!
	  CALL GET_LU(UNIT_DUST,'SET_DUST_EJECTA_PROPERTIES')
	  OPEN(UNIT_DUST,FILE='CMF_DUST_SUMMARY',STATUS='UNKNOWN')
	    WRITE(UNIT_DUST,'(A30,3X,A)') 'Dust_file_name:',TRIM(DUST_FILE_NAME)
	    WRITE(UNIT_DUST,'(A30,3X,A)') 'Dust_type:',TRIM(DUST_TYPE)
	    WRITE(UNIT_DUST,'(A30,I10)')  'Nb of entries in dust file:',N_DUST_FILE
	    WRITE(UNIT_DUST,'(A30,2ES15.5)') 'Start/end of lam:',LAM_DUST_IN(1),    LAM_DUST_IN(n_dust_file)
	    WRITE(UNIT_DUST,'(A30,2ES15.5)') 'Start/end of kaa(scat):',KAP_SCAT_DUST_IN(1),KAP_SCAT_DUST_IN(n_dust_file)
	    WRITE(UNIT_DUST,'(A30,2ES15.5)') 'Start/end of kap(abs) :',KAP_ABS_DUST_IN(1),KAP_ABS_DUST_IN(n_dust_file)

	    WRK = LOCAL_DUST_TO_GAS_RATIO * DENSITY * CLUMP_FAC * R * R
	    CALL LUM_FROM_ETA_V2(WRK,R,'LINMON',ND) 
	    WRITE(UNIT_DUST,'(A30,1ES10.2)') 'Total Dust mass in Msun:',4.*ACOS(-1.0)*SUM(WRK)/1.989D3
!
! If we do not multiple by R^2, we can use LUM_FROM_ETA_V2 to estimate the optical depth scale.
!
	    WRITE(UNIT_DUST,'(/,6A15)') 'Lambda(um)','Lambda(Ang)','Tau(abs)','Kappa(abs)','Tau(scat)','Kappa(SCAT)'
	    DO I=1,N_DUST_FILE,INT(N_DUST_FILE/20)
	      WRK_ABS(1:ND) = KAP_ABS_DUST_IN(I) * LOCAL_DUST_TO_GAS_RATIO(1:ND) * DENSITY(1:ND) * CLUMP_FAC(1:ND)*1D10
	      CALL LUM_FROM_ETA_V2(WRK_ABS,R,'LINMON',ND)
	      WRK_SCAT(1:ND) = KAP_SCAT_DUST_IN(I) * LOCAL_DUST_TO_GAS_RATIO(1:ND) * DENSITY(1:ND) * CLUMP_FAC(1:ND)*1D10
	      CALL LUM_FROM_ETA_V2(WRK_SCAT,R,'LINMON',ND)
	      WRITE(UNIT_DUST,'(6ES15.3)')LAM_DUST_IN(I),1.0E+04*LAM_DUST_IN(I),SUM(WRK_ABS), 
	1            KAP_ABS_DUST_IN(I), SUM(WRK_SCAT), KAP_SCAT_DUST_IN(I)
	    ENDDO
	    WRITE(UNIT_DUST,'(6A15)') 'Lambda(um)','Lambda(Ang)','Tau(abs)','Kappa(abs)','Tau(scat)','Kappa(SCAT)'
!
	    WRITE(UNIT_DUST,'(/,A5,A20,A20)') 'I','Velocity','Dust to gas ratio'
	    DO I=1,ND 
	      WRITE(UNIT_DUST,'(I5,2ES20.5)') I, V(I), LOCAL_DUST_TO_GAS_RATIO(I)
	    ENDDO
	    DEALLOCATE (WRK, WRK_ABS, WRK_SCAT)
	  CLOSE(UNIT_DUST)
	ENDIF
!
	RETURN
	END
