	SUBROUTINE DET_ED_V2(ND,ABUND_SUM,DO_LEV_DIS)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	IMPLICIT NONE
!
! Created 28-May-2025 : Updated from DET_ED
!                       Changed to allow for high ionization stages with zero poplations at some tmperatures.
!                       Specifically designed for computing LTE Rosseland mean opacities.
!
	INTEGER ND
	REAL(KIND=LDP) ABUND_SUM
	LOGICAL DO_LEV_DIS
!
	REAL(KIND=LDP) ION_POPS(ND,NUM_IONS)
	REAL(KIND=LDP) LOG_ION_POPS(ND,NUM_IONS)
!
	REAL(KIND=LDP) LOG_FSAHA(NUM_IONS)
	REAL(KIND=LDP) LOG_XZ(NUM_IONS)
	REAL(KIND=LDP) LOG_XZW(NUM_IONS)
	REAL(KIND=LDP), ALLOCATABLE :: TEMP_SUM(:)
!
	REAL(KIND=LDP) ED_OLD(ND)
	REAL(KIND=LDP) POPION_OLD(ND)
!
	REAL(KIND=LDP) XEDW
	REAL(KIND=LDP) XED_OLD
	REAL(KIND=LDP) XERR
	REAL(KIND=LDP) XKBT
	REAL(KIND=LDP) XG0
	REAL(KIND=LDP) XG1
	REAL(KIND=LDP) XGE
	REAL(KIND=LDP) T1,T2,T3
	REAL(KIND=LDP) PI
	REAL(KIND=LDP) HSQR
	REAL(KIND=LDP), PARAMETER :: HDKT=4.7994145_LDP
	REAL(KIND=LDP), PARAMETER :: EPS=1.0E-05_LDP
!
	REAL(KIND=LDP) PLANCKS_CONSTANT
	REAL(KIND=LDP) BOLTZMANN_CONSTANT
	REAL(KIND=LDP) ELECTRON_MASS
	EXTERNAL PLANCKS_CONSTANT
	EXTERNAL BOLTZMANN_CONSTANT
	EXTERNAL ELECTRON_MASS
!
	INTEGER ISTART,IEND
	INTEGER L
	INTEGER K
	INTEGER I
	INTEGER IW
	INTEGER ID
	INTEGER ISPEC
	LOGICAL CONVERGED
!
	WRITE(6,*)'Entered DET_ED_V2'; FLUSH(UNIT=6)
	PI=ACOS(-1.0_LDP)
        HSQR = PLANCKS_CONSTANT()*PLANCKS_CONSTANT()
	DO ISPEC=1,NUM_SPECIES
	  DO L=1,ND
            POP_SPECIES(L,ISPEC)=AT_ABUND(ISPEC)*POP_ATOM(L)/ABUND_SUM ! 1/cm^3
          END DO
	END DO
!
	K=0
	DO ID=1,NUM_IONS
	  IF(ATM(ID)%XzV_PRES)THEN
	     K=MAX(K,ATM(ID)%NXzV)
	  END IF
	END DO
	ALLOCATE (TEMP_SUM(K))
!
! Perform initializations.
!
	ED_OLD=0.0_LDP
	ED=POP_ATOM
	POPION=POP_ATOM
	POPION_OLD=0.0_LDP
	LOG_FSAHA=0.0_LDP
	CONVERGED=.FALSE.
!
! Compute the effective statistical weight for all levels in all ions.
! The effective statistical weight is the product of the actual statistical
! weight, and the Boltzmann excitation factor. We store it in the FULL
! level population vector.
!
	DO L=1,ND
          XKBT = BOLTZMANN_CONSTANT() * T(L) * 1.0E4_LDP
          T1 = (2.0_LDP*PI*ELECTRON_MASS()*XKBT/HSQR)**1.5
          T2 = HDKT/T(L)
          DO ID=1,NUM_IONS
            IF (ATM(ID)%XzV_PRES) THEN
              ATM(ID)%XzV_F(1,L)= ATM(ID)%GXzV_F(1)
	      DO I=2,ATM(ID)%NXzV_F
	        ATM(ID)%XzV_F(I,L)=ATM(ID)%GXzV_F(I)*EXP(T2*(ATM(ID)%EDGEXzV_F(I)-ATM(ID)%EDGEXzV_F(1)))
	      END DO
            END IF
          END DO
	END DO
!
	DO WHILE(.NOT. CONVERGED)
	   CONVERGED=.TRUE.
!
! Compute the occupation probabilities, first updating the dissolution constants.
!
	  CALL COMP_LEV_DIS_BLK(ED,POPION,T,DO_LEV_DIS,ND)
	  DO ID=1,NUM_IONS
	    IF(ATM(ID)%XzV_PRES)THEN
	      CALL OCCUPATION_PROB(ATM(ID)%W_XZV_F,ATM(ID)%EDGEXzV_F,
	1       ATM(ID)%ZXzV,ATM(ID)%NXzV_F,ND)
	    END IF
	  END DO
!
! Solve the Saha equation for the mixture considered: we obtain the electron density
! and the relative population of all ions.
!
	  DO L=1,ND
	    DO WHILE( ABS(1.0_LDP-ED_OLD(L)/ED(L)) .GT. EPS .OR.
	1             ABS(1.0_LDP-POPION_OLD(L)/POPION(L)) .GT. EPS )
	      ED_OLD(L)=ED(L)
	      POPION_OLD(L)=POPION(L)
	      CONVERGED=.FALSE.
!
              XKBT = BOLTZMANN_CONSTANT() * T(L) * 1.0E4_LDP
              T1 = (2.0_LDP*PI*ELECTRON_MASS()*XKBT/HSQR)**1.5
              T2 = HDKT/T(L)
              DO ID=1,NUM_IONS
                IF (ATM(ID)%XzV_PRES) THEN
                  XGE = 2.0_LDP
                  XG0 = ATM(ID)%GXzV_F(1)
	          DO I=2,ATM(ID)%NXzV_F
	            XG0=XG0+ATM(ID)%W_XzV_F(I,L)*ATM(ID)%XzV_F(I,L)
	          END DO
                  XG1 = ATM(ID)%GIONXzV_F
                  IF(ATM(ID+1)%XzV_PRES) THEN
	            DO I=2,ATM(ID+1)%NXzV_F
	              XG1=XG1+ATM(ID+1)%W_XzV_F(I,L)*ATM(ID+1)%XzV_F(I,L)
                    END DO
	          END IF
	          LOG_FSAHA(ID) = LOG( (XG1*XGE/XG0) * T1) - ATM(ID)%EDGEXzV_F(1)*T2
                END IF
              END DO	!ion loop.
!
	      XEDW = ED(L)
              XED_OLD = XEDW
              XERR = 2.0_LDP * EPS
	      DO WHILE (XERR .GT. EPS)
                T3 = 0.0_LDP
                DO ISPEC=1,NUM_SPECIES
                  ISTART = SPECIES_BEG_ID(ISPEC)
                  IF (ISTART.NE.0) THEN
                    IEND = SPECIES_END_ID(ISPEC)
                    T1 = 0.0_LDP
                    T2 = 1.0_LDP
                    DO IW=ISTART+1,IEND
                      T1 =LOG_FSAHA(IW-1) + T1 - LOG(XEDW)
                      T2 = T2 + EXP(T1)
                      LOG_XZW(IW) = T1
                    END DO
                    LOG_XZ(ISTART) = -LOG(T2)
                    DO IW=ISTART+1,IEND
                      LOG_XZ(IW) = LOG_XZW(IW) + LOG_XZ(ISTART)
                      T3 = T3 + EXP(LOG_XZ(IW)) * POP_SPECIES(L,ISPEC) * ATM(IW-1)%ZXzV
                    END DO
                    LOG_XZ(ISTART:IEND) = LOG_XZ(ISTART:IEND) +LOG( POP_SPECIES(L,ISPEC))
                  END IF
                END DO
                XED_OLD = XEDW
                XEDW = T3
                XERR = ABS(1.0_LDP-XED_OLD/XEDW)
              END DO
              ED(L)=XEDW
              LOG_ION_POPS(L,:) = LOG_XZ(:)  	! each entry corresponds to ions ID=1,NUM_IONS
              ION_POPS(L,:) = EXP(LOG_XZ(:))	! each entry corresponds to ions ID=1,NUM_IONS
!
	    END DO	!Only do depths that are not finished
	  END DO	!Loop over L index
!
! Get total ion population for level dissolution. Note that ATM(ID)$ZxzV
! is the charge on the ion AFTER the valence electron is removed
! (i.e., it =1 for HI).
!
	  POPION=0.0_LDP
	  DO ISPEC=1,NUM_SPECIES
	    DO ID=SPECIES_BEG_ID(ISPEC),SPECIES_END_ID(ISPEC)-1
	      IF(ATM(ID)%ZXzV .GT. 1.01_LDP)THEN
	        DO L=1,ND
	          POPION(L)=POPION(L)+ION_POPS(L,ID)
	        END DO
	      END IF
	    END DO
	    IF(SPECIES_BEG_ID(ISPEC) .NE. 0)THEN
	      DO L=1,ND
	        POPION(L)=POPION(L)+ION_POPS(L,SPECIES_END_ID(ISPEC))
	      END DO
	    END IF
	  END DO
!
	END DO		!All Ne are not accurate
!
! Compute the occupation probabilities, first updating the dissolution constants
!
	CALL COMP_LEV_DIS_BLK(ED,POPION,T,DO_LEV_DIS,ND)
	DO ID=1,NUM_IONS
	  IF(ATM(ID)%XzV_PRES)THEN
	    CALL OCCUPATION_PROB(ATM(ID)%W_XZV_F,ATM(ID)%EDGEXzV_F,
	1       ATM(ID)%ZXzV,ATM(ID)%NXzV_F,ND)
	  END IF
	END DO
!
! Compute the LTE populations of the levels in the full atom, taking level
! dissolution into account. We loop backwards over ID in order to have the
! ion population available.
!
	DO ID=NUM_IONS,1,-1
	  IF(ATM(ID)%XzV_PRES)THEN
!
	    DO L=1,ND
	      T1 = 0.0_LDP
	      DO I=1,ATM(ID)%NXzV_F
	        T3 = HDKT*(ATM(ID)%EDGEXzV_F(1)-ATM(ID)%EDGEXzV_F(I))/T(L)
                T2 = LOG(ATM(ID)%W_XzV_F(I,L)*ATM(ID)%GXzV_F(I)) - T3
                ATM(ID)%LOG_XzVLTE_F(I,L) = T2
                T1 = T1 + EXP(T2)
              END DO
	      DO I=1,ATM(ID)%NXzV_F
	        ATM(ID)%LOG_XzVLTE_F(I,L) = ATM(ID)%LOG_XzVLTE_F(I,L) +LOG_ION_POPS(L,ID) - LOG(T1)
	        ATM(ID)%XzVLTE_F(I,L) = EXP(ATM(ID)%LOG_XzVLTE_F(I,L))
	      END DO
	      IF(ATM(ID+1)%XzV_PRES)THEN
	         ATM(ID)%DXzV_F(L)=ATM(ID+1)%XzVLTE_F(1,L)
	      ELSE
	         ATM(ID)%DXzV_F(L)=ION_POPS(L,ID+1)
!	         ATM(ID)%LOG_DXzV_F(L)=ATM(ID+1)%LOG_XzVLTE_F(1,L)
	      END IF
!
	      ATM(ID)%XzVLTE(:,L) = -1.0_LDP
	      TEMP_SUM=1.0_LDP
	      DO I=1,ATM(ID)%NXzV_F
	        K=ATM(ID)%F_TO_S_XzV(I)
	        IF(ATM(ID)%XzVLTE(K,L) .LT. 0.0_LDP)THEN
	          ATM(ID)%LOG_XzVLTE(K,L)=ATM(ID)%LOG_XzVLTE_F(I,L)
	        ELSE
	          TEMP_SUM(K)=TEMP_SUM(K)+EXP(ATM(ID)%LOG_XzVLTE_F(I,L)-ATM(ID)%LOG_XzVLTE(K,L))
	        END IF
	      END DO
	      DO K=1,ATM(ID)%NXzV
	         ATM(ID)%LOG_XzVLTE(K,L)=ATM(ID)%LOG_XzVLTE(K,L)+LOG(TEMP_SUM(K))
	         ATM(ID)%XzVLTE(K,L)=EXP( ATM(ID)%LOG_XzVLTE(K,L) )
	      END DO
	      IF(ATM(ID+1)%XzV_PRES)THEN
	        ATM(ID)%DXzV(L)=ATM(ID+1)%XzVLTE(1,L)
	      ELSE
	        ATM(ID)%DXzV(L)=ION_POPS(L,ID+1)
	        ATM(ID+1)%XzV(1,L)=ION_POPS(L,ID+1)
	        ATM(ID+1)%LOG_XzVLTE(1,L)=LOG_ION_POPS(L,ID+1)
	        ATM(ID+1)%XzVLTE(1,L)=ION_POPS(L,ID+1)
	      END IF
!
	     DO I=1,ATM(ID)%NXzV_F
	       K=ATM(ID)%F_TO_S_XzV(I)
	       T1=EXP(ATM(ID)%LOG_XzVLTE_F(I,L)-ATM(ID)%LOG_XzVLTE(K,L))
               ATM(ID)%XzVLTE_F_ON_S(I,L)=T1
	    END DO

	    END DO 		!Over depth
	  END IF   		!Ion present
	END DO			!Over ion
	DEALLOCATE (TEMP_SUM)
	WRITE(6,*)'Exited DET_ED_V2'; FLUSH(UNIT=6)
!
	RETURN
	END
