!
! Program to test the solution of the large martices generated by
! CMFGEN. The routine reads in the file BA_ASCI_N_DX (X=depth) and generates
! the solution.
!
	PROGRAM CHECK_BA_ESTIMATES
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	USE MOD_COLOR_PEN_DEF
!
! Altered 24-Jun-2009: Depth of matrix now input.
!
	IMPLICIT NONE
	INTEGER ID
	INTEGER NT,I
	INTEGER IOS
	LOGICAL FILE_OPEN
	CHARACTER(LEN=80) STRING
	CHARACTER(LEN=200) FILE_NAME_A
	CHARACTER(LEN=200) FILE_NAME_B
	INTEGER, PARAMETER :: LU=10
!
	REAL(KIND=LDP), ALLOCATABLE :: POPS_A(:)
	REAL(KIND=LDP), ALLOCATABLE :: STEQ_A(:)
	REAL(KIND=LDP), ALLOCATABLE :: CMAT_A(:,:)
!
	REAL(KIND=LDP), ALLOCATABLE :: POPS_B(:)
	REAL(KIND=LDP), ALLOCATABLE :: STEQ_B(:)
	REAL(KIND=LDP), ALLOCATABLE :: CMAT_B(:,:)
!
	REAL(KIND=LDP), ALLOCATABLE :: PRED_CHNG(:)
	REAL(KIND=LDP), ALLOCATABLE :: ACT_CHNG(:)
	REAL(KIND=LDP), ALLOCATABLE :: RATIO(:)
	REAL(KIND=LDP), ALLOCATABLE :: XV(:)
!
	REAL(KIND=LDP) T1
!
	WRITE(6,'(A)')BLUE_PEN
	WRITE(6,'(A)')' Program to compare the predicted change in STEQ with the actual change'
	WRITE(6,'(A)')' In general change only one value at one depth per test'
	WRITE(6,'(A)')' For a proper test, changes should be small -- .e.g., 1%'
	WRITE(6,'(A)')' Generally you should run this program in the CHANGE directory'
	WRITE(6,'(A)')DEF_PEN
!	

	OPEN(UNIT=20,FILE='MODEL',STATUS='OLD',IOSTAT=IOS)
	  IF(IOS .EQ. 0)THEN
	    DO WHILE(1 .EQ. 1)
	      READ(20,'(A)',IOSTAT=IOS)STRING
	      IF(IOS .NE. 0)EXIT
	      IF(INDEX(STRING,'!Total number of variables') .NE. 0)THEN
	        READ(STRING,*)NT
	        WRITE(6,'(A,I4)')' Number of variables in the model is: ',NT
	        EXIT
	      END IF
	    END DO
	  END IF
	  INQUIRE(UNIT=20,OPENED=FILE_OPEN)
	IF(FILE_OPEN)CLOSE(UNIT=20)
!
	IF(IOS .NE. 0)THEN
	  NT=0
	  WRITE(6,*)' Unable to open/read MODEL file to get # of variables'
	  CALL GEN_IN(NT,'Number of elements (==NT in MODEL)')
	END IF
	IF(NT .EQ. 0)THEN
	  WRITE(6,*)'Invalid number of elements'
	  WRITE(6,*)'Check NT in file MODEL'
	  STOP
	END IF
!
	WRITE(6,'(A)')RED_PEN
	WRITE(6,'(A)')' The BA matrix in the 2nd directory is used to predict the corrections'
	WRITE(6,'(A)')' The output is written to fort.23'
	WRITE(6,'(A)')DEF_PEN
!	
	ID=51
	CALL GEN_IN(ID,'Depth indicator: i.e., X in BA_ASCI_N_DX:')
	WRITE(FILE_NAME_A,'(I3)')ID
	FILE_NAME_A='BA_ASCI_N_D'//ADJUSTL(FILE_NAME_A)
	FILE_NAME_B='../a4_65nodt_1it/'
	CALL GEN_IN(FILE_NAME_B,'Directory with other model')
	FILE_NAME_B=TRIM(FILE_NAME_B)//TRIM(FILE_NAME_A)
!
	ALLOCATE (POPS_A(NT))
	ALLOCATE (STEQ_A(NT))
	ALLOCATE (CMAT_A(NT,NT))
!
	ALLOCATE (POPS_B(NT))
	ALLOCATE (STEQ_B(NT))
	ALLOCATE (CMAT_B(NT,NT))
!
	ALLOCATE (PRED_CHNG(NT))
	ALLOCATE (ACT_CHNG(NT))
	ALLOCATE (RATIO(NT))
	ALLOCATE (XV(NT))
!
	WRITE(6,'(A)')' '
	CALL RD_BA_MAT(CMAT_A,STEQ_A,POPS_A,NT,FILE_NAME_A,LU)
	CALL RD_BA_MAT(CMAT_B,STEQ_B,POPS_B,NT,FILE_NAME_B,LU)
	WRITE(6,'(A)')' '
!
	WRITE(23,'(A,7X,A,10X,A,3X,A,2X,A,9X,A)')' Index','SL Pops','STEQ',
	1            'Act. Change','Pred. Change','Ratio'
	DO I=1,NT
	 XV(I)=I
	 PRED_CHNG(I)=CMAT_B(I,NT)*(POPS_B(NT)/POPS_A(NT)-1.0_LDP)
	 ACT_CHNG(I)=STEQ_B(I)-STEQ_A(I)
	 RATIO(I)=0.0_LDP
	 IF(ACT_CHNG(I) .NE. 0.0_LDP)RATIO(I)=PRED_CHNG(I)/ACT_CHNG(I)
	 WRITE(23,'(I6,5ES14.4,3X,F12.3)')I,POPS_A(I),STEQ_A(I),ACT_CHNG(I),PRED_CHNG(I),RATIO(I)
	END DO
!
	WRITE(6,'(A)')' '
	WRITE(6,'(A)')' Plotting changes as a function of variable index'
	WRITE(6,'(A)')' '
	CALL DP_CURVE(NT,XV,RATIO)
	CALL GRAMON_PGPLOT('Index','Pred/Act Change',' ',' ')
!
	WRITE(6,'(A)')' '
	WRITE(6,'(A)')' Plotting changes as a function of level population'
	WRITE(6,'(A)')' Use XAR with LG to switch to a logaritmix X axis'
	WRITE(6,'(A)')' '
	CALL DP_CURVE(NT,POPS_A,RATIO)
	CALL GRAMON_PGPLOT('Population','Pred/Act Change',' ',' ')
!
	STOP
	END
