	PROGRAM PLT_DDT_WORK
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	IMPLICIT NONE
!
	INTEGER, PARAMETER :: ND_MAX=500
!
	REAL(KIND=LDP) R(ND_MAX)
	REAL(KIND=LDP) ED(ND_MAX)
!
	REAL(KIND=LDP) XVEC(ND_MAX)
	REAL(KIND=LDP) T(ND_MAX)
	REAL(KIND=LDP) OLD_T(ND_MAX)
	REAL(KIND=LDP) ER(ND_MAX)
	REAL(KIND=LDP) OLD_ER(ND_MAX)
	REAL(KIND=LDP) EK(ND_MAX)
	REAL(KIND=LDP) OLD_EK(ND_MAX)
	REAL(KIND=LDP) IE(ND_MAX)
	REAL(KIND=LDP) OLD_IE(ND_MAX)
!
	REAL(KIND=LDP) CHI(ND_MAX)
	REAL(KIND=LDP) RSQJ(ND_MAX)
	REAL(KIND=LDP) RSQH(ND_MAX)
	REAL(KIND=LDP) OLD_RSQJ(ND_MAX)
	REAL(KIND=LDP) E_RSQJ(ND_MAX)
	REAL(KIND=LDP) T1
!
	CHARACTER*80 FILENAME
	CHARACTER*80 STRING
!
	INTEGER I,J
	INTEGER ND
	INTEGER IOS
	LOGICAL FILE_OPEN
!
	OPEN(UNIT=20,FILE='MODEL',STATUS='OLD',IOSTAT=IOS)
	  IF(IOS .EQ. 0)THEN
	    DO WHILE(1 .EQ. 1)
	      READ(20,'(A)',IOSTAT=IOS)STRING
	      IF(IOS .NE. 0)EXIT
	      IF(INDEX(STRING,'!Number of depth points') .NE. 0)THEN
	        READ(STRING,*)ND
	        WRITE(6,'(A,I4)')' Number of depth points in the model is:',ND
	        EXIT
	      END IF
	    END DO
	  END IF
	 INQUIRE(UNIT=20,OPENED=FILE_OPEN)
	IF(FILE_OPEN)CLOSE(UNIT=20)
!
	IF(IOS .NE. 0)THEN
	  WRITE(6,*)' Unable to open MODEL file to get # of depth points'
	  CALL GEN_IN(ND,'Number of depth points')
	END IF
!
 	FILENAME='DDT_WORK_CHK'
	CALL GEN_IN(FILENAME,'DDT_WORK_CHK file with data to be plotted')
	OPEN(UNIT=11,FILE=FILENAME,STATUS='OLD',ACTION='READ')
	  STRING=' '
	  DO WHILE(INDEX(STRING,'ER(cur)') .EQ. 0)
	    READ(11,'(A)')STRING
	  END DO
	  DO I=1,ND
	    READ(11,*)XVEC(I),T(I),OLD_T(I),ER(I),OLD_ER(I),EK(I),OLD_EK(I),IE(I),OLD_IE(I)
	  END DO
	CLOSE(UNIT=11)
!
 	FILENAME='SN_GREY_CHK'
	CALL GEN_IN(FILENAME,'SN_GREY_CHK file with data to be plotted')
	OPEN(UNIT=11,FILE=FILENAME,STATUS='OLD',ACTION='READ')
	  STRING=' '
	  DO WHILE(INDEX(STRING,'RSQJ_OLD') .EQ. 0)
	    READ(11,'(A)')STRING
	  END DO
	  DO I=1,ND
	    READ(11,*)J,R(I),CHI(I),RSQJ(I),OLD_RSQJ(I),RSQH(I)
	  END DO
	  T1=4.0_LDP*(4.0_LDP*ATAN(1.0_LDP))/2.998E+10_LDP
	  DO I=1,ND
	    E_RSQJ(I)=RSQJ(I)*T1/R(I)/R(I)
	  END DO
	CLOSE(UNIT=11)
!
	WRITE(6,*)'Plotting ER(T), Thermal Energy, and Internal Energy'
	CALL DP_CURVE(ND,XVEC,ER)
	CALL DP_CURVE(ND,XVEC,EK)
	CALL DP_CURVE(ND,XVEC,IE)
	CALL DP_CURVE(ND,XVEC,E_RSQJ)
	CALL GRAMON_PGPLOT('Depth index','Energy',' ',' ')
!
	STOP
	END
