!
! Auxilary program designed to modify the HYDRO file output from CMFGEN.
! Progam modifies the adopted stellar mass. Not that the percentage error
! os now defined so that it has a rang of pm 200%.
!
	PROGRAM PLT_HYDRO
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	USE MOD_COLOR_PEN_DEF
	USE READ_KEYWORD_INTERFACE
!
! Altered 06-Sep-2022 :  Minor bug fix when RVTJ not found (30-Aug-2022).
! Altered 09-Jan-2021 :  Altered to read in HYDRO files with different sets of columns.
!                        The HYDRO file can  have extra columns but the same header
!                        ID must be the same in all formats.

	IMPLICIT NONE
!
	INTEGER I,J,K,IOS
	INTEGER NSTR
	INTEGER NVECS
	INTEGER ND,ND2
	INTEGER NMOD
	INTEGER ID
	INTEGER, PARAMETER :: LU_IN=7
	INTEGER, PARAMETER :: LU_OUT=11
	INTEGER, PARAMETER :: T_OUT=6
	INTEGER, PARAMETER :: IZERO=0
	INTEGER, PARAMETER :: IONE=1
	LOGICAL, PARAMETER :: L_FALSE=.FALSE.
	LOGICAL, PARAMETER :: L_TRUE=.TRUE.
!
	REAL(KIND=LDP) GRAV_CON
	REAL(KIND=LDP) T1,T2,T3,T4
	REAL(KIND=LDP) STAR_MASS
	REAL(KIND=LDP) GRAVITATIONAL_CONSTANT, MASS_SUN,BOLTZMANN_CONSTANT
	EXTERNAL GRAVITATIONAL_CONSTANT, MASS_SUN,BOLTZMANN_CONSTANT
	INTEGER GET_HYDRO_VEC_LOC
	EXTERNAL GET_HYDRO_VEC_LOC
!
	CHARACTER(LEN=200) STRING
	CHARACTER*132 TMP_STRING
	CHARACTER*132 FMT
	CHARACTER*132 FILENAME,RVTJ_FILE_NAME
	CHARACTER(LEN=80) XLAB,YLAB,TIT
	CHARACTER(LEN=10) XOPT
!
	TYPE HYDRO_DATA
	  REAL(KIND=LDP), ALLOCATABLE :: R(:)
	  REAL(KIND=LDP), ALLOCATABLE :: VEL(:)
	  REAL(KIND=LDP), ALLOCATABLE :: dVdR(:)
	  REAL(KIND=LDP), ALLOCATABLE :: VdVdR(:)
	  REAL(KIND=LDP), ALLOCATABLE :: dPdR(:)
	  REAL(KIND=LDP), ALLOCATABLE :: dTPdR(:)
	  REAL(KIND=LDP), ALLOCATABLE :: REQ(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GRAD(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GELEC(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GAM(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GTOT(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GRAV(:)
	  REAL(KIND=LDP), ALLOCATABLE :: ED(:)
	  REAL(KIND=LDP), ALLOCATABLE :: ATOM(:)
	  REAL(KIND=LDP), ALLOCATABLE :: TEMP(:)
	  REAL(KIND=LDP), ALLOCATABLE :: GAS_PRES(:)
	  REAL(KIND=LDP), ALLOCATABLE :: TA(:)
	  REAL(KIND=LDP), ALLOCATABLE :: TB(:)
	  REAL(KIND=LDP), ALLOCATABLE :: XVEC(:)
	  REAL(KIND=LDP), ALLOCATABLE :: YVEC(:)
	  REAL(KIND=LDP), ALLOCATABLE :: ZVEC(:)
	  REAL(KIND=LDP), ALLOCATABLE :: SOUND(:)
	  REAL(KIND=LDP), ALLOCATABLE :: TAU(:)
	  REAL(KIND=LDP), ALLOCATABLE :: CLUMP_FAC(:)
	  REAL(KIND=LDP), ALLOCATABLE :: DENSITY(:)
	  REAL(KIND=LDP), ALLOCATABLE :: TAU_FLUX(:)
	  REAL(KIND=LDP), ALLOCATABLE :: FLUX_MEAN(:)
	  REAL(KIND=LDP) STARS_MASS
	  REAL(KIND=LDP) STARS_MDOT
	  REAL(KIND=LDP) DEP_WIND_MOM
	  REAL(KIND=LDP) WIND_MOM_MDOT
	  REAL(KIND=LDP) TAU_SONIC
	  REAL(KIND=LDP) R_SONIC
	  REAL(KIND=LDP) C_SONIC
	  INTEGER ND
	  CHARACTER(LEN=80) DIR_NAME
	END TYPE HYDRO_DATA
	TYPE(HYDRO_DATA) ATM(20)
!
	REAL(KIND=LDP), ALLOCATABLE :: DATA_VECS(:,:)
	REAL(KIND=LDP), ALLOCATABLE :: COEF(:,:)
	LOGICAL TMP_LOG
	LOGICAL OLD_FORMAT
	LOGICAL PLANE_PARALLEL
	CHARACTER(LEN=1) DIR_DELIMITER
	EXTERNAL DIR_DELIMITER
!
	XLAB=' '; YLAB=' '
	NMOD=0
	GRAV_CON=1.0E-20_LDP*GRAVITATIONAL_CONSTANT()*MASS_SUN()
!
5000	CONTINUE
	XOPT='P'
	IF(NMOD .EQ. 0)XOPT='RD_MOD'
	CALL GEN_IN(XOPT,'Option to set plot or to plot (P)')
	CALL SET_CASE_UP(XOPT,IZERO,IZERO)
!
	IF(XOPT .EQ. 'RDM' .OR. XOPT .EQ. 'RD_MOD')THEN
	  NMOD=NMOD+1
	  ATM(NMOD)%DIR_NAME=' '
	  CALL GET_ENVIRONMENT_VARIABLE('PWD',ATM(NMOD)%DIR_NAME)
	  CALL GEN_IN(ATM(NMOD)%DIR_NAME,'Directory with HYDRO file')
	  K=LEN_TRIM(ATM(NMOD)%DIR_NAME)
	  IF(K .NE. 0 .AND. ATM(NMOD)%DIR_NAME(K:K) .NE.
	1       DIR_DELIMITER())ATM(NMOD)%DIR_NAME(K+1:K+1)=DIR_DELIMITER()
	  FILENAME=TRIM(ATM(NMOD)%DIR_NAME)//'MODEL_SPEC'
	  WRITE(6,'(A)')TRIM(FILENAME)
	  OPEN(UNIT=20,FILE=FILENAME,STATUS='OLD',IOSTAT=IOS)
          READ(20,'(A)',IOSTAT=IOS)STRING
	  IF(INDEX(STRING,'[ND]') .NE. 0)THEN
	    READ(STRING,*)ATM(NMOD)%ND
	  ELSE
	    NMOD=NMOD-1
	    WRITE(6,*)'Invalid error reading MODEL_SPEC'
	    GOTO 5000
	  END IF
	  WRITE(6,*)'Number of depth points is',ATM(NMOD)%ND
	  CLOSE(UNIT=20)
!
	  ID=NMOD; ND=ATM(ID)%ND
	  ALLOCATE(ATM(ID)%R(ND))
	  ALLOCATE(ATM(ID)%VEL(ND))
	  ALLOCATE(ATM(ID)%dVdR(ND))
	  ALLOCATE(ATM(ID)%VdVdR(ND))
	  ALLOCATE(ATM(ID)%dPdR(ND))
	  ALLOCATE(ATM(ID)%dTPdR(ND))
	  ALLOCATE(ATM(ID)%REQ(ND))
	  ALLOCATE(ATM(ID)%GRAD(ND))
	  ALLOCATE(ATM(ID)%GAM(ND))
	  ALLOCATE(ATM(ID)%GELEC(ND))
	  ALLOCATE(ATM(ID)%GTOT(ND))
	  ALLOCATE(ATM(ID)%GRAV(ND))
	  ALLOCATE(ATM(ID)%ED(ND))
	  ALLOCATE(ATM(ID)%TEMP(ND));  ATM(ID)%TEMP=0.0_LDP
	  ALLOCATE(ATM(ID)%GAS_PRES(ND)); ATM(ID)%GAS_PRES=0.0_LDP
	  ALLOCATE(ATM(ID)%TA(ND))
	  ALLOCATE(ATM(ID)%TB(ND))
	  ALLOCATE(ATM(ID)%XVEC(ND))
	  ALLOCATE(ATM(ID)%YVEC(ND))
	  ALLOCATE(ATM(ID)%ZVEC(ND))
	  ALLOCATE(ATM(ID)%TAU(ND));           ATM(ID)%TAU=0.0_LDP
	  ALLOCATE(ATM(ID)%SOUND(ND));         ATM(ID)%SOUND=0.0_LDP
	  ALLOCATE(ATM(ID)%ATOM(ND));          ATM(ID)%ATOM=0.0_LDP
	  ALLOCATE(ATM(ID)%CLUMP_FAC(ND));     ATM(ID)%CLUMP_FAC=0.0_LDP
	  ALLOCATE(ATM(ID)%DENSITY(ND));       ATM(ID)%DENSITY=0.0_LDP
	  ALLOCATE(ATM(ID)%TAU_FLUX(ND));      ATM(ID)%TAU_FLUX=0.0_LDP
	  ALLOCATE(ATM(ID)%FLUX_MEAN(ND));     ATM(ID)%FLUX_MEAN=0.0_LDP
!
	  FILENAME=TRIM(ATM(NMOD)%DIR_NAME)//'VADAT'
	  INQUIRE(FILE=FILENAME,EXIST=TMP_LOG)
	  IF(TMP_LOG)THEN
	    ATM(ID)%STARS_MASS=0.0_LDP
	    CALL READ_KEYWORD(ATM(ID)%STARS_MASS,'[MASS]',L_FALSE,FILENAME,L_TRUE,L_FALSE,10)
	    CALL READ_KEYWORD(ATM(ID)%STARS_MDOT,'[MDOT]',L_FALSE,FILENAME,L_FALSE,L_TRUE,10)
	  END IF
	  IF(ATM(ID)%STARS_MASS .EQ. 0.0_LDP)CALL GEN_IN(ATM(ID)%STARS_MASS,'Stars surface gravity')
	  IF(ATM(ID)%STARS_MDOT .EQ. 0.0_LDP)CALL GEN_IN(ATM(ID)%STARS_MDOT,'Stars mass loss rate')
!
	  OLD_FORMAT=.TRUE.
	  FILENAME=TRIM(ATM(ID)%DIR_NAME)//'HYDRO'
	  WRITE(6,'(A)')TRIM(FILENAME)
	  OPEN(UNIT=10,FILE=TRIM(FILENAME),ACTION='READ',STATUS='OLD')
	  READ(10,'(A)')STRING
!
! Note: The value of NVECS returned is NHEAD+1.
!
	  CALL SET_HYDRO_HD_LOC(STRING,NVECS)
	  WRITE(6,*)'ID=',ID,'NVECS=',NVECS
	  IF(ALLOCATED(DATA_VECS))DEALLOCATE(DATA_VECS)
	  ALLOCATE(DATA_VECS(ATM(ID)%ND,NVECS)); DATA_VECS=0.0_LDP
!
! Note: NEVCS is used as dummey vector set to zero.
!
	  DO I=1,ATM(ID)%ND
	    READ(10,*)(DATA_VECS(I,J),J=1,NVECS-1)
	  END DO
	  CLOSE(UNIT=10)
	  J=GET_HYDRO_VEC_LOC('R');         ATM(ID)%R=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('V');         ATM(ID)%VEL=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('VdVdR');     ATM(ID)%VdVDR=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('dPdR/ROH');  ATM(ID)%dPdR=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('dTPdR/ROH'); ATM(ID)%dTPdR=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('g_TOT');     ATM(ID)%GTOT=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('g_RAD');     ATM(ID)%GRAD=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('g_ELEC');    ATM(ID)%GELEC=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('Gamma');     ATM(ID)%GAM=DATA_VECS(:,J)
	  J=GET_HYDRO_VEC_LOC('Vsound');    ATM(ID)%SOUND=DATA_VECS(:,J)
!
	  DO I=1,ATM(ID)%ND
	    ATM(ID)%GRAV(I)=ATM(ID)%GRAD(I)/ATM(ID)%GAM(I)
	    ATM(ID)%dVdR(I)=1.0E-05_LDP*ATM(ID)%VdVdR(I)/ATM(ID)%VEL(I)
	    ATM(ID)%REQ(I)=ATM(ID)%VdVdR(I)+ATM(ID)%dPdR(I)+ATM(ID)%dTPdR(I)+ATM(ID)%GRAV(I)
	  END DO
!
	  WRITE(6,*)' '
	  WRITE(6,*)'All models have their X-axis set to V'
	  WRITE(6,*)' '
	  ND=ATM(ID)%ND
	  ATM(ID)%XVEC(1:ND)=ATM(ID)%VEL(1:ND)
	  XLAB='V(km/s)'
!
	  ND=ATM(ID)%ND
	  IOS=1
	  RVTJ_FILE_NAME=TRIM(ATM(ID)%DIR_NAME)//'RVTJ'
	  DO WHILE(IOS .NE. 0)
            OPEN(UNIT=LU_IN,FILE=RVTJ_FILE_NAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
            IF(IOS .NE. 0)THEN
	      WRITE(T_OUT,*)'Unable to open RVTJ: IOS=',IOS
	      RVTJ_FILE_NAME='../RVTJ'
              CALL GEN_IN(RVTJ_FILE_NAME,'File with R, V, T etc (RVTJ)')
	      IF(RVTJ_FILE_NAME .EQ. ' ')GOTO 5000
	    END IF
          END DO
	  STRING=' '
	  DO WHILE(ATM(ID)%ATOM(1) .EQ. 0.0_LDP .OR. ATM(ID)%CLUMP_FAC(1) .EQ. 0.0_LDP)
	    READ(LU_IN,'(A)')STRING
	    IF(INDEX(STRING,'Atom Density') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%ATOM(I),I=1,ND)
	    ELSE IF(INDEX(STRING,'Electron density') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%ED(I),I=1,ND)
	    ELSE IF(INDEX(STRING,'Temperature') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%TEMP(I),I=1,ND)
	    ELSE IF(INDEX(STRING,'Clumping Factor') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%CLUMP_FAC(I),I=1,ND)
	    ELSE IF(INDEX(STRING,'Mass Density') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%DENSITY(I),I=1,ND)
	    ELSE IF(INDEX(STRING,'Flux Mean') .NE. 0)THEN
	      READ(LU_IN,*)(ATM(ID)%FLUX_MEAN(I),I=1,ND)
	    END IF
	    ATM(ID)%GAS_PRES=1.0E+04_LDP*BOLTZMANN_CONSTANT()*(ATM(ID)%ED+ATM(ID)%ATOM)*ATM(ID)%TEMP
	  END DO
          CLOSE(LU_IN)
!
	ELSE IF(XOPT .EQ. 'LM')THEN
	  DO ID=1,NMOD
	    WRITE(6,'(1X,I3,3X,A)')ID,TRIM(ATM(ID)%DIR_NAME)
	  END DO
!
	ELSE IF(XOPT .EQ. 'P')THEN
	  IF(YLAB(1:1) .EQ. ';')YLAB(1:)=YLAB(2:)
	  CALL GRAMON_PGPLOT(XLAB,YLAB,' ',' ')
	  YLAB=' '
!
	ELSE IF(XOPT .EQ. 'H' .OR. XOPT(1:2) .EQ. 'HE' .OR. XOPT .EQ. '?')THEN
	   WRITE(6,*)RED_PEN
	   WRITE(6,*)' '
	   WRITE(6,*)'LM      -- list models'
	   WRITE(6,*)' '
	   WRITE(6,*)'XVdVdR  -- set X axis to VdVdR'
	   WRITE(6,*)'XVEL    -- set X axis to V(km/s)'
	   WRITE(6,*)'XR      -- set X axis to R/R(ND)'
	   WRITE(6,*)'XT      -- set X axis to CAL t parameter'
	   WRITE(6,*)' '
!
	   WRITE(6,*)'GRAD    -- plot g(rad)'
	   WRITE(6,*)'GELEC   -- plot g(elec)'
	   WRITE(6,*)'GRAV    -- plot g'
	   WRITE(6,*)'dPdR    -- plot (1/roh).dP/dr'
	   WRITE(6,*)'dVdR    -- plot dV/dR'
	   WRITE(6,*)'PRES    -- plot gas pressure'
	   WRITE(6,*)'CDP     -- plot individual derivatives of 1/rho dP/dr components'
	   WRITE(6,*)'MOM     -- plot momentum dep'
!
	   WRITE(6,*)' '
	   WRITE(6,*)'REQ     -- plot VdVdR+dPdR+dTPdR+g'
	   WRITE(6,*)'NGL     -- plot g_l/(g-g_e)'
	   WRITE(6,*)'NREQ    -- plot (VdVdR+dPdR+dTPdR+g)/g_e'
	   WRITE(6,*)'NGRAD   -- plot g_r/g_e'
	   WRITE(6,*)'NERR    -- plot (VdVdR+dPdR+dTPdR+g_r)/(g_r or gr_r-g_e)'
 !
	   WRITE(6,*)DEF_PEN
!
	ELSE IF(XOPT .EQ. 'XVEL')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%XVEC(1:ND)=ATM(ID)%VEL(1:ND)
	  END DO
	  XLAB='V(km/s)'
!
	ELSE IF(XOPT .EQ. 'XVEL')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%XVEC(1:ND)=LOG10(ATM(ID)%VEL(1:ND))
	  END DO
	  XLAB='Log V(km/s)'
!
	ELSE IF(XOPT .EQ. 'XDVDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%XVEC(1:ND)=1000.0_LDP*ATM(ID)%dVdR(1:ND)
	  END DO
	  XLAB='dV/dR(s\u-1\d)'
!
	ELSE IF(XOPT .EQ. 'XVDVDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%XVEC(1:ND)=ATM(ID)%VdVdR(1:ND)
	  END DO
	  XLAB='VdV/dR(cm s\u-2\d)'
!
	ELSE IF(XOPT .EQ. 'XT' .OR. XOPT .EQ. 'YT')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
!
! 1.0D+06 -- Vth=10 km/s. Makes t dimensionless.
!
	    IF(XOPT .EQ. 'YT')THEN
	      YLAB='t'
	      ATM(ID)%YVEC(1:ND)=ATM(ID)%ATOM(1:ND)*6.65E-25_LDP*10.0E+05_LDP/ATM(ID)%dVdR(1:ND)
	      CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	    ELSE
	      XLAB='t'
	      ATM(ID)%XVEC(1:ND)=ATM(ID)%ATOM(1:ND)*6.65E-25_LDP*10.0E+05_LDP/ATM(ID)%dVdR(1:ND)
	    END IF
	  END DO
!
	ELSE IF(XOPT .EQ. 'XR')THEN
	  TMP_LOG=.TRUE.
	  CALL GEN_IN(TMP_LOG,'Normalize by RCORE?')
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(TMP_LOG)THEN
	      ATM(ID)%XVEC(1:ND)=ATM(ID)%R(1:ND)/ATM(ID)%R(ND)
	    ELSE
	      ATM(ID)%XVEC(1:ND)=ATM(ID)%R(1:ND)
	    END IF
	  END DO
	  XLAB='R/R(ND)'
	  IF(.NOT. TMP_LOG)XLAB='R(10\u10\d cm)'
!
	ELSE IF(XOPT .EQ. 'XLOGR')THEN
	  TMP_LOG=.TRUE.
	  CALL GEN_IN(TMP_LOG,'Normalize by RCORE?')
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(TMP_LOG)THEN
	      ATM(ID)%XVEC(1:ND)=LOG10(ATM(ID)%R(1:ND)/ATM(ID)%R(ND))
	    ELSE
	      ATM(ID)%XVEC(1:ND)=LOG10(ATM(ID)%R(1:ND))
	    END IF
	  END DO
	  XLAB='R/R(ND)'
	  IF(TMP_LOG)XLAB='Log R(10\u10\d cm)'
!
	ELSE IF(XOPT .EQ. 'VEL')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%YVEC(1:ND)=ATM(ID)%VEL(1:ND)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB='V(km/s)'
!
	ELSE IF(XOPT .EQ. 'PRES')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%GAS_PRES)
	  END DO
	  YLAB='P(dyne/cm\u2\d)'
!
	ELSE IF(XOPT .EQ. 'DVDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%YVEC(1:ND)=ATM(ID)%dVdR(1:ND)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB='dV/dR(s\u-1\d)'
!
	ELSE IF(XOPT .EQ. 'VDVDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%YVEC(1:ND)=ATM(ID)%VdVdR(1:ND)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB='VdV/dR(cm s\u-2\d)'
!
	ELSE IF(XOPT .EQ. 'INT')THEN
!
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    I=0
	    T1=0.0_LDP
	    DO WHILE(ATM(ID)%VEL(I+1) .GT. 30.0_LDP)
	      I=I+1
	      ATM(ID)%XVEC(I)=ATM(ID)%R(I)
	      ATM(ID)%YVEC(I)=(2.00_LDP*ATM(ID)%GRAD(I)+(1.0_LDP-T1)*ATM(ID)%GRAD(I))/ATM(ID)%VEL(I)/3.0_LDP
	      ATM(ID)%ZVEC(I)=(ATM(ID)%GRAV(I)-T1*ATM(ID)%GRAD(I)/3.0_LDP)/ATM(ID)%VEL(I)
	      WRITE(6,'(I5,4ES14.6)')I,ATM(ID)%GRAV(I),ATM(ID)%GRAD(I),ATM(ID)%YVEC(I),ATM(ID)%ZVEC(I)
	    END DO
!
	    T1=0.0_LDP; T2=0.0_LDP
	    DO J=1,I-1
	      T1=T1+(ATM(ID)%XVEC(J)-ATM(ID)%XVEC(J+1))*(ATM(ID)%YVEC(J)+ATM(ID)%YVEC(J+1)) 	
	      T2=T2+(ATM(ID)%XVEC(J)-ATM(ID)%XVEC(J+1))*(ATM(ID)%ZVEC(J)+ATM(ID)%ZVEC(J+1)) 	
	    END DO
	    T1=0.5_LDP*T1; T2=0.5_LDP*T2
	    WRITE(6,*)T1,T2
	    T2=T2+(ATM(ID)%VEL(1)-ATM(ID)%VEL(I))
	    T1=T1/T2
	    WRITE(6,*)'Factor to revise mass loss rate us',T1
	    WRITE(6,*)'Vinf factor is',T2
	    DO J=1,I
	      ATM(ID)%YVEC(J)=2.3205_LDP*ATM(ID)%YVEC(J)*ATM(ID)%R(J)/ATM(ID)%VEL(1)
	      ATM(ID)%ZVEC(J)=2.3205_LDP*ATM(ID)%ZVEC(J)*ATM(ID)%R(J)/ATM(ID)%VEL(1)
	      ATM(ID)%XVEC(J)=LOG10(ATM(ID)%R(J)/ATM(ID)%R(I))
	    END DO
	    WRITE(6,*)'Scaling radius for X-axis is: ',ATM(ID)%VEL(I)
	    CALL DP_CURVE(I,ATM(ID)%XVEC,ATM(ID)%YVEC)
	    CALL DP_CURVE(I,ATM(ID)%XVEC,ATM(ID)%ZVEC)
	  END DO
	  XLAB='Log R'
!
	ELSE IF(XOPT .EQ. 'DPDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%dPdR)
	  END DO
	  YLAB=TRIM(YLAB)//'; \gr\u-1\d dP\dg\u/dr'
!
	ELSE IF(XOPT .EQ. 'CDP')THEN
!
	  WRITE(6,'(A)')' '
	  WRITE(6,'(A)')' -2a^2/r'
	  WRITE(6,'(A)')' -a^2 dlnVdR/'
	  WRITE(6,'(A)')' 2a.da/dr'
	  WRITE(6,'(A)')' -a2.dlnf/dr'
	  WRITE(6,'(A)')' '
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%YVEC=-2.0_LDP*ATM(ID)%SOUND**2/ATM(ID)%R
	    ATM(ID)%ZVEC=ATM(ID)%YVEC
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
!
	    ATM(ID)%YVEC=-1.0E+05_LDP*ATM(ID)%SOUND**2*ATM(ID)%dVdR/ATM(ID)%VEL
	    ATM(ID)%ZVEC=ATM(ID)%ZVEC+ATM(ID)%YVEC
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
!
	    CALL DERIVCHI(ATM(ID)%YVEC,ATM(ID)%SOUND,ATM(ID)%R,ND,'LINMON')
	    ATM(ID)%YVEC=2.0_LDP*ATM(ID)%SOUND*ATM(ID)%YVEC
	    ATM(ID)%ZVEC=ATM(ID)%ZVEC+ATM(ID)%YVEC
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
!
	    CALL DERIVCHI(ATM(ID)%YVEC,ATM(ID)%CLUMP_FAC,ATM(ID)%R,ND,'LINMON')
	    ATM(ID)%YVEC=-ATM(ID)%SOUND**2*ATM(ID)%YVEC/ATM(ID)%CLUMP_FAC
	    ATM(ID)%ZVEC=ATM(ID)%ZVEC+ATM(ID)%YVEC
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
!
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%ZVEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; \gr\u-1\d dP\dg\u/dr'
!
	ELSE IF(XOPT .EQ. 'MOM')THEN
!
	  DO ID=1,NMOD
!
! Compute the flux mean optical depth scale.
!
	    ATM(ID)%TAU_FLUX(1)=ATM(ID)%FLUX_MEAN(1)*ATM(ID)%R(1)
	    DO I=2,ND
	       ATM(ID)%TAU_FLUX(I)=ATM(ID)%TAU_FLUX(I-1)+0.5_LDP*(ATM(ID)%R(I-1)-ATM(ID)%R(I))*
	1                           (ATM(ID)%FLUX_MEAN(I-1)*ATM(ID)%CLUMP_FAC(I-1) +
	1                            ATM(ID)%FLUX_MEAN(I)*ATM(ID)%CLUMP_FAC(I) )
	    END DO
	    ATM(ID)%TAU_SONIC=ATM(ID)%TAU_FLUX(K)
!
! Get the sound speed and the location of the sonic point.
!
	    DO I=1,ND
	      IF(ATM(ID)%SOUND(I) .GT. ATM(ID)%VEL(I))THEN
	        K=I
	        EXIT
	      END IF
	    END DO
	    T1=ATM(ID)%VEL(K); T2=(ATM(ID)%VEL(K-1)-ATM(ID)%VEL(K))/(ATM(ID)%R(K-1)-ATM(ID)%R(K))
	    T3=ATM(ID)%SOUND(K); T4=(ATM(ID)%SOUND(K-1)-ATM(ID)%SOUND(K))/(ATM(ID)%R(K-1)-ATM(ID)%R(K))
	    ATM(ID)%R_SONIC=(T1-T3)/(T4-T2)		!Initially dR
	    ATM(ID)%C_SONIC=T3+ATM(ID)%R_SONIC*T4
	    ATM(ID)%R_SONIC=ATM(ID)%R_SONIC+ATM(ID)%R(K)
	    WRITE(6,*)ID,ATM(ID)%R_SONIC,ATM(ID)%C_SONIC
!
	    ATM(ID)%TA(:)=0.0_LDP; ATM(ID)%TB(:)=0.0_LDP
	    DO I=K-1,1,-1
	       T2=0.5E+10_LDP*(ATM(ID)%R(I)-ATM(ID)%R(I+1))
	       ATM(ID)%TA(I)=ATM(ID)%TA(I+1)+ T2*( (ATM(ID)%GAM(I)-1.0_LDP)*ATM(ID)%DENSITY(I)*ATM(ID)%CLUMP_FAC(I) +
	1                                        (ATM(ID)%GAM(I+1)-1.0_LDP)*ATM(ID)%DENSITY(I+1)*ATM(ID)%CLUMP_FAC(I+1) )
	       T3=ATM(ID)%dPdR(I)*ATM(ID)%DENSITY(I)*ATM(ID)%CLUMP_FAC(I)/ATM(ID)%GRAV(I)
	       T4=ATM(ID)%dPdR(I+1)*ATM(ID)%DENSITY(I+1)*ATM(ID)%CLUMP_FAC(I+1)/ATM(ID)%GRAV(I+1)
	       ATM(ID)%TB(I)=ATM(ID)%TB(I+1)+ T2*(T3+T4)
	    END DO
	    CALL DP_CURVE(K,ATM(ID)%XVEC,ATM(ID)%TA)
	    CALL DP_CURVE(K,ATM(ID)%XVEC,ATM(ID)%TB)
!	    WRITE(6,*)'Ratio to flux=',ATM(ID)%TAU_FLUX(K),ATM(ID)%TA(1)/ATM(ID)%TAU_FLUX(K)
!
	    T1=1.0E+20_LDP*365.25_LDP*24*3600/1.0E+05_LDP 	!1.0D+20*1year/1km/s
	    ATM(ID)%DEP_WIND_MOM=4.0_LDP*3.1459_LDP*T1*ATM(ID)%STARS_MASS*GRAV_CON*ATM(ID)%TA(1)/MASS_SUN()
	    ATM(ID)%WIND_MOM_MDOT=ATM(ID)%DEP_WIND_MOM/ATM(ID)%VEL(1)
	 END DO
!
	 WRITE(6,*)'Deposited wind momentum is in units of Msun km/s'
	 WRITE(6,*)'Mass loss rate is in units of Msun/yr'
	 WRITE(6,*)' '
	 WRITE(6,'(1X,A,3X,A,1X,A,9X,A,4X,A,3X,A,9X,A)')'ID','Tau(Sonic)','Mom(Msun km/s)',
	1             'Msun/yr','Msun/yr(mod)','Vinf(mod)'
	 DO ID=1,NMOD
	   WRITE(6,'(I3,F12.4,3ES16.4,F12.2,5X,A)')
	1       ID,ATM(ID)%TAU_SONIC,ATM(ID)%DEP_WIND_MOM,ATM(ID)%WIND_MOM_MDOT,
	1                   ATM(ID)%STARS_MDOT,ATM(ID)%VEL(1),TRIM(ATM(ID)%DIR_NAME)
	 END DO
!
	ELSE IF(XOPT .EQ. 'GRAD')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%GRAD)
	  END DO
	  YLAB=TRIM(YLAB)//'; g\dr\u'
!
	ELSE IF(XOPT .EQ. 'DGRAD')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DERIVCHI(ATM(ID)%YVEC,ATM(ID)%GRAD,ATM(ID)%R,ND,'LINMON')
	    ATM(ID)%YVEC=SQRT(0.5_LDP*ABS(ATM(ID)%YVEC))/1.0E+05_LDP
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; (0.5|dg\dr\ui/dr|)\u0.5\d) cm/s'
!
	ELSE IF(XOPT .EQ. 'GELEC')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%GELEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; g\de\u'
!
	ELSE IF(XOPT .EQ. 'GRAV')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%GRAV)
	  END DO
	  YLAB=TRIM(YLAB)//'; g'
!
	ELSE IF(XOPT .EQ. 'REQ')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    CALL DP_CURVE(ATM(ID)%ND,ATM(ID)%XVEC,ATM(ID)%REQ)
	  END DO
	  YLAB=TRIM(YLAB)//'; ( vdv/dr + \gr\u-1\d dP/dr + g )'
	ELSE IF(XOPT .EQ. 'NGL')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    DO I=1,ND
	      ATM(ID)%TA(I)=(ATM(ID)%GRAD(I)-ATM(ID)%GELEC(I))/(ATM(ID)%GRAV(I)-ATM(ID)%GELEC(I))
	    END DO
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%TA)
	  END DO
	  YLAB=TRIM(YLAB)//'; g\dl\u/(g-g\de\u)'
	ELSE IF(XOPT .EQ. 'NREQ')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%TA(1:ND)=ATM(ID)%REQ(1:ND)/ATM(ID)%GELEC(1:ND)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%TA)
	  END DO
	  YLAB=TRIM(YLAB)//'; g\dh\u/g\de\u'
!
	ELSE IF(XOPT .EQ. 'NERR')THEN
	  TMP_LOG=.TRUE.
	  CALL GEN_IN(TMP_LOG,'Normalize by grad-ge (F) or grad (T)')
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(TMP_LOG)THEN
	      ATM(ID)%TA(1:ND)=(ATM(ID)%REQ(1:ND)-ATM(ID)%GRAD(1:ND))/ATM(ID)%GRAD(1:ND)
	    ELSE
	      ATM(ID)%TA(1:ND)=(ATM(ID)%REQ(1:ND)-ATM(ID)%GRAD(1:ND))/(ATM(ID)%GRAD(1:ND)-ATM(ID)%GELEC(1:ND))
	    END IF
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%TA)
	  END DO
	  IF(TMP_LOG)THEN
	    YLAB=TRIM(YLAB)//'; (vdv/dr + \gr\u-1\d dP/dr + g - g\dr\u)/g\dr\u'
	  ELSE
	    YLAB=TRIM(YLAB)//'; (vdv/dr + \gr\u-1\d dP/dr + g - g\dr\u)/(g\d\r\u-g\de\u)'
	  END IF
!
	ELSE IF(XOPT .EQ. 'NGERR')THEN
	  TMP_LOG=.TRUE.
	  CALL GEN_IN(TMP_LOG,'Normalize by grav-ge (F) or grav (T)')
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(TMP_LOG)THEN
	      ATM(ID)%TA(1:ND)=(ATM(ID)%REQ(1:ND)-ATM(ID)%GRAD(1:ND))/ATM(ID)%GRAV(1:ND)
	    ELSE
	      ATM(ID)%TA(1:ND)=(ATM(ID)%REQ(1:ND)-ATM(ID)%GRAD(1:ND))/(ATM(ID)%GRAV(1:ND)-ATM(ID)%GELEC(1:ND))
	    END IF
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%TA)
	  END DO
	  IF(TMP_LOG)THEN
	    YLAB=TRIM(YLAB)//'; (vdv/dr + \gr\u-1\d dP/dr + g - g\dr\u)/g'
	  ELSE
	    YLAB=TRIM(YLAB)//'; (vdv/dr + \gr\u-1\d dP/dr + g - g\dr\u)/(g-g\de\u)'
	  END IF

!
	ELSE IF(XOPT .EQ. 'NGRAD')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    ATM(ID)%TA(1:ND)=ATM(ID)%GRAD(1:ND)/ATM(ID)%GELEC(1:ND)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%TA)
	  END DO
	  YLAB=TRIM(YLAB)//'; g\dr\u/g\de\u'
!
	ELSE IF(XOPT .EQ. 'ALPHA')THEN
	  DO ID=1,NMOD-1
	    ND=ATM(ID)%ND; ND2=ATM(ID+1)%ND
!
	    ATM(ID)%YVEC=ATM(ID)%GRAD/ATM(ID)%GELEC
	    ATM(ID+1)%YVEC=ATM(ID+1)%GRAD/ATM(ID+1)%GELEC
	    CALL MON_INTERP(ATM(ID)%TA,ND,IONE,ATM(ID)%R,ND,ATM(ID+1)%YVEC,ND2,ATM(ID+1)%R,ND2)
	    ATM(ID)%YVEC=LOG(ATM(ID)%YVEC/ATM(ID)%TA)
!
	    ATM(ID+1)%ZVEC=ATM(ID+1)%VdVdR
	    CALL MON_INTERP(ATM(ID)%TA,ND,IONE,ATM(ID)%R,ND,ATM(ID+1)%VdVdR,ND2,ATM(ID+1)%R,ND2)
	    ATM(ID)%ZVEC=LOG(ATM(ID)%VdVdR/ATM(ID)%TA)
!
	    DO I=1,ND
	      IF(ATM(ID)%ZVEC(I) .EQ. 0)THEN
	        ATM(ID)%YVEC(I)=0
	      ELSE
	        ATM(ID)%YVEC(I)=ATM(ID)%YVEC(I)/ATM(ID)%ZVEC(I)
	      END IF
	    END DO
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; dg\drad\u/dr'
!
	ELSE IF(XOPT .EQ. 'DGRDR')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(ALLOCATED(COEF))DEALLOCATE(COEF)
	    ALLOCATE (COEF(ND,4))
            CALL MON_INT_FUNS_V2(COEF,ATM(ID)%GRAD,ATM(ID)%R,ND)
	    ATM(ID)%YVEC=1.0E-05_LDP*COEF(:,3)
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; dg\drad\u/dr'
!
	ELSE IF(XOPT .EQ. 'SONIC')THEN
	  DO ID=1,NMOD
	    ND=ATM(ID)%ND
	    IF(ALLOCATED(COEF))DEALLOCATE(COEF)
	    ALLOCATE (COEF(ND,4))
            CALL MON_INT_FUNS_V2(COEF,ATM(ID)%GRAD,ATM(ID)%R,ND)
	    ATM(ID)%YVEC=1.0E-05_LDP*SQRT(0.5_LDP*ABS(COEF(:,3)))
	    CALL DP_CURVE(ND,ATM(ID)%XVEC,ATM(ID)%YVEC)
	  END DO
	  YLAB=TRIM(YLAB)//'; dg\drad\u/dr'
!
	ELSE IF(XOPT .EQ. 'EX' .OR. XOPT(1:2) .EQ. 'ST')THEN
	  STOP
	ELSE
	  WRITE(6,*)'Unrecognized option'
	  GOTO 5000
	END IF
	GOTO 5000
!
	END
