	PROGRAM PLT_RAW_XRAY
	USE SET_KIND_MODULE
	USE MOD_XRAY_FLUXES
	USE GEN_IN_INTERFACE
	IMPLICIT NONE
!
	REAL(KIND=LDP) TSHOCK_1
	REAL(KIND=LDP) TSHOCK_2
	REAL(KIND=LDP) CONV_FACT
	INTEGER, PARAMETER :: LUIN=7
!
	CONV_FACT=4.0E-10_LDP*ACOS(-1.0_LDP)
	TSHOCK_1=100.0_LDP
	TSHOCK_2=200.0_LDP
	CALL RD_XRAY_SPEC(TSHOCK_1,TSHOCK_2,LUIN)
	X_EMISS1=LOG10(CONV_FACT*X_EMISS1+1.0E-300_LDP)
	X_EMISS2=LOG10(CONV_FACT*X_EMISS2+1.0E-300_LDP)
	CALL DP_CURVE(N_BINS,X_NU,X_EMISS1)
	CALL GRAMON_PGPLOT('Freq','Log \gL(T=10\u6\dK)',' ',' ')
!
	CALL DP_CURVE(N_BINS,X_NU,X_EMISS2)
	CALL GRAMON_PGPLOT('Freq','Log \gL(T=2 x 10\u6\dK)',' ',' ')
!
	TSHOCK_1=400.0_LDP
	TSHOCK_2=1000.0_LDP
	CALL RD_XRAY_SPEC(TSHOCK_1,TSHOCK_2,LUIN)
	X_EMISS1=LOG10(CONV_FACT*X_EMISS1+1.0E-300_LDP)
	X_EMISS2=LOG10(CONV_FACT*X_EMISS2+1.0E-300_LDP)
	CALL DP_CURVE(N_BINS,X_NU,X_EMISS2)
	CALL GRAMON_PGPLOT('Freq','Log \gL(T=4 x 10\u6\dK)',' ',' ')
!
	CALL DP_CURVE(N_BINS,X_NU,X_EMISS2)
	CALL GRAMON_PGPLOT('Freq','Log \gL(T=10\u7\dK)',' ',' ')
!
	STOP
	END
