	PROGRAM PLT_STEQ
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
!
	INTEGER ND
	INTEGER NT
	INTEGER NT_RAW
!
	TYPE STEQ_DATA
	  REAL(KIND=LDP), ALLOCATABLE :: RAD_EQ(:)
	  REAL(KIND=LDP), ALLOCATABLE :: ELEC_EB(:)
	  REAL(KIND=LDP), ALLOCATABLE :: STEQ_RAW(:,:)
	  REAL(KIND=LDP), ALLOCATABLE :: STEQ_RHS(:,:)
	  REAL(KIND=LDP), ALLOCATABLE :: STEQ_SOL(:,:)
	END TYPE STEQ_DATA
	TYPE (STEQ_DATA) SE(5)
	REAL(KIND=LDP), ALLOCATABLE :: XV(:)
	REAL(KIND=LDP), ALLOCATABLE :: YV(:)
!
	INTEGER I,J,K,ID
	INTEGER DST, DEND
	INTEGER NFILES
	INTEGER, PARAMETER :: IZERO=0
!
	CHARACTER(LEN=10) XOPT
	CHARACTER(LEN=10) SE_TYPE
	CHARACTER(LEN=200) STRING
	CHARACTER(LEN=200) FILENAME
!
	OPEN(UNIT=10,FILE='MODEL',STATUS='OLD',ACTION='READ')
	ND=0; NT=0
	DO WHILE(NT .EQ. 0)
	  READ(10,'(A)')STRING
	  IF(INDEX(STRING,'!Number of depth points') .NE. 0)THEN
	    READ(STRING,*)ND
	  END IF
	  IF(INDEX(STRING,'Total number of variables') .NE. 0)THEN
	    READ(STRING,*)NT
	  END IF
	END DO
	CLOSE(UNIT=10)
!
	FILENAME='STEQ_VALS'
	NFILES=0
	ALLOCATE (XV(1.2*NT),YV(1.2*NT))
!
	XOPT='RD_MOD'
1000	CONTINUE
	IF(XOPT .EQ. 'RD_MOD')THEN
	ELSE IF(XOPT .EQ. 'COL')THEN
	  XOPT='GR'
	ELSE
	  XOPT='COL'
	END IF
	CALL GEN_IN(XOPT,'Model options: GR, RD_MOD, COL, EX')
	CALL SET_CASE_UP(XOPT,IZERO,IZERO)
	IF(XOPT .EQ. 'GR')THEN
	  CALL GRAMON_PGPLOT(' ',' ',' ',' ')
	  GOTO 1000
!
	ELSE IF(XOPT .EQ. 'EX')THEN
	  STOP
	ELSE IF(XOPT .EQ. 'RD_MOD')THEN
	  CALL GEN_IN(FILENAME,'Next data file to read')
	  OPEN(FILE=FILENAME,UNIT=10,ACTION='READ',STATUS='OLD')
	  NFILES=NFILES+1
	  ID=NFILES
!
	  DO WHILE(INDEX(STRING,'&') .EQ. 0)
	    READ(10,'(A)')STRING
	  END DO
	  ALLOCATE(SE(ID)%RAD_EQ(ND))
	  DST=1; DEND=10
	  DO WHILE(INDEX(STRING,'&') .NE. 0)
	    K=INDEX(STRING,'&')
	    READ(STRING(K+1:),*)SE(ID)%RAD_EQ(DST:DEND)
	    DST=DST+10; DEND=MIN(ND,DEND+10)
	    READ(10,'(A)')STRING
	  END DO
	  
	  DO WHILE(INDEX(STRING,'%') .EQ. 0)
	    READ(10,'(A)')STRING
	  END DO
	  ALLOCATE(SE(ID)%ELEC_EB(ND))
	  DST=1; DEND=10
	  DO WHILE(INDEX(STRING,'%') .NE. 0)
	    K=INDEX(STRING,'%')
	    READ(STRING(K+1:),*)SE(ID)%ELEC_EB(DST:DEND)
	    DST=DST+10; DEND=MIN(ND,DEND+10)
	    READ(10,'(A)')STRING
	  END DO
!
	  NT_RAW=1.2*NT
	  ALLOCATE(SE(ID)%STEQ_RAW(NT_RAW,ND)) 
	  DO WHILE(INDEX(STRING,'STEQ ARRAY') .EQ. 0)
	    READ(10,'(A)')STRING
	  END DO
	  DST=1; DEND=10
	  DO WHILE(INDEX(STRING,'*') .NE. 0)
	    WRITE(6,*)'DST,DEND=',DST,DEND
	    DO I=1,NT_RAW
	      K=INDEX(STRING,'*')
	      READ(STRING(K+1:),*)SE(ID)%STEQ_RAW(I,DST:DEND)
	      READ(10,'(A)')STRING
	      IF(STRING .EQ. ' ')THEN
	        NT_RAW=I
	        EXIT
	      END IF
	    END DO
	    READ(10,'(A)')STRING		!Next data block
	    DST=DST+10; DEND=MIN(ND,DEND+10)
	  END DO
!
	  ALLOCATE(SE(ID)%STEQ_RHS(NT,ND)) 
	  DO WHILE(INDEX(STRING,')*') .EQ. 0)
	    READ(10,'(A)')STRING
	  END DO
	  DST=1; DEND=10
	  DO WHILE(INDEX(STRING,'*') .NE. 0)
	    WRITE(6,*)'DST,DEND=',DST,DEND
	    DO I=1,NT 
	      K=INDEX(STRING,'*')
	      READ(STRING(K+1:),*)SE(ID)%STEQ_RHS(I,DST:DEND)
	      READ(10,'(A)')STRING
	    END DO
	    READ(10,'(A)')STRING		!Next data block
	    DST=DST+10; DEND=MIN(ND,DEND+10)
	  END DO
!
	  ALLOCATE(SE(ID)%STEQ_SOL(NT,ND)) 
	  DO WHILE(INDEX(STRING,')#') .EQ. 0)
	    READ(10,'(A)')STRING
	  END DO
	  DST=1; DEND=10
	  DO WHILE(INDEX(STRING,'#') .NE. 0)
	    WRITE(6,*)'DST,DEND=',DST,DEND
	    DO I=1,NT 
	      K=INDEX(STRING,'#')
	      READ(STRING(K+1:),*)SE(ID)%STEQ_SOL(I,DST:DEND)
	      READ(10,'(A)',END=50)STRING
	    END DO
	    READ(10,'(A)',END=50)STRING		!Next data block
	    DST=DST+10; DEND=MIN(ND,DEND+10)
	  END DO
50	  CONTINUE
  	  CLOSE(10)
	  GOTO 1000
!
	ELSE IF(XOPT .EQ. 'COL')THEN
	  WRITE(6,*)'Number of files is',NFILES
	  CALL GEN_IN(SE_TYPE,'RAW, RHS or SOL')
	  CALL SET_CASE_UP(SE_TYPE,IZERO,IZERO)
	  CALL GEN_IN(DST,'Depth')
	  IF(SE_TYPE .EQ. 'RHS')THEN
	    DO ID=1,NFILES
	      DO I=1,NT
	        XV(I)=I
	        YV(I)=SE(ID)%STEQ_RHS(I,DST)+1.0E-35
	      END DO
	      CALL DP_CURVE_LAB(NT,XV,YV,' ')
	    END DO
	  ELSE IF(SE_TYPE .EQ. 'SOL')THEN
	    DO ID=1,NFILES
	      DO I=1,NT
	        XV(I)=I
	        YV(I)=SE(ID)%STEQ_SOL(I,DST)+1.0E-35
	      END DO
	      CALL DP_CURVE_LAB(NT,XV,YV,' ')
	    END DO
	  ELSE IF(SE_TYPE .EQ. 'RAW')THEN
	    DO ID=1,NFILES
	      DO I=1,NT_RAW
	        XV(I)=I
	        YV(I)=SE(ID)%STEQ_RAW(I,DST)+1.0E-35
	      END DO
	      CALL DP_CURVE_LAB(NT,XV,YV,' ')
	    END DO
	  ELSE
	    WRITE(6,*)'Unrecognized option'
	    GOTO 1000
	  END IF
	  XOPT='COL'
	  GOTO 1000
!
	ELSE
	  WRITE(6,*)'Unrecognized option'
	  GOTO 1000
	END IF
!
	STOP
	END 
