C
	SUBROUTINE RECOM_CHK_V2(RECOM,EDGE_GS,GC2,GIONC2,NC2,
	1            EXC_EN,PHOT_ID,SUB_PHOT_C2,SPECIES_ID,T)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
! Altered 26-Aug-2003: Maximum frequency for recombination integration altered.
!
	INTEGER NC2
	INTEGER PHOT_ID
	INTEGER SPECIES_ID
!
	REAL(KIND=LDP) RECOM(NC2)
	REAL(KIND=LDP) EDGE_GS(NC2)
	REAL(KIND=LDP) GC2(NC2)
	REAL(KIND=LDP) GIONC2
	REAL(KIND=LDP) EXC_EN
	REAL(KIND=LDP) T
C
	EXTERNAL SUB_PHOT_C2
C
	COMMON/CONSTANTS/ CHIBF,CHIFF,HDKT,TWOHCSQ
	REAL(KIND=LDP) CHIBF,CHIFF,HDKT,TWOHCSQ
C
C Local variables.
C
	REAL(KIND=LDP) LOW_CROSS(NC2)
	REAL(KIND=LDP) HIGH_CROSS(NC2)
	REAL(KIND=LDP) LTE_POP(NC2)
C
	REAL(KIND=LDP) T1
	REAL(KIND=LDP) RGU
	REAL(KIND=LDP) DEL_NU
	REAL(KIND=LDP) MAX_dNU
	REAL(KIND=LDP) LOW_NU,HIGH_NU,HIGH_NU_MAX
	REAL(KIND=LDP) FOUR_PI_ON_H
C
	INTEGER I,LEV
	INTEGER CHK_LEV
	LOGICAL, PARAMETER :: L_FALSE=.FALSE.
C
	FOUR_PI_ON_H=189.65E+15_LDP
	RECOM(:)=0.0_LDP
C
C Compute the normalized LTE population (for ED=1, DI=1, and no level
C dissolution.
C
	RGU=LOG(2.07078E-22_LDP)
	DO LEV=1,NC2
	  LTE_POP(LEV)=GC2(LEV)*EXP(HDKT*(EDGE_GS(LEV)+EXC_EN)/T+RGU) /
	1                 (T**1.5_LDP)/GIONC2
	END DO
C
	MAX_dNU=0.1_LDP*T/HDKT
	DO I=NC2,1,-1
	  HIGH_NU=EDGE_GS(I)
	  CHK_LEV=I-1
	  IF(HIGH_NU .GT. 0.0_LDP)EXIT
	END DO
	HIGH_CROSS=0.0_LDP
!
	CALL SUB_PHOT_C2(SPECIES_ID,HIGH_CROSS,HIGH_NU,EDGE_GS,NC2,PHOT_ID,L_FALSE)
	T1=EXP(-HDKT*HIGH_NU/T) * HIGH_NU * HIGH_NU
	HIGH_CROSS(:)=HIGH_CROSS(:)*T1
!
! Choose the maximum frequecy.
!
	HIGH_NU_MAX=2*EDGE_GS(1)
	IF(HIGH_NU_MAX*HDKT/T .LT. 10)HIGH_NU_MAX=10.0_LDP*T/HDKT
	DO WHILE(HIGH_NU .LT. HIGH_NU_MAX)
C
	  LOW_NU=HIGH_NU
	  LOW_CROSS(:)=HIGH_CROSS(:)
	  HIGH_NU=MIN(LOW_NU*1.1_LDP,LOW_NU+MAX_dNU)
	  IF(CHK_LEV .GT. 0)THEN
	    IF(HIGH_NU .GT. EDGE_GS(CHK_LEV))THEN
	      HIGH_NU=EDGE_GS(CHK_LEV)
	      CHK_LEV=CHK_LEV-1
	    END IF
	  END IF
	  DEL_NU=HIGH_NU-LOW_NU
	  CALL SUB_PHOT_C2(SPECIES_ID,HIGH_CROSS,HIGH_NU,EDGE_GS,NC2,PHOT_ID,L_FALSE)
	  T1=EXP(-HDKT*HIGH_NU/T) * HIGH_NU * HIGH_NU
	  HIGH_CROSS(:)=HIGH_CROSS(:)*T1
C
C To avoid problems with weights near the bound-free edge, we being summing
C the recombination rates at the edge.
C
	  DO LEV=1,NC2
	   IF(LOW_NU .GE. EDGE_GS(LEV))THEN
	      RECOM(LEV)=RECOM(LEV)+DEL_NU*(LOW_CROSS(LEV)+HIGH_CROSS(LEV))
	   END IF
	  END DO
	END DO
	T1=FOUR_PI_ON_H*TWOHCSQ*0.5_LDP
	RECOM(:)=T1*LTE_POP(:)*RECOM(:)
C
	RETURN
	END
