!
! Subroutine to  read the output model data to a sequential, unformatted, file
!      OLD_MODEL_DATA
! written as 8-byte floating point, and output a new file  NEW_OLD_MODEL_DATA
! written as 10-byte floating point.
!
	PROGRAM REWRITE_OLD_MODEL_DATA
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
! Created 24-Oct-2023
!
	INTEGER ND
	INTEGER NUM_SPECIES
	INTEGER NXzV_F
	INTEGER, PARAMETER :: LU_IN=7
	INTEGER, PARAMETER :: LU_OUT=10
!
	REAL*8 OLD_SN_AGE
	REAL*8 OLD_ZXzV
	REAL*8, ALLOCATABLE :: OLD_XzV_F(:,:)
	REAL*8, ALLOCATABLE :: OLD_VEC(:)
!
	REAL(KIND=LDP) NEW_SN_AGE
	REAL(KIND=LDP) NEW_ZXzV
	REAL(KIND=LDP), ALLOCATABLE :: NEW_VEC(:)
	REAL(KIND=LDP), ALLOCATABLE :: NEW_XzV_F(:,:)
!
	INTEGER SPECIES_BEG_ID,SPECIES_END_ID
	INTEGER ISPEC
	INTEGER ID,OLD_ID
	INTEGER K
	INTEGER IOS
	CHARACTER(LEN=10) SPECIES
	CHARACTER(LEN=11) DATE
	CHARACTER(LEN=500) ERROR_MSG
!
	WRITE(6,*)' '
	WRITE(6,*)' This program expects a file OLD_MODEL_DATA written as an 8-byte floating point number '
	WRITE(6,*)' This program will output NEW_OLD_MODEL_DATA written as a 16-byte floating point number '
	WRITE(6,*)' '
	WRITE(6,*)' If successful, you will need to rename NEW_OLD_MODEL_DATA'
	WRITE(6,*)' '
!
	OPEN(UNIT=LU_IN,FILE='OLD_MODEL_DATA',FORM='UNFORMATTED',STATUS='UNKNOWN',
	1      ACTION='READ', IOSTAT=IOS,IOMSG=ERROR_MSG)
	IF(IOS .NE. 0)THEN
	  WRITE(6,*)'Unable to open file OLD_MODEL_DATA -- IOS=',IOS
	  WRITE(6,*)TRIM(ERROR_MSG)
	  STOP
	END IF
!
	OPEN(UNIT=LU_OUT,FILE='NEW_OLD_MODEL_DATA',FORM='UNFORMATTED',STATUS='UNKNOWN',
	1      ACTION='WRITE', IOSTAT=IOS,IOMSG=ERROR_MSG)
	IF(IOS .NE. 0)THEN
	  WRITE(6,*)'Unable to open file NEW_OLD_MODEL_DATA -- IOS=',IOS
	  WRITE(6,*)TRIM(ERROR_MSG)
	  STOP
	END IF
!
	READ(LU_IN)DATE		!Format date
	WRITE(LU_OUT)DATE		!Format date
	READ(LU_IN)ND,NUM_SPECIES
	WRITE(LU_OUT)ND,NUM_SPECIES
	READ(LU_IN)OLD_SN_AGE;     NEW_SN_AGE=OLD_SN_AGE
	WRITE(LU_OUT)NEW_SN_AGE
!
	WRITE(6,*)' '
	WRITE(6,*)'Date=',DATE
	WRITE(6,*)'ND=',ND
	WRITE(6,*)'Number of species=',NUM_SPECIES
	WRITE(6,*)'SN age=',OLD_SN_AGE
	WRITE(6,*)' '
!
! Read in R, V, SIGMA, T, ED, POP_ATOM, DENSITY
!
	ALLOCATE(OLD_VEC(ND),NEW_VEC(ND))
	DO K=1,7
	  READ(LU_IN)OLD_VEC
	  NEW_VEC=OLD_VEC
	  WRITE(LU_OUT)NEW_VEC
	END DO
!
! We use ZXzV as a means of identifying the ionization stage.
!
	DO ISPEC=1,NUM_SPECIES
	  READ(LU_IN)SPECIES_BEG_ID,SPECIES_END_ID,SPECIES
	  WRITE(LU_OUT)SPECIES_BEG_ID,SPECIES_END_ID,SPECIES
	  DO ID=SPECIES_BEG_ID,SPECIES_END_ID
	    READ(LU_IN)OLD_ID,NXzV_F,OLD_ZXzV;   NEW_ZXzV=OLD_ZXzV
	    WRITE(LU_OUT)OLD_ID,NXzV_F,NEW_ZXzV
	    ALLOCATE(OLD_XZV_F(NXzV_F,ND),NEW_XZV_F(NXzV_F,ND))
	    READ(LU_IN)OLD_XzV_F
	    NEW_XzV_F=OLD_XzV_F
	    WRITE(LU_OUT)NEW_XzV_F
	    READ(LU_IN)OLD_VEC                   !ATM(ID)%DXzV		!Super level ion population.
	    NEW_VEC=OLD_VEC
	    WRITE(LU_OUT)NEW_VEC
	    DEALLOCATE(NEW_XzV_F,OLD_XZV_F)
	  END DO
	END DO
!
	CLOSE(LU_IN)
	CLOSE(LU_OUT)
!
	RETURN
	END
