!
! Set of routines to read in data from HYDRO file. The HYDRO file can
! have extra columns but the same header ID must be the same in all
! formats.
!
! Created: 09-Jan-2012
!
	MODULE MOD_SORT_HYDRO_HD
	  INTEGER NHEAD
	  CHARACTER(LEN=12) COL_ID(20)
	END MODULE MOD_SORT_HYDRO_HD
!
CONTAINS
	SUBROUTINE SET_HYDRO_HD_LOC(HEADER,NRET)
	USE SET_KIND_MODULE
	USE MOD_SORT_HYDRO_HD
	IMPLICIT NONE
!
	CHARACTER(LEN=*) HEADER
	INTEGER NRET
	INTEGER K
!
	NHEAD=0
	HEADER=ADJUSTL(HEADER)
	DO WHILE(1 .EQ. 1)
	  IF(HEADER(1:1) .EQ. ' ')EXIT
	  K=INDEX(HEADER,'  ')
	  NHEAD=NHEAD+1
	  COL_ID(NHEAD)=HEADER(1:K-1)
	  HEADER=ADJUSTL(HEADER(K:))
	END DO
	NRET=NHEAD+1
!
	RETURN
	END
!
	INTEGER FUNCTION GET_HYDRO_VEC_LOC(ID)
	USE MOD_SORT_HYDRO_HD
	IMPLICIT NONE
!
	CHARACTER(LEN=*) ID
	INTEGER K,LOC
!
! Returns NHEAD+1 if vector corresponding to the ID is not avilable.
!
	LOC=NHEAD+1	
	DO K=1,NHEAD
	  IF(TRIM(ID) .EQ. TRIM(COL_ID(K)))THEN
	    LOC=K
	    EXIT
	  END IF
	END DO
!
	GET_HYDRO_VEC_LOC=LOC
	RETURN
	END
