	PROGRAM TST_FOR
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	USE MOD_SPACE_GRID_V2
	IMPLICIT NONE
!
	INTEGER, PARAMETER :: ND=60
	INTEGER, PARAMETER :: NC=15
	INTEGER, PARAMETER :: NP=ND+NC
!
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) VDOP_VEC(ND)
	REAL(KIND=LDP) SIGMA(ND)
	REAL(KIND=LDP) P_CMF(NP)
	REAL(KIND=LDP) MU_AT_RMAX(NP)
	REAL(KIND=LDP) HQW_AT_RMAX(NP)
!
	INTEGER, PARAMETER :: ND_MAX=100*ND
	REAL(KIND=LDP) X(ND_MAX)
	REAL(KIND=LDP) Y(ND_MAX)
!
	REAL(KIND=LDP) VDOP_FRAC
	REAL(KIND=LDP) T1
	REAL(KIND=LDP) VMIN
	REAL(KIND=LDP) C_KMS
	REAL(KIND=LDP) SPEED_OF_LIGHT
	INTEGER I,J,N,IP
	EXTERNAL SPEED_OF_LIGHT
!
	C_KMS=1.0E-05_LDP*SPEED_OF_LIGHT()
	R(1)=20.0_LDP
	R(ND)=2.0_LDP
	T1=EXP( LOG(R(1)/R(ND))/(ND-1) )
	DO I=2,ND
	  R(I)=R(ND)*(T1**(ND-I))
	END DO
	VDOP_VEC(1:ND)=100.0_LDP
	WRITE(6,*)'Evaluated R'
!
	VMIN=10000.0_LDP
	CALL GEN_IN(VMIN,'Minimum velocity at core in km/s')
	VDOP_FRAC=0.5
	CALL GEN_IN(VDOP_FRAC,'Minimum Fracton Doppler spacing')
	DO I=1,ND
	  V(I)=VMIN*(R(I)/R(ND))
	  SIGMA(I)=0.0_LDP
	END DO
	WRITE(6,*)'Evaluated V,SIGMA'
!
	DO I=1,ND
	  WRITE(6,'(I3,3ES14.4)')I,R(I),V(I),SIGMA(I)
	END DO
!
	T1=R(ND)/NC
	DO I=1,NC
	  P_CMF(I)=T1*(I-1)
	END DO
	DO I=NC+1,NP
	  P_CMF(I)=R(ND+NC+1-I)
	END DO
	WRITE(6,*)'Evaluated P_CMF'
	DO I=1,NP
	  WRITE(6,'(I3,3ES14.4)')I,P_CMF(I)
	END DO
!
	CALL CHARACTERISTICS_V2(R,P_CMF,V,VDOP_VEC,VDOP_FRAC,ND,NC,NP)
	CALL DEFINE_GRID_V2(R,V,VDOP_VEC,VDOP_FRAC,ND,R,P_CMF,ND,NC,NP)
	WRITE(6,*)'Exited  CHARACTERISTICS_V2'
!
        DO IP=1,NP
            J=MAX(J,RAY(IP)%NZ)
            MU_AT_RMAX(IP)=RAY(IP)%MU_P(RAY(IP)%LNK(1))
            HQW_AT_RMAX(IP)=2.0_LDP*HQW_P(1,IP)
            T1=T1+MU_AT_RMAX(IP)*HQW_AT_RMAX(IP)
            WRITE(7,'(I4,4ES16.6)')IP,MU_AT_RMAX(IP),HQW_AT_RMAX(IP),
	1                 (MU_AT_RMAX(IP)+V(1)/C_KMS)/(1.0D0+MU_AT_RMAX(IP)*V(1)/C_KMS),
	1                 SQRT( (R(1)-P_CMF(IP))*(R(1)+P_CMF(IP)) )/R(1)
        END DO
!
	DO I=1,NP,2
	  N=RAY(I)%NZ
	  IF(N .GT. ND_MAX)THEN
	    WRITE(6,*)'N too large: increased ND_MAX from',ND_MAX,' to ',N
	    STOP
	  END IF
	  X(1:N)=RAY(I)%R_RAY(1:N)*RAY(I)%MU_M(1:N)
	  Y(1:N)=RAY(I)%R_RAY(1:N)*SQRT(1.0_LDP-RAY(I)%MU_M(1:N)*RAY(I)%MU_M(1:N))
	  X(N+1:2*N)=RAY(I)%R_RAY(N:1:-1)*RAY(I)%MU_P(N:1:-1)
	  Y(N+1:2*N)=RAY(I)%R_RAY(N:1:-1)*SQRT(1.0_LDP-RAY(I)%MU_P(N:1:-1)*RAY(I)%MU_P(N:1:-1))
	  N=2*N;  CALL DP_CURVE(N,X,Y)
!	  IF(I .GT. NP-3)THEN
	  IF(I .EQ. 3)THEN
	    DO J=1,N
	      WRITE(16,'(I4,2ES14.6)')J,X(J),Y(J)
	    END DO
	  END IF
	END DO
	CALL GRAMON_PGPLOT(' ',' ',' ',' ')
!
	I=30
	N=RAY(I)%NZ
	X(1:N)=RAY(I)%R_RAY(1:N)
	Y(1:N)=RAY(I)%S_M(1:N)
	CALL DP_CURVE(N,X,Y)
	X(1:N)=RAY(I)%R_RAY(1:N)
	Y(1:N)=RAY(I)%S_P(1:N)
	CALL DP_CURVE(N,X,Y)
	CALL GRAMON_PGPLOT(' ',' ',' ',' ')
!
	DO I=1,N
	  WRITE(120,'(I5,4ES14.4)')I,RAY(20)%S_P(I),RAY(20)%S_M(I),RAY(20)%R_RAY(I)
	END DO
!
	STOP
	END
