
        HAS ISSUES BECAUSE NU_VEC has inconsistent length if using
        ARRAY OPS


!	SUBROUTINE sets up the frequency grid
!	This NU_GRID_VEC(k) = NU_NEW should set up a frequency grid for the NUC_DECAY_DATA lines
!	For now I am going to work on just getting one line to work and then two lines
!	Then loop over all lines
!
!	Created May 30, 2014
!
!	v11 --fixed problems with the overlapping .511 energies as well as stepping down
!		to NU_MIN from the last line.
!
!	v12 --made it such that the velocity step sizes across different parts of the lines
!		are parameters passed to the routine.
!	v14_beta -- Generalizing code since I removed case where
!		    energies are the same. Only on loop is necessary if if
!		    statements denoting if NGAM = 1 or IGAM=NGAM
!	v14 -- Added the SPLIT_FRAC option to set the location of
!		spacing for the different parts of the tail.
!	v15 -- Adding a piece to make sure hard/soft x-ray lines are
!		sampled well. Previously velocity step sizes were too large to sample
!		through back scattered frequency.
!
!       v16 -- Added ability to set NU_MIN and NU_MAX as parameter. If user inputs
!              value less than lowest line energy, then code will stop.
!-----------------------------------------------------------------------------------------------
!
	SUBROUTINE GAMMA_NU_GRID_V17(NU_VEC,NU_GRID_VEC,NF_GRID_PTS)
	USE SET_KIND_MODULE
	USE GAMMA_NUC_DECAY_V2
	USE NUC_ISO_MOD
	USE MOD_RD_GAMRAY_CNTRL_VARIABLES
	IMPLICIT NONE
!
! Altered 20-Nov-2021 : Subroutine name changed to be consistent with file name.
!                          Changed names of internal subroutines.
!                          Added deeallocate statement.
!
	INTEGER :: I,J,K,L,S
	INTEGER :: IJ,JK
	INTEGER :: IGAM
	INTEGER :: INU
        INTEGER :: IOS
	INTEGER :: NF_GRID_PTS
!
	REAL(KIND=LDP) :: NU_VEC(N_GAMMA) ! input lines read in from NUC_DECAY_DATA
	REAL(KIND=LDP) :: NU_GRID_VEC(NU_GRID_MAX)
	REAL(KIND=LDP) :: NU_NEW
	REAL(KIND=LDP) :: NU_MAX
	REAL(KIND=LDP) :: NU_MIN
	REAL(KIND=LDP) :: DNU
	REAL(KIND=LDP) :: DNU_BLUE
	REAL(KIND=LDP) :: DNU_LINE
	REAL(KIND=LDP) :: DNU_RED
	REAL(KIND=LDP) :: DNU_INF1
	REAL(KIND=LDP) :: DNU_INF2
	REAL(KIND=LDP) :: DNU_LINE_MIN
	REAL(KIND=LDP) :: DNU_TAIL_MIN
	REAL(KIND=LDP) :: BETA_LINE_MIN
	REAL(KIND=LDP) :: BETA_TAIL_MIN
	REAL(KIND=LDP) :: BETA_INF_MIN
	REAL(KIND=LDP) :: BETA
	REAL(KIND=LDP) :: VGAUSS,VINF
        REAL(KIND=LDP) :: FWHM
	REAL(KIND=LDP) :: EN_SUM
	REAL(KIND=LDP) :: T1,T2,T3
	REAL(KIND=LDP), DIMENSION(:), ALLOCATABLE :: WORK1
        REAL(KIND=LDP), DIMENSION(:), ALLOCATABLE :: NU_BLUE
        REAL(KIND=LDP), DIMENSION(:), ALLOCATABLE :: NU_RED
        REAL(KIND=LDP), DIMENSION(:), ALLOCATABLE :: NU_RED_INF1
        REAL(KIND=LDP), DIMENSION(:), ALLOCATABLE :: NU_RED_INF2
	REAL(KIND=LDP), PARAMETER :: SOL = 299792 ! Units of km/s
	REAL(KIND=LDP), PARAMETER :: PLANCK = 4.135668E-21_LDP ! UNITS OF MeV*s SINCE PHOTON ENERGIES IN MeV
	REAL(KIND=LDP), PARAMETER :: ERGS_TO_MEV = 624150.9
	REAL(KIND=LDP), PARAMETER :: HoMC2 = 8.09330118E-21_LDP  ! HoMC2 = h/mc^2 in units of seconds
!
	INTEGER, DIMENSION(:), ALLOCATABLE :: MY_INDEX
	INTEGER :: LUER
	INTEGER :: ERROR_LU
	EXTERNAL :: ERROR_LU
!
	LOGICAL :: FALSE=.FALSE.
	LOGICAL :: OVERLAP
!
	CHARACTER(LEN=80) :: STRING
	CHARACTER(LEN=20) :: STRING2
!
	LUER=ERROR_LU()
!
! Frequencies have to be extracted from the structures and sorted for ONLY the lines being used
!
	WRITE(LUER,*)"Making the frequency grid with version 16"
	K=0
	EN_SUM=0.0_LDP
	OPEN(UNIT=7,FILE='Check_decays.dat',STATUS='UNKNOWN',ACTION='WRITE')
	JK=0
	NU_VEC=0.0_LDP
	OVERLAP=.FALSE.
	DO I=1,N_SPECIES
	  DO J=1,NUM_DECAY_PATHS
	    IF(GAM_ISO(I)%SPECIES .EQ. NUC(J)%SPECIES &
		.AND. GAM_ISO(I)%ATOMIC_MASS .EQ. NUC(J)%MASS)THEN
	      JK=JK+1
	      WRITE(7,*)' '
	      WRITE(7,'(I3,2X,A10,1X,F10.4)')JK,GAM_ISO(I)%SPECIES,GAM_ISO(I)%ATOMIC_MASS
	      WRITE(7,'(4X,A10,2X,A10)')'Energy','Prob.'
	      DO L=1,GAM_ISO(I)%NUM_GAMMA
		WRITE(7,'(I2,2X,F10.4,2X,F10.4)')L,GAM_ISO(I)%E_GAMMA(L),GAM_ISO(I)%PROB(L)
	      END DO
	      EN_SUM=0.0_LDP
	      DO L=1,GAM_ISO(I)%NUM_GAMMA
		K=K+1
		EN_SUM=EN_SUM+GAM_ISO(I)%E_GAMMA(L)*GAM_ISO(I)%PROB(L)
		T1=GAM_ISO(I)%E_GAMMA(L)
		OVERLAP=.FALSE.
		DO IJ=1,K
		  T2=ABS(T1-NU_VEC(IJ))
		  IF(T2 .LE. 1.0E-5_LDP)THEN
		    K=K-1
		    OVERLAP=.TRUE.
		    EXIT
		  END IF
		END DO
		IF(.NOT. OVERLAP)NU_VEC(K)=GAM_ISO(I)%E_GAMMA(L)
	      END DO
	      WRITE(7,'(A13,1X,F6.4)')'Tot. Line En:',EN_SUM
	      WRITE(7,'(A13,1X,F6.4)')'Line En + KE:',EN_SUM+GAM_ISO(I)%KIN_ENERGY
	      WRITE(7,'(A13,1X,F6.4)')'Energy/decay:',NUC(J)%ENERGY_PER_DECAY*ERGS_TO_MEV
	    END IF
	  END DO
	END DO
	CLOSE(7)
	NGAM=K
	WRITE(LUER,'(A,1X,I3)')" Number of Gamma ray lines allocated:",N_GAMMA
	WRITE(LUER,'(A,1X,I3)')" Number of distinct Gamma ray lines used:",NGAM
!
	ALLOCATE(MY_INDEX(NGAM),WORK1(NGAM))
	IF(NGAM .GT. 1)THEN
          CALL INDEXX(NGAM,NU_VEC,MY_INDEX,FALSE)
          CALL SORTDP(NGAM,NU_VEC,MY_INDEX,WORK1)
	END IF
!
	IF(VERBOSE_GAMMA)THEN
	  OPEN(UNIT=7,FILE='./data/GAMMA_RAY_LINES',STATUS='UNKNOWN',ACTION='WRITE')
	  WRITE(7,*)"NGAM:",NGAM
	  DO I=1,NGAM
	    WRITE(LUER,'(I3,ES16.6,F8.4)') I,NU_VEC(I)/PLANCK,NU_VEC(I)
	    WRITE(7,'(I3,ES16.6,F8.4)') I,NU_VEC(I)/PLANCK,NU_VEC(I)
	  END DO
	  CLOSE(UNIT=7)
	END IF
!
	NU_VEC=NU_VEC/PLANCK
!
	ALLOCATE (NU_BLUE(NGAM))
	ALLOCATE (NU_RED(NGAM))
	ALLOCATE (NU_RED_INF1(NGAM))
	ALLOCATE (NU_RED_INF2(NGAM))
!
	VGAUSS=V_GAUSS/SOL
	VINF=V_INF/SOL
!	
! Assigning blue and red edges to the lines based on doppler shifts
!
	NU_BLUE=NU_VEC*(1.0_LDP+BLUE_GAUSS*VGAUSS)
	NU_RED=NU_VEC*(1.0_LDP-RED_GAUSS*VGAUSS)
!	
! Changing the definition of the red tail might sample the grid better.
! Splitting NU_RED_INF into two parts may make grid smaller.
!
	NU_RED_INF2=NU_RED/(1.0_LDP+2.0_LDP*NU_RED*HoMC2)
	NU_RED_INF1=NU_RED-COMP_TAIL_SPLIT_FRAC*(NU_RED-NU_RED_INF2)
!
! Initializing the code for the first values of the grid values
!
        FWHM=SQRT(8.0_LDP*LOG(2.0_LDP))*VGAUSS
	NU_MAX=(1.0_LDP+100.0_LDP*FWHM)*NU_VEC(1)
	IF(EGAM_MAX/PLANCK .LT. NU_MAX)THEN
	  WRITE(LUER,'(A)')'Using code definition for NU_MAX instead of '//&
		'user input..'
	  WRITE(LUER,'(A,1X,F10.4)')'NU_MAX (MeV):',NU_MAX*PLANCK
	ELSE
	  NU_MAX=EGAM_MAX/PLANCK
	END IF
	T1=NU_RED_INF2(NGAM)/&
		(1.0_LDP+2.0_LDP*HoMC2*NU_RED_INF2(NGAM))
	T2=0.1_LDP*T1/(1.0_LDP+2.0_LDP*HoMC2*T1)
	NU_MIN=EGAM_MIN/PLANCK ! Lowest frequency will be set as parameter
	IF(T2*PLANCK .LT. EGAM_MIN)THEN
	  IF(T1*PLANCK .GT. EGAM_MIN .AND. &
	      T2*10.0_LDP*PLANCK .GT. EGAM_MIN )THEN
	    NU_MIN=EGAM_MIN/PLANCK
	  ELSE IF(NU_VEC(NGAM)*PLANCK .GT. EGAM_MIN .AND. &
	      T2*10.0_LDP*PLANCK .LT. EGAM_MIN )THEN
	    NU_MIN=5.0_LDP*T2
	  END IF
	END IF
	WRITE(LUER,*)"NU_MIN:",NU_MIN
	WRITE(LUER,*)"NU_MIN (keV):",NU_MIN*PLANCK*1.0D3
	WRITE(LUER,*)"NU_RED_INF2(NGAM):",NU_RED_INF2(NGAM)
	WRITE(LUER,*)"NU_RED_INF2(NGAM) (keV):",NU_RED_INF2(NGAM)*PLANCK*1.0D3
!
!---------------------------------------------------------------------
! Establishing the starting value for our NU grid
!---------------------------------------------------------------------
!
	NU_GRID_VEC=0.0_LDP
	NU_NEW=NU_MAX
	INU=1
	NU_GRID_VEC(INU)=NU_NEW
!
	DO IGAM=1,NGAM
!	  WRITE(LUER,*)"LINE INDEX:",IGAM
! We can ensure that x-ray tails are sampled by at least ~50 pts
!
	  BETA_INF_MIN=1.0_LDP-(NU_RED_INF2(IGAM)/NU_RED(IGAM))**(1.0_LDP/FLOAT(GRAY_LINE_MIN-1))
	  BETA_LINE_MIN=1.0_LDP-(NU_RED(IGAM)/NU_BLUE(IGAM))**(1.0_LDP/FLOAT(GRAY_LINE_MIN-1))
	  T1=NU_RED(IGAM)*PLANCK
	  IF(T1 .GT. 1.0_LDP)THEN
	    BETA_TAIL_MIN=1.0_LDP-(NU_RED_INF2(IGAM)/NU_RED(IGAM))**&
		(1.0_LDP/FLOAT(GRAY_TAIL_MIN1-1))
	  ELSE IF(T1 .LE. 1.0_LDP .AND. T1 .GT. 0.5_LDP)THEN
	    BETA_TAIL_MIN=1.0_LDP-(NU_RED_INF2(IGAM)/NU_RED(IGAM))**&
		(1.0_LDP/FLOAT(GRAY_TAIL_MIN2-1))
	  ELSE IF(T1 .LE. 0.5_LDP .AND. T1 .GT. 0.1_LDP)THEN
	    BETA_TAIL_MIN=1.0_LDP-(NU_RED_INF2(IGAM)/NU_RED(IGAM))**&
		(1.0_LDP/FLOAT(GRAY_TAIL_MIN3-1))
	  ELSE IF(T1 .LE. 0.1_LDP)THEN
	    BETA_TAIL_MIN=1.0_LDP-(NU_RED_INF2(IGAM)/NU_RED(IGAM))**&
		(1.0_LDP/FLOAT(GRAY_TAIL_MIN4-1))
	  END IF
!
! I don't want to put a large number of points for low energy photons <~
! 20 keV
!
!	  T2=(1.0D0-1.0D0/(1.0D0+2.0D0*NU_RED_INF2(IGAM)*HoMC2))
!	  IF(T2 .LT. 0.075D0)DNU_TAIL_MIN=DLOG10(NU_RED(IGAM)/NU_RED_INF2(IGAM))/&
!			FLOAT(GRAY_LINE_MIN-1)
!
	  DO WHILE (NU_NEW .GT. NU_RED_INF2(IGAM))
	    IF (NU_NEW .GT. NU_BLUE(IGAM)) THEN
!
	      STRING='Before NU_BLUE(IGAM)'
	      DNU=(V_BETWEEN/SOL)*NU_NEW
	      DNU_BLUE=NU_NEW-NU_BLUE(IGAM)
	      T1=MINVAL((/DNU,DNU_BLUE/))
	      IF (DNU_BLUE .EQ. T1) THEN
	        STRING2='DNU_BLUE'
		NU_NEW=NU_BLUE(IGAM)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU .EQ. T1)THEN
		STRING2='DNU'
		NU_NEW=NU_NEW-DNU
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      END IF
		! Got up to the blue edge of the line
!
	    ELSE IF (NU_NEW .LE. NU_BLUE(IGAM) .AND. &
			 NU_NEW .GT. NU_RED(IGAM)) THEN
!
	      STRING='Across the line'
	      DNU=(V_LINE/SOL)*NU_NEW
	      DNU_LINE=NU_NEW-NU_VEC(IGAM)
	      DNU_RED=NU_NEW-NU_RED(IGAM)
	      DNU_BLUE=2.0_LDP*DNU_RED
	      DNU_LINE_MIN=BETA_LINE_MIN*NU_NEW
	      IF(NGAM .GT. 1 .AND. IGAM .NE. NGAM)THEN
		DNU_BLUE=NU_NEW-NU_BLUE(IGAM+1)
	      END IF
!
! Now we need to pick out the smallest number of this list
!
	      IF(.NOT. GRID_MIN_PTS)THEN
		IF(DNU_LINE .GT. 0.0_LDP)THEN
		  T1=MINVAL((/DNU,DNU_LINE,DNU_RED,DNU_BLUE/))
		ELSE
		  T1=MINVAL((/DNU,DNU_RED,DNU_BLUE/))
		END IF
	      ELSE
		IF(DNU_LINE .GT. 0.0_LDP)THEN
		  T1=MINVAL((/DNU_LINE,DNU_LINE_MIN,DNU_RED,DNU_BLUE/))
		ELSE
		  T1=MINVAL((/DNU_LINE_MIN,DNU_RED,DNU_BLUE/))
		END IF
	      END IF
!
	      IF (DNU .EQ. T1) THEN
		STRING2='DNU'
		NU_NEW=NU_NEW-DNU
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_LINE .EQ. T1) THEN
		STRING2='DNU_LINE'
		NU_NEW=NU_NEW-DNU_LINE
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_RED .EQ. T1)THEN
		STRING2='DNU_RED'
		NU_NEW=NU_NEW-DNU_RED
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_LINE_MIN .EQ. T1)THEN
		STRING2='DNU_LINE_MIN'
		NU_NEW=NU_NEW-DNU_LINE_MIN
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_BLUE .EQ. T1)THEN
		STRING2='DNU_BLUE (IGAM+1)'
		NU_NEW=NU_BLUE(IGAM+1)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
		! The code hit the next blue edge of the next line, so
		! we get out of this DO WHILE to go to the next line.
		EXIT
	      END IF
		 ! Done with going across the line from blue edge to red edge
	    ELSE IF (NU_NEW .LE. NU_RED(IGAM) .AND. &
			NU_NEW .GT. NU_RED_INF1(IGAM)) THEN
!
	      STRING='To red inf tail 1'
	      DNU=(V_TAIL/SOL)*NU_NEW
	      DNU_INF2=BETA_INF_MIN*NU_NEW
	      DNU_RED=NU_NEW-NU_RED_INF1(IGAM)
	      DNU_BLUE=1.1_LDP*DNU_RED
	      DNU_TAIL_MIN=BETA_TAIL_MIN*NU_NEW
	      IF(NGAM .NE. 1 .AND. IGAM .NE. NGAM)THEN
		DNU_BLUE=NU_NEW-NU_BLUE(IGAM+1)
	      END IF
!
! Now we need to pick out the smallest number of this list
!
	      IF(.NOT. GRID_MIN_PTS)THEN
		T1=MINVAL((/DNU,DNU_RED,DNU_BLUE,DNU_INF2/))
	      ELSE
		T1=MINVAL((/DNU_BLUE,DNU_TAIL_MIN,DNU_RED/))
	      END IF
!
	      IF (DNU .EQ. T1) THEN
		STRING2='DNU'
		NU_NEW=NU_NEW-DNU
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_RED .EQ. T1) THEN
		STRING2='DNU_RED'
		NU_NEW=NU_RED_INF1(IGAM)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_TAIL_MIN .EQ. T1) THEN
		STRING2='DNU_TAIL_MIN'
		NU_NEW=NU_NEW-DNU_TAIL_MIN
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_BLUE .EQ. T1) THEN
		STRING2='DNU_BLUE (IGAM+1)'
		NU_NEW=NU_BLUE(IGAM+1)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
		! The code hit the next blue edge of the next line, so
		! we get out of this DO WHILE to go to the next line.
		EXIT
	      ELSE IF(DNU_INF2 .EQ. T1) THEN
		STRING2='DNU_INF2'
		NU_NEW=NU_NEW-DNU_INF2
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      END IF
	    ELSE IF (NU_NEW .LE. NU_RED_INF1(IGAM) .AND. &
			NU_NEW .GT. NU_RED_INF2(IGAM)) THEN
!
	      STRING='To red inf tail 2'
	      DNU=(V_INF/SOL)*NU_NEW
	      DNU_INF2=BETA_INF_MIN*NU_NEW
	      DNU_RED=NU_NEW-NU_RED_INF2(IGAM)
	      DNU_BLUE=1.1_LDP*DNU_RED
	      DNU_TAIL_MIN=BETA_TAIL_MIN*NU_NEW
	      IF(NGAM .NE. 1 .AND. IGAM .NE. NGAM)THEN
		DNU_BLUE=NU_NEW-NU_BLUE(IGAM+1)
	      END IF
!
! Now we need to pick out the smallest number of this list
!
	      IF(.NOT. GRID_MIN_PTS)THEN
		T1=MINVAL((/DNU,DNU_RED,DNU_BLUE,DNU_INF2/))
	      ELSE
		T1=MINVAL((/DNU_TAIL_MIN,DNU_RED,DNU_BLUE/))
	      END IF
!
	      IF (DNU .EQ. T1) THEN
		STRING2='DNU'
		NU_NEW=NU_NEW-DNU
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_RED .EQ. T1) THEN
		STRING2='DNU_RED'
		NU_NEW=NU_RED_INF2(IGAM)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
		EXIT
	      ELSE IF(DNU_INF2 .EQ. T1) THEN
		STRING2='DNU_INF2'
		NU_NEW=NU_NEW-DNU_INF2
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_TAIL_MIN .EQ. T1) THEN
		STRING2='DNU_TAIL_MIN'
		NU_NEW=NU_NEW-DNU_TAIL_MIN
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	      ELSE IF(DNU_BLUE .EQ. T1) THEN
		STRING2='DNU_BLUE (IGAM+1)'
		NU_NEW=NU_BLUE(IGAM+1)
		INU=INU+1
		NU_GRID_VEC(INU)=NU_NEW
		IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
		CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,IGAM,NU_VEC,&
		    NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
		! The code hit the next blue edge of the next line, so
		! we get out of this DO WHILE to go to the next line.
		EXIT
	      END IF
	    END IF ! finished going through ALL parts of the line NU .GT. NU_BLUE(P)
	  END DO ! End of DO WHILE(NU_NEW .GT. NU_RED_INF2(IGAM)) loop
	END DO ! End of all lines. NE_GRID_VEC(IGAM)=NU_RED_INF2(IGAM)
!
! What is left to do is go to the minimum frequency denoted at the top
! of the code
!
	BETA=V_END/SOL
	T1=1.0_LDP-(NU_MIN/NU_NEW)**(1.0_LDP/FLOAT(GRAY_END_MIN-1))
	IF(GRID_MIN_PTS)BETA=T1
	DO WHILE(NU_NEW .GT. NU_MIN)
	  STRING='To NU_MIN'
	  DNU=NU_NEW*BETA
	  DNU_RED=NU_NEW-NU_MIN
	  IF(DNU .LT. DNU_RED)THEN
	    STRING2='DNU'
	    NU_NEW=NU_NEW-DNU
	    INU=INU+1
	    NU_GRID_VEC(INU)=NU_NEW
	    CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,NGAM,NU_VEC,&
		NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	  ELSE
	    STRING2='DNU_RED'
	    NU_NEW=NU_MIN
	    INU=INU+1
	    NU_GRID_VEC(INU)=NU_NEW
	    IF(GRID_TST)GAM_TST_NU_GRID(IGAM,NGAM,INU,NU_GRID_MAX,STRING,LUER)
	    CALL GAM_NU_GRID_ERR(INU,NU_GRID_VEC,NU_GRID_MAX,NGAM,NU_VEC,&
		NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2,NGAM,STRING,STRING2,LUER)
	    EXIT
	  END IF
	END DO
!
	NF_GRID_PTS=INU
!
	WRITE(LUER,'(A,I6)')"Number of gamma frequency grid pts:",NF_GRID_PTS
! Now let's check to make sure the frequency grid is monotonicly decreasing
	I=0
	DO L=1,NF_GRID_PTS
	  DO S=L+1,NF_GRID_PTS
		IF( NU_GRID_VEC(L) .LE. NU_GRID_VEC(S) )THEN
		  I=I+1
		  WRITE(LUER,*) "Gamma routine frequency grid NOT Monotonically decreasing"
		  WRITE(LUER,*) "Fails for line indexes", L, S
		  WRITE(LUER,*)NU_GRID_VEC(L),NU_GRID_VEC(S)
		END IF
	  END DO	
	END DO
	IF(NU_GRID_VEC(NF_GRID_PTS-1) .LE. NU_GRID_VEC(NF_GRID_PTS))THEN
	  I=I+1
	  L=NF_GRID_PTS-1
	  S=NF_GRID_PTS
	  WRITE(LUER,*) "Gamma routine frequency grid NOT Monotonically decreasing"
	  WRITE(LUER,*) "Fails for line indexes", L, S
	  WRITE(LUER,*)NU_GRID_VEC(L),NU_GRID_VEC(S)
	END IF
	WRITE(LUER,'(A,I10)') "# of non-monotonicly decreasing gamma nu grid pts:", I
	IF(I .NE. 0) STOP "*** GAMMA-RAY FREQUENCY GRID NOT MONOTONICALLY DECREASING ***"
!
        END SUBROUTINE
!
	SUBROUTINE GAM_NU_GRID_ERR(INU,NU,NMAX,IGAM,NU_LINES,NU_BLUE,NU_RED,&
	USE SET_KIND_MODULE
			NU_INF1,NU_INF2,NGAM,WARNING,STRING,LUER)
	IMPLICIT NONE
!
	INTEGER :: INU
	INTEGER :: IGAM
	INTEGER :: NMAX
	INTEGER :: NGAM
	INTEGER :: LUER
!
	REAL(KIND=LDP) :: NU(NMAX)
	REAL(KIND=LDP) :: NU_LINES(NGAM)
	REAL(KIND=LDP) :: NU_BLUE(NGAM)
	REAL(KIND=LDP) :: NU_RED(NGAM)
	REAL(KIND=LDP) :: NU_INF1(NGAM)
	REAL(KIND=LDP) :: NU_INF2(NGAM)
	REAL(KIND=LDP), PARAMETER :: H = 4.135668E-21_LDP ! MeV*s since NU is in Hz
!
	CHARACTER(LEN=80) :: WARNING
	CHARACTER(LEN=20) :: STRING
!
	IF(INU .EQ. NMAX)THEN
	  WRITE(LUER,'(A)')'Error in setting up Gamma-ray frequency grid'
	  WRITE(LUER,'(A)')'Frequency grid is full. Might neeed to allocate '//&
		'a larger grid.'
	  WRITE(LUER,'(A,1X,I5)')'Currently allocated:',NMAX
	  WRITE(LUER,'(A5,1X,I3,4X,A,1X,ES18.8)')'IGAM:',IGAM,'NU_LINES:',NU_LINES(IGAM)*H
	  WRITE(LUER,'(A)')TRIM(WARNING)
	  WRITE(LUER,'(A)')TRIM(STRING)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU (Hz):',NU(INU)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU (MeV):',NU(INU)*H
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_BLUE (Hz):',NU_BLUE(IGAM)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_BLUE (MeV):',NU_BLUE(IGAM)*H
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_RED (Hz):',NU_RED(IGAM)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_RED (MeV):',NU_RED(IGAM)*H
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_INF1 (Hz):',NU_INF1(IGAM)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_INF1 (MeV):',NU_INF1(IGAM)*H
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_INF2 (Hz):',NU_INF2(IGAM)
	  WRITE(LUER,'(A,1X,ES18.8)')'NU_INF2 (MeV):',NU_INF2(IGAM)*H
	  IF (NGAM .GT. 1 .AND. IGAM .NE. NGAM)THEN
	    WRITE(LUER,'(A)')'Look at line after it too...'
	    WRITE(LUER,'(A,1X,I3,4X,A,1X,ES18.8)')'IGAM+1:',IGAM+1,'NU_LINE:',&
		NU_LINES(IGAM+1)*H
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_BLUE (Hz):',NU_BLUE(IGAM+1)
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_BLUE (MeV):',NU_BLUE(IGAM+1)*H
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_RED (Hz):',NU_RED(IGAM+1)
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_RED (MeV):',NU_RED(IGAM+1)*H
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_INF1 (Hz):',NU_INF1(IGAM+1)
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_INF1 (MeV):',NU_INF1(IGAM+1)*H
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_INF2 (Hz):',NU_INF2(IGAM)
	    WRITE(LUER,'(A,1X,ES18.8)')'NU_INF2 (MeV):',NU_INF2(IGAM)*H
	  END IF
	  STOP
	END IF
	DEALLOCATE (MY_INDEX,WORK1,NU_BLUE,NU_RED,NU_RED_INF1,NU_RED_INF2)

	RETURN
	END
!
	SUBROUTINE GAM_TST_NU_GRID(IGAM,NGAM,INU,NMAX,STRING,LUER)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER :: IGAM
	INTEGER :: NGAM
	INTEGER :: INU
	INTEGER :: NMAX
	INTEGER :: LUER
	CHARACTER(LEN=*) :: STRING
!
	WRITE(LUER,'(A,I3,A,I3)')'Line ',IGAM,' / ',NGAM
	WRITE(LUER,'(A)')TRIM(STRING)
	WRITE(LUER,'(A,I5,A,I5)')'Frequency indx ',INU,' / ',NMAX
!
	RETURN
	END SUBROUTINE
