! Subroutine to compute the xray opacities
! My goal is calculate the xray opacity as function of frequency
! I have the compton opacities set up this way
!
!
	SUBROUTINE GAMMA_XCROSS_V4_TEST(NU,ND,CHI,E_SCAT_CHI,ED_TOT)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
!	USE XRAY_DATA_MOD
	IMPLICIT NONE
!
	REAL(KIND=LDP) :: CHI(ND)
	REAL(KIND=LDP) :: E_SCAT_CHI(ND)
	REAL(KIND=LDP) :: ED_TOT(ND)
	REAL(KIND=LDP) :: PHOTABS(ND)
	REAL(KIND=LDP) :: T1,T2,T3,T4
	REAL(KIND=LDP) :: NU 		! frequency in Hz
	REAL(KIND=LDP) :: XCROSS_V2
	REAL(KIND=LDP) :: CROSS_KN
	REAL(KIND=LDP) :: COMPTON_SIG
	REAL(KIND=LDP) :: EGAM
	REAL(KIND=LDP) :: XRAY
	REAL(KIND=LDP), PARAMETER :: PLANCK = 4.135668E-21_LDP ! MeV*s
	REAL(KIND=LDP), PARAMETER :: SIGT = 6.6524587E-25_LDP ! cm^2
	REAL(KIND=LDP), PARAMETER :: ALPHA = 7.297355257E-3_LDP ! units in cgs
	REAL(KIND=LDP), PARAMETER :: MeC2 = 0.5109989_LDP ! MeV
	EXTERNAL XCROSS_V2
	EXTERNAL CROSS_KN
	EXTERNAL COMPTON_SIG
!
	INTEGER :: ND
	INTEGER :: I,J
	INTEGER :: ISPEC,ID
	INTEGER :: LUNIT
	INTEGER, PARAMETER :: IZERO=0
	INTEGER :: IOS
!
	LOGICAL, PARAMETER :: L_FALSE=.FALSE.
!
	CHI=0.0_LDP
	E_SCAT_CHI=0.0_LDP
!	T4=CROSS_KN(NU)
	T4=COMPTON_SIG(NU)
	E_SCAT_CHI(1:ND)=ED_TOT(1:ND)*T4
!	DO ISPEC=1,NUM_SPECIES
!	  DO ID=SPECIES_BEG_ID(ISPEC),SPECIES_END_ID(ISPEC)
!	    IF (ATM(ID)%XzV_PRES) THEN
!	      T2=AT_NO(SPECIES_LNK(ID))+1-ATM(ID)%ZXzV
!	      T3=NU/1.0D+15
!	      T1=XCROSS_V2(T3,AT_NO(SPECIES_LNK(ID)),T2,IZERO,IZERO,L_FALSE,L_FALSE)
!	      IF(T1 .NE. 0.0D0 .AND. ID .NE. SPECIES_END_ID(ISPEC))THEN
!	        DO I=1,ND
!	          T2=0.0D0			!Temporary CHI
!	          DO J=1,ATM(ID)%NXzV_F
!		    T2=T2+ATM(ID)%XzV_F(J,I)
!	          END DO
!	          CHI(I)=CHI(I)+T1*T2
!	        END DO
!	      ELSE IF (T1 .NE. 0.0D0 .AND. ID .EQ. SPECIES_END_ID(ISPEC)) THEN
!	        DO I=1,ND
!	          T2=ATM(ID)%DXzV(I) 		!Temporary CHI
!	          CHI(I)=CHI(I)+T1*T2
!	        END DO
!	      END IF
!	    END IF
!	  END DO
!	END DO
	PHOTABS=0.0_LDP
	DO I=1,ND
	  DO ISPEC=1,NUM_SPECIES
	    IF(SPECIES_PRES(ISPEC))THEN
	      PHOTABS(I)=PHOTABS(I)+POP_SPECIES(I,ISPEC)*AT_NO(ISPEC)**5
	    END IF
	  END DO
	END DO
	PHOTABS=PHOTABS*1.0E+10_LDP*SIGT*ALPHA*ALPHA*ALPHA*ALPHA*8.0_LDP*SQRT(2.0_LDP)
	EGAM=NU*PLANCK/MeC2
	XRAY=1.0_LDP/(EGAM**3.5_LDP)
	CHI(1:ND)=PHOTABS(1:ND)*XRAY
!
	RETURN
	END SUBROUTINE
!
!*********************************************************************************************************
!
	FUNCTION CROSS_KN(NU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	REAL(KIND=LDP) :: NU
	REAL(KIND=LDP) :: CROSS_KN 	! will return in units of cm^2
!
	REAL(KIND=LDP) :: EPSI
	REAL(KIND=LDP) :: X
	REAL(KIND=LDP) :: PI
	REAL(KIND=LDP) :: R_E
	REAL(KIND=LDP) :: R_E_SQD
!
	REAL(KIND=LDP), PARAMETER :: ONE=1.0_LDP
	REAL(KIND=LDP), PARAMETER :: TWO=2.0_LDP
	REAL(KIND=LDP), PARAMETER :: R_C=2.42630694715E-10_LDP ! h/(m_e*c) in units of cm
	REAL(KIND=LDP), PARAMETER :: H = 4.135668E-021_LDP	! Units of MeV*s
	REAL(KIND=LDP), PARAMETER :: M_E = 0.5109989_LDP	! Units of MeV
	REAL(KIND=LDP), PARAMETER :: ALPHA=0.007297355257_LDP 	! Fine structure constant
!
	PI=ACOS(-ONE)
	R_E=(ALPHA*R_C)/(TWO*PI) ! units of cm
	R_E_SQD=R_E*R_E
!
	X = ( NU*H )/M_E
	EPSI = ONE+TWO*X
!
!	CROSS_KN = ( 2.0D0*Pi*r_e_squared )*( ((ONE+EPSI)/(EPSI*EPSI))*(2.0D0*(ONE+EPSI)/(ONE+2.0D0*EPSI)-LOG(ONE+2.0D0*EPSI)/EPSI)
!	1		+LOG(ONE+2.0D0*EPSI)/(2.0D0*EPSI)-(ONE+3.0D0*EPSI)/(ONE+2.0D0*EPSI)/(ONE+2.0D0*EPSI) )
	CROSS_KN=TWO*PI*( ((ONE+X)/X/X/X)*( (TWO*X*(ONE+X))/EPSI-LOG(EPSI) )
	1		+ LOG(EPSI)/TWO/X - (EPSI+X)/EPSI/EPSI )
!
	RETURN
	END FUNCTION CROSS_KN
