!
! Altered : 18-Nov-2021 : NUM_DAYS and DECAY_LUM(:) added to  NUC_ISOTOPE_DATA (KDW change)
!                           DEL_T changed to NUC_ISO_MOD_DELTA_T
! Altered : 26-Feb-2019 : DECAY_CHAIN_AVAILABLE added (or earlier)
! Altered : 17-Feb-2016 : Added READ_ISO_POPS to NUC_ISOTOPE_DATA type.
! Altered : 15-Feb-2015 : Added KINETIC_DACAY_ENERGY (12-Jan-2015 on OSPREY[cur_cmf_gam])
! Altered 15-Jul-2010   : Increased MAX_NUM_ISOTOPES from 20 to 50.
!
	MODULE NUC_ISO_MOD
	USE SET_KIND_MODULE
	IMPLICIT NONE
	INTEGER, PARAMETER :: MAX_NUM_DECAY_PATHS=30
	INTEGER, PARAMETER :: MAX_NUM_ISOTOPES=200
	INTEGER NUM_ISOTOPES
	INTEGER NUM_DECAY_PATHS
	INTEGER NUM_PARENTS
	LOGICAL DO_RAD_DECAYS
	REAL(KIND=LDP) :: NUC_ISO_MOD_DELTA_T
!
	REAL(KIND=LDP), POINTER :: RADIOACTIVE_DECAY_ENERGY(:)
	REAL(KIND=LDP), POINTER :: KINETIC_DECAY_ENERGY(:)
!
	TYPE NUC_PARENT_DATA
	  REAL(KIND=LDP), POINTER :: OLD_POP(:)
	  REAL(KIND=LDP), POINTER :: OLD_POP_DECAY(:)
	  INTEGER ISPEC
	  LOGICAL DECAY_CHAIN_AVAILABLE
	END TYPE NUC_PARENT_DATA
!
! We use
!       POP           to refer to ISOTOP population at the current epoch.
!       OLD_POP       to refer to ISOTOPE population at the previous epoch.
!       OLD_POP_DECAY to refer to ISOTOPE population at the previous epoch,
!                        but corrected for between the current and previous epoch.
!       ISPEC         to the species link in MOD_CMFGEN.
!
	TYPE NUC_ISOTOPE_DATA
	  REAL(KIND=LDP), POINTER :: POP(:)
	  REAL(KIND=LDP), POINTER :: OLD_POP(:)
	  REAL(KIND=LDP), POINTER :: OLD_POP_DECAY(:)
	  REAL(KIND=LDP), POINTER :: NUM_DECAYS(:)	! added to count the amount of gamma rays for decay purposes
	  REAL(KIND=LDP), POINTER :: DECAY_LUM(:) 	! Ergs/cm^3/s
!
	  REAL(KIND=LDP) MASS
          INTEGER BARYON_NUMBER
	  INTEGER LNK_TO_PAR
	  INTEGER ISPEC
	  LOGICAL STABLE
	  LOGICAL READ_ISO_POPS
          CHARACTER*10 SPECIES
	END TYPE NUC_ISOTOPE_DATA
!
	TYPE NUC_DECAY_DATA
	  REAL(KIND=LDP) HALF_LIFE              !seconds
	  REAL(KIND=LDP) DECAY_CONST		!seconds
	  REAL(KIND=LDP) MASS			!AMU
	  REAL(KIND=LDP) DAUGHTER_MASS
	  REAL(KIND=LDP) ENERGY_PER_DECAY
	  REAL(KIND=LDP) KINETIC_PER_DECAY
	  INTEGER ISPEC			!Link to species in MOD_CMFGEN
	  INTEGER LNK_TO_ISO		!Link to the corresponding isotope in ISOTOPE_DATA
          INTEGER BARYON_NUMBER
	  INTEGER DAUGHTER_ISPEC
	  INTEGER DAUGHTER_LNK_TO_ISO
          INTEGER DAUGHTER_BARYON_NUMBER
          CHARACTER*10 SPECIES
          CHARACTER*10 DAUGHTER
          CHARACTER*1  SEQUENCE
	END TYPE NUC_DECAY_DATA
!
	TYPE (NUC_PARENT_DATA)  PAR(MAX_NUM_ISOTOPES)
	TYPE (NUC_ISOTOPE_DATA) ISO(MAX_NUM_ISOTOPES)
	TYPE (NUC_DECAY_DATA)   NUC(MAX_NUM_DECAY_PATHS)
!
	SAVE
	END MODULE NUC_ISO_MOD
