	MODULE CMF_HYDRO_MODULE
	USE SET_KIND_MODULE
!
	  REAL(KIND=LDP) GAM_EDD
	  REAL(KIND=LDP) GAM_LIM
	  REAL(KIND=LDP) GAM_FULL
	  REAL(KIND=LDP) AMU			!Atomic mass unit
	  REAL(KIND=LDP) MU_ATOM		!Mean atomic mass in amu
	  REAL(KIND=LDP) BC			!Boltzmann constant
	  REAL(KIND=LDP) C_CMS
	  REAL(KIND=LDP) SIGMA_TH		!Thompson cross-section
	  REAL(KIND=LDP) STEFAN_BC		!Stephan-Boltzmann constant
	  REAL(KIND=LDP) LOGG			!Log (surface gravity) (cgs units)
	  REAL(KIND=LDP) MDOT
	  REAL(KIND=LDP) GRAV_CON
	  REAL(KIND=LDP) REFERENCE_RADIUS
	  REAL(KIND=LDP) PREV_REF_RADIUS
	  REAL(KIND=LDP) RADIUS_AT_TAU_23
	  REAL(KIND=LDP) SOUND_SPEED
	  REAL(KIND=LDP) MOD_SOUND_SPEED
	  REAL(KIND=LDP) VTURB
!
! The following quantities are used when integrating the hydrostatic equation.
! KAP is used to refer to mass absorption opacities.
!
	  REAL(KIND=LDP) R_EST
	  REAL(KIND=LDP) T_EST
	  REAL(KIND=LDP) P_EST
	  REAL(KIND=LDP) TAU_EST
	  REAL(KIND=LDP) ED_ON_NA_EST
	  REAL(KIND=LDP) ATOM_EST
	  REAL(KIND=LDP) TEFF
	  REAL(KIND=LDP) ROSS_ON_ES
	  REAL(KIND=LDP) KAP_ROSS
	  REAL(KIND=LDP) KAP_ES
	  REAL(KIND=LDP) V_EST
	  REAL(KIND=LDP) F_EST
	  REAL(KIND=LDP) T_SCALING_FACTOR
!
	  REAL(KIND=LDP) dPdR
	  REAL(KIND=LDP) dTAUdR
!
	  REAL(KIND=LDP) OLD_TEFF
	  REAL(KIND=LDP) OLD_REF_RADIUS
	  LOGICAL PURE_LTE_EST
	  LOGICAL OLD_MODEL
	  LOGICAL WIND_PRESENT
	  LOGICAL PLANE_PARALLEL_MOD
	  LOGICAL RESET_REF_RADIUS
	  INTEGER, SAVE :: LAST_HYDRO_ITERATION=0

	END MODULE CMF_HYDRO_MODULE 	
