!
! Subroutine designed to correct species and isotope populations for
! radioactive decays. Upon entry:
!     (1) radioactive data must be set
!     (2) ISO%OLD_POP must be set.
!
! Upon exit ISO%OLD_POP_DECAY is set.
!           PAR_ISO           is set.
!
! This routine currently only works for 1 and 2-step decay processes.
!
! e.g., Ni56 --> Co56 -- Fe56
!
	SUBROUTINE DO_SPECIES_DECAYS_V2(INSTANTANEOUS_ENERGY_DEPOSITION,DELTA_T,ND)
	USE SET_KIND_MODULE
	USE NUC_ISO_MOD
	IMPLICIT NONE
!
! Altered: 31-May-2016 : Decay energy (Lsun)from each chain output to OUTEGN.
! Altered: 01-Mar-2016 : Changed to allow handling of a standard NUC_DECAY_DATA file.
!                         Code checks availability of decay route. This is important
!                         when a species but not isotopes are included [17-Feb-2016].
! Altered: 02-Sep-2013 : Minor bug fix -- added excess energy (for those Ni
!                            that decay all the way to 56Fe in a single time step).
! Altered: 23-Nov-2012 : Added 1 step decay process
!
	INTEGER ND
	REAL(KIND=LDP) VEC1(ND)
	REAL(KIND=LDP) VEC2(ND)
	REAL(KIND=LDP) VEC3(ND)
	REAL(KIND=LDP) DELTA_T
	REAL(KIND=LDP) PREV_RAD_SUM,CUR_RAD_SUM
	REAL(KIND=LDP) PREV_EK_SUM,CUR_EK_SUM
	LOGICAL INSTANTANEOUS_ENERGY_DEPOSITION
!
	INTEGER IN
	INTEGER IP
	INTEGER JN
!
	INTEGER IS
	INTEGER JS
	INTEGER LS
!
	INTEGER K,L,M
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
	CHARACTER(LEN=20) TMP_STR
!
	NUC_ISO_MOD_DELTA_T=DELTA_T
	LUER=ERROR_LU()
	DO IS=1,NUM_ISOTOPES
	  ISO(IS)%OLD_POP_DECAY=ISO(IS)%OLD_POP
	END DO
	RADIOACTIVE_DECAY_ENERGY=0.0_LDP
	KINETIC_DECAY_ENERGY=0.0_LDP
	CUR_RAD_SUM=0.0_LDP
	CUR_EK_SUM=0.0_LDP
!
	WRITE(TMP_STR,'(F12.2)')DELTA_T; TMP_STR=ADJUSTL(TMP_STR)
	WRITE(LUER,'(A,F6.2,A)')' In DO_SPECIES_DECAYS, Delta t = '//TRIM(TMP_STR)//
	1                   ' s (',DELTA_T/3600.0D0/24.0D0,' days)'
	WRITE(LUER,*)' '
	WRITE(LUER,*)'Summary of chains contributing to radioactive energy depostions.'
	WRITE(LUER,*)' '
!
! Testing file for KDW25 for gamma-ray code
!
	OPEN(UNIT=7,FILE='NUM_DECAYS_INFO',ACTION='WRITE',STATUS='UNKNOWN')
!
	DO IN=1,NUM_DECAY_PATHS
	  PREV_RAD_SUM=CUR_RAD_SUM
	  PREV_EK_SUM=CUR_EK_SUM
!
! Do decay chains with a single decay route.
!
	  IS=NUC(IN)%LNK_TO_ISO
	  JS=NUC(IN)%DAUGHTER_LNK_TO_ISO
	  IF(NUC(IN)%SEQUENCE ==  'E' .AND. IS*JS .NE. 0)THEN
	    VEC1=EXP(-NUC(IN)%DECAY_CONST*DELTA_T)
!	    WRITE(6,*)'Found one step nuclear reaction chain:',IN
	    ISO(IS)%OLD_POP_DECAY=ISO(IS)%OLD_POP*VEC1
	    ISO(JS)%OLD_POP_DECAY=ISO(JS)%OLD_POP + ISO(IS)%OLD_POP*(1.0_LDP-VEC1)
!
! This next piece is to count the number of gamma rays via change in
! populations - added by KDW25
!
	      ISO(IS)%NUM_DECAYS=ISO(IS)%OLD_POP*(1.0_LDP-VEC1)
	      WRITE(7,'(A8,2X,A10,5X,A5,1X,F11.6)')'Isotope:',ISO(IS)%SPECIES,'MASS:',ISO(IS)%MASS
	      CALL WRITV_V2(ISO(IS)%NUM_DECAYS,ND,6,'DECAYS',7)
!^
!
	    IF(DELTA_T .EQ. 0.0_LDP)THEN
	    ELSE IF(INSTANTANEOUS_ENERGY_DEPOSITION)THEN
!
! Next part added for gamma-ray code. The energy per decay is left out
! since the intrinsic emissivity will acount for each line's energy.
! - added by KDW25
!
	      ISO(IS)%DECAY_LUM=NUC(IN)%DECAY_CONST*ISO(IS)%OLD_POP_DECAY
!^
!
	      RADIOACTIVE_DECAY_ENERGY=RADIOACTIVE_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP_DECAY*NUC(IN)%ENERGY_PER_DECAY*NUC(IN)%DECAY_CONST
	      KINETIC_DECAY_ENERGY=KINETIC_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP_DECAY*NUC(IN)%KINETIC_PER_DECAY*NUC(IN)%DECAY_CONST
	      CALL GET_DECAY_LUM_V1(CUR_RAD_SUM,RADIOACTIVE_DECAY_ENERGY,ND)
	      CALL GET_DECAY_LUM_V1(CUR_EK_SUM,KINETIC_DECAY_ENERGY,ND)
	      WRITE(LUER,'(1X,I3,3X,A10,3X,A10,13X,2ES14.4)')
	1                 NUC(IN)%BARYON_NUMBER,
	1                 NUC(IN)%SPECIES,NUC(IN)%DAUGHTER,
	1                 CUR_RAD_SUM-PREV_RAD_SUM,
	1                 CUR_EK_SUM-PREV_EK_SUM
	    ELSE
	      RADIOACTIVE_DECAY_ENERGY=RADIOACTIVE_DECAY_ENERGY +
	1             ISO(IS)%OLD_POP*(1.0_LDP-VEC1)*NUC(IN)%ENERGY_PER_DECAY
	      KINETIC_DECAY_ENERGY=KINETIC_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1)*NUC(IN)%KINETIC_PER_DECAY
	      CALL GET_DECAY_LUM_V1(CUR_RAD_SUM,RADIOACTIVE_DECAY_ENERGY,ND)
	      CALL GET_DECAY_LUM_V1(CUR_EK_SUM,KINETIC_DECAY_ENERGY,ND)
	      WRITE(LUER,'(1X,I3,3X,A10,3X,A10,13X,2ES14.4)')
	1                 NUC(IN)%BARYON_NUMBER,
	1                 NUC(IN)%SPECIES,NUC(IN)%DAUGHTER,
	1                 (CUR_RAD_SUM-PREV_RAD_SUM)/DELTA_T,
	1                 (CUR_EK_SUM-PREV_EK_SUM)/DELTA_T
	    END IF
!
! Do two step sequences.
!
	  ELSE IF(NUC(IN)%SEQUENCE ==  'F' .AND. IS .NE. 0)THEN
	    VEC1=EXP(-NUC(IN)%DECAY_CONST*DELTA_T)
	    DO JN=1,NUM_DECAY_PATHS
	      IF(NUC(JN)%SEQUENCE ==  'S' .AND. NUC(JN)%BARYON_NUMBER .EQ.  NUC(IN)%BARYON_NUMBER .AND.
	1        NUC(JN)%SPECIES .EQ. NUC(IN)%DAUGHTER)THEN
!	        WRITE(6,*)'Found nuclear reaction chain:',IN,JN
	        JS=NUC(JN)%LNK_TO_ISO
	        IF(JS .EQ. 0)EXIT
	        VEC2=EXP(-NUC(JN)%DECAY_CONST*DELTA_T)
	        VEC3=NUC(IN)%DECAY_CONST*( EXP(-NUC(JN)%DECAY_CONST*DELTA_T) -
	1                   EXP(-NUC(IN)%DECAY_CONST*DELTA_T) )/(NUC(IN)%DECAY_CONST-NUC(JN)%DECAY_CONST)
	        LS=NUC(JN)%DAUGHTER_LNK_TO_ISO
		ISO(IS)%OLD_POP_DECAY=ISO(IS)%OLD_POP*VEC1
		ISO(JS)%OLD_POP_DECAY=ISO(JS)%OLD_POP*VEC2 + ISO(IS)%OLD_POP*VEC3
	        ISO(LS)%OLD_POP_DECAY=ISO(LS)%OLD_POP +
	1                             ISO(JS)%OLD_POP*(1.0_LDP-VEC2) +
	1                             ISO(IS)%OLD_POP*(1.0_LDP-VEC1-VEC3)
!
! This next piece is to count the number of gamma rays via change in
! populations - added by KDW25
!
		ISO(IS)%NUM_DECAYS=ISO(IS)%OLD_POP*(1.0_LDP-VEC1)
		ISO(JS)%NUM_DECAYS=ISO(JS)%OLD_POP*(1.0_LDP-VEC2) +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1-VEC3)
	        WRITE(7,'(A8,2X,A10,5X,A5,1X,F11.6)')'Isotope:',ISO(IS)%SPECIES,'MASS:',ISO(IS)%MASS
		CALL WRITV_V2(ISO(IS)%NUM_DECAYS,ND,6,'DECAYS',7)
		WRITE(7,'(A8,2X,A10,5X,A5,1X,F11.6)')'Isotope:',ISO(JS)%SPECIES,'MASS:',ISO(JS)%MASS
		CALL WRITV_V2(ISO(JS)%NUM_DECAYS,ND,6,'DECAYS',7)
!^
!
	        IF(DELTA_T .EQ. 0.0_LDP)THEN
	        ELSE IF(INSTANTANEOUS_ENERGY_DEPOSITION)THEN
!
! Next part added for gamma-ray code. The energy per decay is left out
! since the intrinsic emissivity will acount for each line's energy.
! - added by KDW25
!
	          ISO(IS)%DECAY_LUM=NUC(IN)%DECAY_CONST*ISO(IS)%OLD_POP_DECAY
		  ISO(JS)%DECAY_LUM=NUC(JN)%DECAY_CONST*ISO(JS)%OLD_POP_DECAY
!^
!
	          RADIOACTIVE_DECAY_ENERGY=RADIOACTIVE_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP_DECAY*NUC(IN)%ENERGY_PER_DECAY*NUC(IN)%DECAY_CONST +
	1            ISO(JS)%OLD_POP_DECAY*NUC(JN)%ENERGY_PER_DECAY*NUC(JN)%DECAY_CONST
	          KINETIC_DECAY_ENERGY=KINETIC_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP_DECAY*NUC(IN)%KINETIC_PER_DECAY*NUC(IN)%DECAY_CONST +
	1            ISO(JS)%OLD_POP_DECAY*NUC(JN)%KINETIC_PER_DECAY*NUC(JN)%DECAY_CONST
	          CALL GET_DECAY_LUM_V1(CUR_RAD_SUM,RADIOACTIVE_DECAY_ENERGY,ND)
	          CALL GET_DECAY_LUM_V1(CUR_EK_SUM,KINETIC_DECAY_ENERGY,ND)
	          WRITE(6,'(1X,I3,3X,A10,3X,A10,3X,A10,2ES14.4)')
	1                 NUC(IN)%BARYON_NUMBER,
	1                 NUC(IN)%SPECIES,NUC(IN)%DAUGHTER,NUC(JN)%DAUGHTER,
	1                 CUR_RAD_SUM-PREV_RAD_SUM,
	1                 CUR_EK_SUM-PREV_EK_SUM
	        ELSE
	          RADIOACTIVE_DECAY_ENERGY=RADIOACTIVE_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1)*NUC(IN)%ENERGY_PER_DECAY +
	1            ISO(JS)%OLD_POP*(1.0_LDP-VEC2)*NUC(JN)%ENERGY_PER_DECAY +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1-VEC3)*NUC(JN)%ENERGY_PER_DECAY
	          KINETIC_DECAY_ENERGY=KINETIC_DECAY_ENERGY +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1)*NUC(IN)%KINETIC_PER_DECAY +
	1            ISO(JS)%OLD_POP*(1.0_LDP-VEC2)*NUC(JN)%KINETIC_PER_DECAY +
	1            ISO(IS)%OLD_POP*(1.0_LDP-VEC1-VEC3)*NUC(JN)%KINETIC_PER_DECAY
	          CALL GET_DECAY_LUM_V1(CUR_RAD_SUM,RADIOACTIVE_DECAY_ENERGY,ND)
	          CALL GET_DECAY_LUM_V1(CUR_EK_SUM,KINETIC_DECAY_ENERGY,ND)
	          WRITE(6,'(1X,I3,3X,A10,3X,A10,3X,A10,2ES14.4)')
	1                 NUC(IN)%BARYON_NUMBER,
	1                 NUC(IN)%SPECIES,NUC(IN)%DAUGHTER,NUC(JN)%DAUGHTER,
	1                 (CUR_RAD_SUM-PREV_RAD_SUM)/DELTA_T,
	1                 (CUR_EK_SUM-PREV_EK_SUM)/DELTA_T
	        END IF
	        EXIT
	      END IF
	    END DO
	  END IF
	END DO
!
	CLOSE(UNIT=7)
!
	IF(DELTA_T .EQ. 0.0_LDP)THEN
	ELSE IF(INSTANTANEOUS_ENERGY_DEPOSITION)THEN
	  WRITE(LUER,'(/,7X,A5,31X,2ES14.4)')'TOTAL',CUR_RAD_SUM,CUR_EK_SUM
	ELSE
	  RADIOACTIVE_DECAY_ENERGY=RADIOACTIVE_DECAY_ENERGY/DELTA_T		!ergs/sec
	  KINETIC_DECAY_ENERGY=KINETIC_DECAY_ENERGY/DELTA_T			!ergs/sec
	  WRITE(LUER,'(/,7X,A5,31X,2ES14.4)')'TOTAL',
	1         CUR_RAD_SUM/DELTA_T,CUR_EK_SUM/DELTA_T
	END IF
!
	DO IP=1,NUM_PARENTS
	  IF(PAR(IP)%DECAY_CHAIN_AVAILABLE)THEN
	    PAR(IP)%OLD_POP=0.0_LDP
	    PAR(IP)%OLD_POP_DECAY=0.0_LDP
	  END IF
	END DO
	DO IS=1,NUM_ISOTOPES
	  IP=ISO(IS)%LNK_TO_PAR
	  IF(PAR(IP)%DECAY_CHAIN_AVAILABLE)THEN
	    PAR(IP)%OLD_POP=PAR(IP)%OLD_POP+ISO(IS)%OLD_POP
	    PAR(IP)%OLD_POP_DECAY=PAR(IP)%OLD_POP_DECAY+ISO(IS)%OLD_POP_DECAY
	  END IF
	END DO
!
	RETURN
	END
