	SUBROUTINE GET_EXCITE_TEMP(T,TEXC,DC,EDGE_FREQ,HDKT,ACCURACY,ND)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER ND
	REAL(KIND=LDP) T(ND)
	REAL(KIND=LDP) TEXC(ND)
	REAL(KIND=LDP) DC(ND)
	REAL(KIND=LDP) EDGE_FREQ
	REAL(KIND=LDP) HDKT
	REAL(KIND=LDP) ACCURACY
!
! Local variables.
!
	REAL(KIND=LDP) T1,T2,T3
	REAL(KIND=LDP) dTONT
	REAL(KIND=LDP) OLD_VAL
	REAL(KIND=LDP) NU_HDKT
!
	INTEGER J,K,L
!
	NU_HDKT=EDGE_FREQ*HDKT	
!
! We use DYNAMIC scheduling as inner loop is of variable length.
!
! OMP PARALLEL DO IF(L > 5) PRIVATE(T1,T2,T3,J,L,dTONT) SCHEDULE(DYNAMIC)
	DO L=1,ND
	  TEXC(L)=T(L)
	  OLD_VAL=1.0E-04_LDP
	  DO J=1,1000
	    T1=EXP(NU_HDKT*(1.0_LDP/TEXC(L)-1.0_LDP/T(L)))
	    T2=DC(L)-T1*(T(L)/TEXC(L))**1.5_LDP
	    T3=( NU_HDKT/TEXC(L)+1.5_LDP*(T(L)/TEXC(L))**(1.5_LDP) )*T1
	    dTONT=-T2/T3
	    IF(dTONT .LT. -0.6_LDP)THEN
	      TEXC(L)=0.4_LDP*TEXC(L)
	    ELSE IF(dTONT .GT. 4.0_LDP)THEN
	      TEXC(L)=4*TEXC(L)
	    ELSE
	      TEXC(L)=TEXC(L)*(1.0_LDP+dTONT)
	    END IF
	    IF(ABS(TEXC(L)/OLD_VAL-1.0_LDP) .LT. ACCURACY)EXIT
	    OLD_VAL=TEXC(L)
	  END DO
	END DO
!
	RETURN
	END
