	SUBROUTINE BETHE_APPROX_V4(Q,NL,NUP,XKT,dXKT,NKT,ID,DPTH_INDX)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	IMPLICIT NONE
!
! Altered 10-Feb-2012: Improved computation of gbar. Expression now works for
!                        very low energies, andhigh energies.
!
	INTEGER ID
	INTEGER DPTH_INDX
	INTEGER NKT
	INTEGER NL,NUP
	REAL(KIND=LDP) Q(NKT)
	REAL(KIND=LDP) XKT(NKT)
	REAL(KIND=LDP) dXKT(NKT)
!
	LOGICAL FAST_METHOD
!
	REAL(KIND=LDP), PARAMETER :: PI=3.141592653589793238462643_LDP
	REAL(KIND=LDP), PARAMETER :: A0 = 0.529189379E-8_LDP    		!Bohr radius in cm
	REAL(KIND=LDP), PARAMETER :: Hz_TO_EV=4.1356691_LDP
	REAL(KIND=LDP), PARAMETER :: COL_CONST=13.6_LDP*8.0_LDP*PI*PI*A0*A0/1.732_LDP
	REAL(KIND=LDP), PARAMETER :: COEF0=-0.0745397_LDP
	REAL(KIND=LDP), PARAMETER :: COEF1=0.232715_LDP
	REAL(KIND=LDP), PARAMETER :: COEF2=-0.00647558_LDP
	REAL(KIND=LDP), PARAMETER :: CONNECT_POINT=1.2212243_LDP
!
	REAL(KIND=LDP) GBAR
	REAL(KIND=LDP) X
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) dE
	REAL(KIND=LDP) dE_eV
!
	INTEGER IKT
!
	Q(:)=0.0_LDP
	dE=ATM(ID)%EDGEXzV_F(NL)-ATM(ID)%EDGEXzV_F(NUP)
	IF(dE .LE. 0)RETURN
	dE_eV=Hz_to_eV*dE
!	T2=3.28978D0/dE
!       3.28978 ~ 13.6/Hz_to_eV
!
	IF(ATM(ID)%AXzV_F(NUP,NL) .GT. 1.0E+03_LDP .OR. ATM(ID)%NT_OMEGA(NL,NUP) .EQ. 0.0_LDP)THEN
	  T1=3.28978_LDP*COL_CONST*ATM(ID)%AXzV_F(NL,NUP)*ATM(ID)%XzV_F(NL,DPTH_INDX)/dE*ATM(ID)%CROSEC_NTFAC
	  DO IKT=1,NKT
	    GBAR=0.0_LDP
	    IF(XKT(IKT) .GE. dE_eV)THEN
	      X = sqrt(xkt(ikt)/dE_eV-1.0_LDP)
	      IF(( NINT(ATM(ID)%ZXzV) .NE. 1) .AND. (X .LE. CONNECT_POINT))THEN
	        GBAR = 0.2_LDP
	      ELSE IF(X .LE. 0.80_LDP)THEN
	        GBAR = 0.074_LDP*X*(1.0_LDP+X)
	      ELSE IF(X .LE. 6)THEN
	        GBAR = COEF0 + COEF1*X + COEF2*X*X
	      ELSE
	        GBAR = +0.105_LDP+LOG(X)/1.8138_LDP
	      END IF
	      IF(GBAR .GE. 0.0_LDP)THEN
	        Q(IKT)=T1*GBAR*dXKT(IKT)/XKT(IKT)
	      ENDIF
	    END IF
	  END DO
	ELSE IF(ATM(ID)%NT_OMEGA(NL,NUP) .NE. 0.0_LDP)THEN
	  T1=PI*A0*A0*13.6_LDP
	  T1=T1*ATM(ID)%NT_OMEGA(NL,NUP)/ATM(ID)%GXzV_F(NL)*ATM(ID)%XzV_F(NL,DPTH_INDX)
	  DO IKT=1,NKT
	    IF(XKT(IKT) .GE. dE_eV)THEN
	      Q(IKT)=T1*dXKT(IKT)/XKT(IKT)
	    END IF
	  END DO
	ELSE
!
	END IF
!
	RETURN
	END
