	SUBROUTINE BETHE_APPROX_V5(Q,NL,NUP,XKT,dXKT_ON_XKT,NKT,ID,DPTH_INDX)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	IMPLICIT NONE
!
! Altered 08-Feb-2014: Added ATM(ID)%CROSEC_NTFAC to rate computed with collision strngth.
! Altered 15-Nov-2012: Changed to V5:
!                        Call changed -- dXKT_ON_XKT passed in call instead of dXKT.
!                        Test on XSQ rather than X
!                        OMP instructions inserted.
! Altered 10-Feb-2012: Improved computation of gbar. Expression now works for
!                        very low energies, andhigh energies.
!
	INTEGER ID
	INTEGER DPTH_INDX
	INTEGER NKT
	INTEGER NL,NUP
	REAL(KIND=LDP) Q(NKT)
	REAL(KIND=LDP) XKT(NKT)
	REAL(KIND=LDP) dXKT_ON_XKT(NKT)
!
	LOGICAL FAST_METHOD
!
	REAL(KIND=LDP), PARAMETER :: PI=3.141592653589793238462643_LDP
	REAL(KIND=LDP), PARAMETER :: A0 = 0.529189379E-8_LDP    		!Bohr radius in cm
	REAL(KIND=LDP), PARAMETER :: Hz_TO_EV=4.1356691_LDP
	REAL(KIND=LDP), PARAMETER :: COL_CONST=13.6_LDP*8.0_LDP*PI*PI*A0*A0/1.732_LDP
	REAL(KIND=LDP), PARAMETER :: COEF0=-0.0745397_LDP
	REAL(KIND=LDP), PARAMETER :: COEF1=0.232715_LDP
	REAL(KIND=LDP), PARAMETER :: COEF2=-0.00647558_LDP
	REAL(KIND=LDP), PARAMETER :: CONNECT_POINT=1.2212243_LDP
	REAL(KIND=LDP), PARAMETER :: CONNECT_POINT_SQ=CONNECT_POINT*CONNECT_POINT
!
	REAL(KIND=LDP) GBAR
	REAL(KIND=LDP) X,XSQ
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) dE
	REAL(KIND=LDP) dE_eV
!
	INTEGER NIN,NOUT
	INTEGER J
	INTEGER IKT
!
! NIN & NOUT are used to make the loop over IKT parallizable.
!
	NOUT=16
	NIN=1+(NKT-1)/NOUT
!
!$OMP PARALLEL DO
	DO J=1,NOUT
	  DO IKT=(J-1)*NIN+1,MIN(J*NIN,NKT)
	    Q(IKT)=0.0_LDP
	  END DO
	END DO
!
	dE=ATM(ID)%EDGEXzV_F(NL)-ATM(ID)%EDGEXzV_F(NUP)
	IF(dE .LE. 0)RETURN
	dE_eV=Hz_to_eV*dE
!	T2=3.28978D0/dE
!       3.28978 ~ 13.6/Hz_to_eV
!
	CALL TUNE(1,'APPROX')
	IF(ATM(ID)%AXzV_F(NUP,NL) .GT. 1.0E+03_LDP .OR. ATM(ID)%NT_OMEGA(NL,NUP) .EQ. 0.0_LDP)THEN
	  T1=3.28978_LDP*COL_CONST*ATM(ID)%AXzV_F(NL,NUP)*ATM(ID)%XzV_F(NL,DPTH_INDX)/dE*ATM(ID)%CROSEC_NTFAC
!
!$OMP PARALLEL DO PRIVATE(GBAR,IKT,X,XSQ)
	  DO J=1,NOUT
	    DO IKT=(J-1)*NIN+1,MIN(J*NIN,NKT)
	      IF(XKT(IKT) .GE. dE_eV)THEN
	        XSQ = XKT(IKT)/dE_eV-1.0_LDP
	        IF((ATM(ID)%ZXzV .NE. 1) .AND. (XSQ .LE. CONNECT_POINT_SQ) )THEN
	          GBAR = 0.2_LDP
	        ELSE IF(XSQ .LE. 0.64_LDP)THEN			!X .LE. 0.8D0
	          X=SQRT(XSQ)
	          GBAR = 0.074_LDP*X*(1.0_LDP+X)
	        ELSE IF(XSQ .LE. 36)THEN		  	!X .LE. 6
	          X=SQRT(XSQ)
	          GBAR = COEF0 + X*(COEF1 + COEF2*X)
	        ELSE
	          GBAR = +0.105_LDP+LOG(XSQ)/3.6276_LDP     	!Was LOG(X)/1.8138D0
	        END IF
	        IF(GBAR .GT. 0.0_LDP)THEN
	          Q(IKT)=T1*GBAR*dXKT_ON_XKT(IKT)
	        ENDIF
	      END IF
	    END DO
	  END DO
	ELSE IF(ATM(ID)%NT_OMEGA(NL,NUP) .NE. 0.0_LDP)THEN
	  T1=PI*A0*A0*13.6_LDP*ATM(ID)%CROSEC_NTFAC
	  T1=T1*ATM(ID)%NT_OMEGA(NL,NUP)/ATM(ID)%GXzV_F(NL)*ATM(ID)%XzV_F(NL,DPTH_INDX)
!$OMP PARALLEL DO
	  DO J=1,NOUT
	    DO IKT=(J-1)*NIN+1,MIN(J*NIN,NKT)
	      IF(XKT(IKT) .GE. dE_eV)THEN
	        Q(IKT)=T1*dXKT_ON_XKT(IKT)
	      END IF
	    END DO
	  END DO
	ELSE
!
	END IF
	CALL TUNE(2,'APPROX')
!
	RETURN
	END
