!
! subroutine to read in nonthermal cross sections scale factor
! for all ions.
!
	SUBROUTINE RD_NT_CROSEC_SCLFAC_V2(LU,LUER)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	IMPLICIT NONE
!
! Altered: 25-Sep-2011 : LU inserted in call. Moved to NON_THEM directory.
!                        F90 version, Changed to V2 as call changed.
!
	INTEGER LU
	INTEGER LUER
!
	INTEGER ID
	INTEGER IOS
	INTEGER ILEFT,IRITE
	CHARACTER(LEN=200) STRING
!
	OPEN(UNIT=LU,FILE='NT_CROSEC_SCLFAC',STATUS='OLD',ACTION='READ')
!
	DO WHILE(1 .EQ. 1)
	  STRING=' '
	  READ(LU,'(A)',IOSTAT=IOS)STRING
	  IF(IOS .NE. 0)EXIT
	  ILEFT=INDEX(STRING,'[')
	  IRITE=INDEX(STRING,']')
	  IF(ILEFT .NE. 0 .AND. IRITE .NE. 0)THEN
	    DO ID=1,NUM_IONS
	      IF(ILEFT+1 .LT. IRITE-1 .AND. STRING(ILEFT+1:IRITE-1) .EQ. TRIM(ION_ID(ID)))THEN
	        READ(STRING,*)ATM(ID)%CROSEC_NTFAC
	      END IF
	    END DO
	  END IF
	END DO
!
	CLOSE(LU)
!
	OPEN(UNIT=LU,FILE='NT_CROSEC_SCLFAC_CHK',STATUS='UNKNOWN',ACTION='WRITE')
	DO ID=1,NUM_IONS
	  IF(ATM(ID)%XzV_PRES)THEN
	    WRITE(LU,'(1PE12.5,5X,3A)')ATM(ID)%CROSEC_NTFAC,'[',TRIM(ION_ID(ID)),']'
	  END IF
	END DO
!
	CLOSE(LU)
!
	OPEN(UNIT=LU,FILE='NT_ION_CROSEC_SCLFAC',STATUS='OLD',ACTION='READ')
!
	DO WHILE(1 .EQ. 1)
	  STRING=' '
	  READ(LU,'(A)',IOSTAT=IOS)STRING
	  IF(IOS .NE. 0)EXIT
	  ILEFT=INDEX(STRING,'[')
	  IRITE=INDEX(STRING,']')
	  IF(ILEFT .NE. 0 .AND. IRITE .NE. 0)THEN
	    DO ID=1,NUM_IONS
	      IF(ILEFT+1 .LT. IRITE-1 .AND. STRING(ILEFT+1:IRITE-1) .EQ. TRIM(ION_ID(ID)))THEN
	        READ(STRING,*)ATM(ID)%ION_CROSEC_NTFAC
	      END IF
	    END DO
	  END IF
	END DO
!
	CLOSE(LU)
!
	OPEN(UNIT=LU,FILE='NT_ION_CROSEC_SCLFAC_CHK',STATUS='UNKNOWN',ACTION='WRITE')
	DO ID=1,NUM_IONS
	  IF(ATM(ID)%XzV_PRES)THEN
	    WRITE(LU,'(1PE12.5,5X,3A)')ATM(ID)%ION_CROSEC_NTFAC,'[',TRIM(ION_ID(ID)),']'
	  END IF
	END DO
!
	CLOSE(LU)
!
	END
