!
! Designed to ouptut SN data for the next model in a time
! dependent SN sequence.
!
	SUBROUTINE OUT_SN_POPS_V2(FILENAME,SN_AGE_DAYS,ND,LU)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	USE NUC_ISO_MOD
	IMPLICIT NONE
!
! Created 21-Oct-2007
!
	REAL(KIND=LDP) SN_AGE_DAYS
	INTEGER ND
	INTEGER LU
	CHARACTER(LEN=*)FILENAME
!
! Local variables
!
	REAL(KIND=LDP) TMP_VEC(ND)
	INTEGER I
	INTEGER ICOUNT
	CHARACTER*120 TMP_STR
!
	ICOUNT=0
	DO I=1,NUM_SPECIES
	  IF(SUM(POP_SPECIES(I,:)) .NE. 0.0_LDP)ICOUNT=ICOUNT+1
	END DO
!
	OPEN(UNIT=LU,FILE=FILENAME,STATUS='UNKNOWN',ACTION='WRITE')
	WRITE(LU,'(/,A,I5)')'Number of data points:        ',ND
	WRITE(LU,'(A,I5)')  'Number of mass fractions:     ',ICOUNT
	WRITE(LU,'(A,I5)')  'Number of isotopes:           ',NUM_ISOTOPES
	WRITE(LU,'(A,F13.7,/)')'Time(days) since explosion:   ',SN_AGE_DAYS
!
	CALL OUT_SN_VEC(R,ND,'Radius grid (10^10cm)',LU)
	CALL OUT_SN_VEC(V,ND,'Velocity (km/s)',LU)
	CALL OUT_SN_VEC(SIGMA,ND,'Sigma (dlnV/dlnr-1)',LU)
	CALL OUT_SN_VEC(T,ND,'Temperature (10^4 K)',LU)
	CALL OUT_SN_VEC(DENSITY,ND,'Density (gm/cm^3)',LU)
	CALL OUT_SN_VEC(POP_ATOM,ND,'Atom density (/cm^3)',LU)
	CALL OUT_SN_VEC(ED,ND,'Electron density (/cm^3)',LU)
	CALL OUT_SN_VEC(ROSS_MEAN,ND,'Rosseland mean opacty (10^{-10} cm^{-1})',LU)
	TMP_VEC=1.0E-10_LDP*ROSS_MEAN/DENSITY
	CALL OUT_SN_VEC(TMP_VEC,ND,'Kappa (cm^2/gm)',LU)
!
	DO I=1,NUM_SPECIES
	  TMP_STR=TRIM(SPECIES(I))//' mass fraction'
	  TMP_VEC=1.66E-24_LDP*POP_SPECIES(:,I)*AT_MASS(I)/DENSITY
	  IF(SUM(POP_SPECIES(:,I))  .NE. 0.0_LDP)THEN
	    CALL OUT_SN_VEC(TMP_VEC,ND,TMP_STR,LU)
	  ELSE
	    WRITE(LU,'(/,A)')TRIM(TMP_STR)
	    WRITE(LU,'(2X,I5,A)')ND,'*0.00000D0'
	  END IF
	END DO
!
	DO I=1,NUM_ISOTOPES
	  WRITE(TMP_STR(1:3),'(I3)')ISO(I)%BARYON_NUMBER
	  TMP_STR=TRIM(ISO(I)%SPECIES)//TMP_STR(1:3)//' mass fraction'
	  TMP_VEC=1.66E-24_LDP*ISO(I)%POP*ISO(I)%MASS/DENSITY
	  CALL OUT_SN_VEC(TMP_VEC,ND,TMP_STR,LU)
	END DO
!
	CLOSE(LU)
	RETURN
	END
!
!^L
!
	SUBROUTINE OUT_SN_VEC(X,ND,HEADER,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
	INTEGER ND,LU
	REAL(KIND=LDP) X(ND)
	CHARACTER(LEN=*) HEADER
	INTEGER I
!
	WRITE(LU,'(/,A)')TRIM(HEADER)
	WRITE(LU,'(1X,1P8E16.7)')(X(I),I=1,ND)
!
	RETURN
	END
