	SUBROUTINE READ_BCD_MAT(B,C,D,ROW_SF,COL_SF,IPIVOT,
	1            POPS,REPLACE_EQ,ZERO_STEQ,N,NION,DEPTH_INDX,TYPE)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
! Altered 29-Jul-2024:  Added ability to output files directly to a scratch directory.
! Altered 16-Dec-2013:  Changed depth index on scratch file from I3.3 to I4.4.
!                         This was done to allow for clumped models with ND 999.
!                         Filename incread to LEN=14 (2-Jan-2013)
!
	INTEGER N,NION,DEPTH_INDX
	REAL(KIND=LDP) B(N,N)
	REAL(KIND=LDP) C(N,N)
	REAL(KIND=LDP) D(N,N)
	REAL(KIND=LDP) ROW_SF(N)
	REAL(KIND=LDP) COL_SF(N)
	REAL(KIND=LDP) POPS(N)
	INTEGER IPIVOT(N)
	LOGICAL REPLACE_EQ(NION)
	LOGICAL ZERO_STEQ(N)
	CHARACTER*(*) TYPE
!
	INTEGER, SAVE :: LU=200
	INTEGER  LUER,ERROR_LU,IOS,I
	EXTERNAL ERROR_LU
	LOGICAL LU_USED
	CHARACTER(LEN=200) FILENAME
	CHARACTER(LEN=200), SAVE :: SCRATCH_DIR='GARBAGE'
!
! Get an unused UNIT number.
!
	LU=LU-1;  LU_USED=.TRUE.
	DO WHILE(LU_USED)
	  LU=LU+1
	  INQUIRE(UNIT=LU,OPENED=LU_USED)
	END DO
!
	IF(SCRATCH_DIR .EQ. 'GARBAGE')CALL GET_ENVIRONMENT_VARIABLE('SCRATCH_DIR',SCRATCH_DIR)
	FILENAME=TRIM(SCRATCH_DIR)//TRIM(TYPE)//'SCRATCH'
	I=LEN_TRIM(FILENAME)+1
	WRITE(FILENAME(I:I+3),'(I4.4)')DEPTH_INDX
        OPEN(UNIT=LU,FORM='UNFORMATTED',FILE=TRIM(FILENAME),IOSTAT=IOS,
	1             ACCESS='SEQUENTIAL',STATUS='OLD',ACTION='READ')
	  IF(IOS .NE. 0)THEN
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in READ_BCD_MAT'
	    WRITE(LUER,*)'Unable to open ',TRIM(FILENAME)
	    WRITE(LUER,*)'IOSTAT=',IOS
	    STOP
	  END IF
	  IF(TYPE .EQ. 'BC')THEN
	    READ(LU,IOSTAT=IOS)B,C,ROW_SF,COL_SF,POPS,IPIVOT,REPLACE_EQ,ZERO_STEQ
	  ELSE IF(TYPE .EQ. 'C')THEN
	    READ(LU,IOSTAT=IOS)C,ROW_SF,COL_SF,POPS,IPIVOT,REPLACE_EQ,ZERO_STEQ
	  ELSE IF(TYPE .EQ. 'D')THEN
	    READ(LU,IOSTAT=IOS)D
	  ELSE
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in READ_BCD_MAT'
	    WRITE(LUER,*)'Unrecognized TYPE: TYPE=',TYPE
	  END IF
	  IF(IOS .NE. 0)THEN
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in READ_BCD_MAT'
	    WRITE(LUER,*)'Unable to read ',TRIM(FILENAME)
	    WRITE(LUER,*)'IOSTAT=',IOS
	    STOP
	  END IF
	CLOSE(LU)
!
	RETURN
	END
!
!
	SUBROUTINE WRITE_BCD_MAT(B,C,D,ROW_SF,COL_SF,IPIVOT,
	1             POPS,REPLACE_EQ,ZERO_STEQ,N,NION,DEPTH_INDX,TYPE)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER N,NION,DEPTH_INDX
	REAL(KIND=LDP) B(N,N)
	REAL(KIND=LDP) C(N,N)
	REAL(KIND=LDP) D(N,N)
	REAL(KIND=LDP) ROW_SF(N)
	REAL(KIND=LDP) COL_SF(N)
	REAL(KIND=LDP) POPS(N)
	INTEGER IPIVOT(N)
	LOGICAL REPLACE_EQ(NION)
	LOGICAL ZERO_STEQ(N)
	CHARACTER*(*) TYPE
!
	INTEGER, SAVE :: LU=200
	INTEGER  LUER,ERROR_LU,IOS,I
	EXTERNAL ERROR_LU
	LOGICAL LU_USED
	CHARACTER(LEN=200) FILENAME
	CHARACTER(LEN=200), SAVE :: SCRATCH_DIR='GARBAGE'
!
! Get an unused UNIT number.
!
	LU=LU-1;  LU_USED=.TRUE.
	DO WHILE(LU_USED)
	  LU=LU+1
	  INQUIRE(UNIT=LU,OPENED=LU_USED)
	END DO
!
	IF(SCRATCH_DIR .EQ. 'GARBAGE')CALL GET_ENVIRONMENT_VARIABLE('SCRATCH_DIR',SCRATCH_DIR)
	FILENAME=TRIM(SCRATCH_DIR)//TRIM(TYPE)//'SCRATCH'
	I=LEN_TRIM(FILENAME)+1
	WRITE(FILENAME(I:I+3),'(I4.4)')DEPTH_INDX
        OPEN(UNIT=LU,FORM='UNFORMATTED',FILE=TRIM(FILENAME),IOSTAT=IOS,
	1             ACCESS='SEQUENTIAL',STATUS='UNKNOWN',ACTION='WRITE')
	  IF(IOS .NE. 0)THEN
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in WRITE_BCD_MAT'
	    WRITE(LUER,*)'Unable to open ',TRIM(FILENAME)
	    WRITE(LUER,*)'IOSTAT=',IOS
	    STOP
	  END IF
	  IF(TYPE .EQ. 'BC')THEN
	    WRITE(LU,IOSTAT=IOS)B,C,ROW_SF,COL_SF,POPS,IPIVOT,REPLACE_EQ,ZERO_STEQ
	  ELSE IF(TYPE .EQ. 'C')THEN
	    WRITE(LU,IOSTAT=IOS)C,ROW_SF,COL_SF,POPS,IPIVOT,REPLACE_EQ,ZERO_STEQ
	  ELSE IF(TYPE .EQ. 'D')THEN
	    WRITE(LU,IOSTAT=IOS)D
	  ELSE
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in READ_BCD_MAT'
	    WRITE(LUER,*)'Unrecognized TYPE: TYPE=',TYPE
	  END IF
	  IF(IOS .NE. 0)THEN
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error in WRITE_BCD_MAT'
	    WRITE(LUER,*)'Unable to write ',TRIM(FILENAME)
	    WRITE(LUER,*)'IOSTAT=',IOS
	    STOP
	  END IF
	CLOSE(LU)
!
	RETURN
	END
