	SUBROUTINE SMOOTH_POPS_AS_WE_ITERATE(POPS,STEQ_VALS,ND,NT)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	USE CONTROL_VARIABLE_MOD
	IMPLICIT NONE
!
! Altered 19-May-2019 _ Still under devlopment.
!
	INTEGER ND
	INTEGER NT
	REAL(KIND=LDP) POPS(NT,ND)
	REAL(KIND=LDP) STEQ_VALS(NT,ND)
	INTEGER DONE(NT)
!
	INTEGER, SAVE :: LUOUT=0
	INTEGER I,J,K,L
	INTEGER ISPEC
	INTEGER ID
	REAL(KIND=LDP) T1,T2,T3
	REAL(KIND=LDP) RAT23,RAT12,RAT01
!
	WRITE(6,*)'Entering SMOOTH_POPS_AS_WE_ITERATE'; 	FLUSH(UNIT=6)
!
	IF(LUOUT .EQ. 0)THEN
	  CALL GET_LU(LUOUT,'In SMOOTH_POP_AS_WE_ITERATE')
	  OPEN(UNIT=LUOUT,FILE='SMOOTH_POP_CORRECTIONS',STATUS='UNKNOWN',ACTION='WRITE')
	END IF
	WRITE(LUOUT,*)'Maximum correction is [sign corrected]',-MINVAL(STEQ_VALS)
	WRITE(LUOUT,*)'Minimum correction is [sign corrected]',-MAXVAL(STEQ_VALS)
!
	DONE=0
	WRITE(LUOUT,'(5X,6A,3(7X,A),5(3X,A))')
	1          '   L',' ISP','  ID','   I','    J',' DJ','RAT23','RAT12','RAT01',
	1          '  OPOP(L)','  New Val','OPOP(L+1)','OPOP(L+2)','OPOP(L+3)'
	DO L=ND-5,1,-1
	  DO ISPEC=1,NUM_SPECIES
	    DO ID=SPECIES_BEG_ID(ISPEC),SPECIES_END_ID(ISPEC)-1
	      K=0; IF(ID .EQ. SPECIES_END_ID(ISPEC)-1)K=1
	      DO I=1,ATM(ID)%NXzV+K
	        J=ATM(ID)%EQXzV+I-1
	        IF(DONE(J) .GE. 2)THEN
	        ELSE IF(STEQ_VALS(J,L) .GE. 0.998_LDP .OR. STEQ_VALS(J,L)  .LT. -1.0E+05_LDP)THEN
	          RAT23=(POPS(J,L+2)/POP_SPECIES(L+2,ISPEC)) / (POPS(J,L+3)/POP_SPECIES(L+3,ISPEC))
	          RAT12=(POPS(J,L+1)/POP_SPECIES(L+1,ISPEC)) / (POPS(J,L+2)/POP_SPECIES(L+2,ISPEC))
	          RAT01=(POPS(J,L)/POP_SPECIES(L,ISPEC)) / (POPS(J,L+1)/POP_SPECIES(L+1,ISPEC))
	          IF( ABS(LOG10(RAT23/RAT12)) .LT. 1.0_LDP)THEN
	            IF(ABS(LOG10(RAT01/RAT12)) .GT. 5.0_LDP .AND. ABS(LOG10(RAT23)) .LT.  3.0_LDP)THEN
	              T3=RAT12*(POPS(J,L+1)/POP_SPECIES(L+1,ISPEC))*POP_SPECIES(L,ISPEC)
	              WRITE(LUOUT,'(A3,2X,4I4,I5,2X,L1,8ES12.3)')' CM',L,ISPEC,ID,I,J,DONE(J),
	1                   RAT23,RAT12,RAT01,POPS(J,L),T3,POPS(J,L+1:L+3)
	              POPS(J,L)=T3
	              DONE(J)=DONE(J)+1
	            ELSE
	              T3=RAT12*(POPS(J,L+1)/POP_SPECIES(L+1,ISPEC))*POP_SPECIES(L,ISPEC)
	              WRITE(LUOUT,'(A3,2X,4I4,I5,2X,I1,8ES12.3)')'NCM',L,ISPEC,ID,I,J,DONE(J),
	1                   RAT23,RAT12,RAT01,POPS(J,L),T3,POPS(J,L+1:L+3)
	            END IF
	          END IF
	        END IF
	      END DO
	    END DO
	  END DO
	END DO
	FLUSH(LUOUT)
	WRITE(6,*)'Exiting SMOOTH_POPS_AS_WE_ITERATE'; 	FLUSH(UNIT=6)
	WRITE(6,*)'See SMOOTH_POP_CORRECTIONS for a listing of changes'
!
	RETURN
	END
