	SUBROUTINE STORE_OLD_GRID(MEAN_ATOMIC_MASS,ND)
	USE SET_KIND_MODULE
	USE MOD_CMFGEN
	USE OLD_GRID_MODULE
	IMPLICIT NONE
!
	INTEGER ND
	INTEGER IOS
	INTEGER ISPEC
	REAL(KIND=LDP) MEAN_ATOMIC_MASS
!
	MEAN_ATOMIC_MASS=0.0_LDP
	DO ISPEC=1,NUM_SPECIES
	    MEAN_ATOMIC_MASS=MEAN_ATOMIC_MASS+POP_SPECIES(ND,ISPEC)*AT_MASS(ISPEC)
	END DO
	MEAN_ATOMIC_MASS=MEAN_ATOMIC_MASS/POP_ATOM(ND)
!
	IF(.NOT. ALLOCATED(OLD_R))THEN
	  ALLOCATE (OLD_R(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_V(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_SIGMA(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_T(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_ED(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_ROSS_MEAN(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_FLUX_MEAN(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_ESEC(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_KAP_ROSS(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_KAP_FLUX(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_KAP_ESEC(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_POP_ATOM(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_MASS_DENSITY(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_POPION(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_CLUMP_FAC(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_TAU(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (OLD_SF(ND),STAT=IOS)
	  IF(IOS .NE. 0)THEN
	    WRITE(6,*)'Error in STORE_OLD_GRID -- error allocating atmospheric vectors'
	    WRITE(6,*)'STATUS=',IOS
	    STOP
	  END IF
	END IF
!
	OLD_ND=ND
!
! Store vectors describing the old atmospheric structure.
!
	OLD_R=R
	OLD_T=T
	OLD_ED=ED
	OLD_SIGMA=SIGMA
	OLD_V=V
!
	OLD_POP_ATOM=POP_ATOM
	OLD_POPION=POPION
	OLD_CLUMP_FAC=CLUMP_FAC
	OLD_MASS_DENSITY=DENSITY
!
	OLD_ROSS_MEAN=ROSS_MEAN
	OLD_FLUX_MEAN=FLUX_MEAN
	OLD_ESEC=6.65E-15_LDP*OLD_ED
!
! Compute mass absorption coefficients in cgs units.
!
	OLD_KAP_ROSS=1.0E-10_LDP*OLD_ROSS_MEAN/OLD_MASS_DENSITY
	OLD_KAP_FLUX=1.0E-10_LDP*OLD_FLUX_MEAN/OLD_MASS_DENSITY
	OLD_KAP_ESEC=1.0E-10_LDP*OLD_ESEC/OLD_MASS_DENSITY
!
	RETURN
	END
