        SUBROUTINE TST_RD_EQ_FILE(POPS,ND,NT,LU)
	USE SET_KIND_MODULE
        USE MOD_CMFGEN
	IMPLICIT NONE
!
	INTEGER ND
	INTEGER NT
	INTEGER LU
	REAL(KIND=LDP) POPS(NT,ND)
!
	REAL(KIND=LDP), ALLOCATABLE :: OLD_R(:)
	REAL(KIND=LDP), ALLOCATABLE :: OLD_V(:)
	REAL(KIND=LDP), ALLOCATABLE :: OLD_SIGMA(:)
	REAL(KIND=LDP), ALLOCATABLE :: OLD_POP_ATOM(:)
	REAL(KIND=LDP), ALLOCATABLE :: OLD_DENSITY(:)
	REAL(KIND=LDP), ALLOCATABLE :: OLD_POPS(:,:)
!
	LOGICAL, ALLOCATABLE :: OLD_ION_STAGE_PRES(:)
!
	REAL(KIND=LDP) T1
	REAL(KIND=LDP) OLD_SN_AGE
	INTEGER OLD_ND
	INTEGER I,L
!
	CALL GET_ND_SEQ_MODEL_FILE(OLD_ND,LU)
!
	ALLOCATE (OLD_R(OLD_ND))
	ALLOCATE (OLD_V(OLD_ND))
	ALLOCATE (OLD_SIGMA(OLD_ND))
	ALLOCATE (OLD_POP_ATOM(OLD_ND))
	ALLOCATE (OLD_DENSITY(OLD_ND))
	ALLOCATE (OLD_POPS(NT,OLD_ND))
	ALLOCATE (OLD_ION_STAGE_PRES(NUM_IONS))
	CALL READ_SEQ_TIME_FILE_V1(OLD_R,OLD_V,OLD_SIGMA,OLD_POP_ATOM,
	1            OLD_DENSITY,OLD_POPS,
	1            OLD_ION_STAGE_PRES,OLD_SN_AGE,OLD_ND,NT,LU)
!
	WRITE(6,*)'Number of depth points is',ND
	WRITE(6,*)'Old age of SN is',OLD_SN_AGE
!
	DO I=1,ND
	  WRITE(40,'(I3,5ES10.3)')I,R(I)/OLD_R(I)-1.0_LDP,
	1            V(I)/OLD_V(I)-1.0_LDP,
	1            OLD_SIGMA(I),
	1            POP_ATOM(I)/OLD_POP_ATOM(I)-1.0_LDP,
	1            DENSITY(I)/OLD_DENSITY(I)-1.0_LDP
	END DO
!
	T1=0.0_LDP
	DO L=1,ND
	  DO I=1,NT
	    IF(OLD_POPS(I,L) .EQ. 0.0_LDP)THEN
	      WRITE(6,*)'Stopping for zero pops in TST_RD_SEQ'
	      WRITE(6,*)'Depth=',L
	      WRITE(6,*)'Level=',I
	      STOP
	    END IF
	    T1=MAX( T1,ABS((POPS(I,L)-OLD_POPS(I,L))/POPS(I,L)) )
	  END DO
	END DO
	WRITE(6,*)'Maximum difference in the populations is',T1
!
	STOP
	END
