!
! Altered: 27-Jan-2015: Added INIT_GET_J_FOR_TWO_PHOT routine
!
	MODULE MOD_J_TWO_PHOT
	USE SET_KIND_MODULE
	  REAL(KIND=LDP), ALLOCATABLE :: RJ_START(:)
	  REAL(KIND=LDP), ALLOCATABLE :: RJ_END(:)
	  REAL(KIND=LDP), ALLOCATABLE :: RJ_LOW(:)
	  REAL(KIND=LDP), ALLOCATABLE :: RJ_HIGH(:)
	  REAL(KIND=LDP), ALLOCATABLE :: RJ_MID(:)
	  REAL(KIND=LDP) FL_START
	  REAL(KIND=LDP) FL_END
!
	  INTEGER EDD_CONT_REC
	  INTEGER LU_EDD
	  INTEGER START_REC
!
	  INTEGER   ND_RD
	  INTEGER   NCF_RD
	  INTEGER, ALLOCATABLE :: POS_IN_R_GRID(:)
!
	  LOGICAL FIRST
	  DATA FIRST/.TRUE./
	  SAVE
	END MODULE MOD_J_TWO_PHOT
!
	SUBROUTINE SET_POP_FOR_TWOJ(INDEX_GRID,EDD_CONT_REC_PASSED,LU_EDD_PASSED,ND)
	USE SET_KIND_MODULE
	USE MOD_J_TWO_PHOT
	IMPLICIT NONE
	INTEGER ND
	INTEGER INDEX_GRID(ND)
	INTEGER EDD_CONT_REC_PASSED
	INTEGER LU_EDD_PASSED
!
	ALLOCATE (POS_IN_R_GRID(ND))
	POS_IN_R_GRID=INDEX_GRID
	EDD_CONT_REC=EDD_CONT_REC_PASSED
	LU_EDD=LU_EDD_PASSED
!
	RETURN
	END
!
! If we use the FIXED_J option, we access the old EDDFACTOR file. However,
! after we set USED_FIXD_J to TURE. We recompute J. As the frequency grid is
! distinct, we need to redefine the EDDFACTOR limits.
!
	SUBROUTINE INIT_GET_J_FOR_TWO_PHOT
	USE SET_KIND_MODULE
	USE MOD_J_TWO_PHOT
	FIRST=.TRUE.
	RETURN
	END
!
	SUBROUTINE GET_J_FOR_TWO_PHOT(RJ,FREQ,LST_REC,ND)
	USE SET_KIND_MODULE
	USE MOD_J_TWO_PHOT
	IMPLICIT NONE
!
! Created 08-July-2015 : Based on GET_INDX_DP
!
	INTEGER ND
	INTEGER LST_REC
	REAL(KIND=LDP) RJ(ND)
	REAL(KIND=LDP) FREQ
!
	INTEGER J,K
	INTEGER ILOW,IHIGH
	INTEGER IREC
!
	REAL(KIND=LDP) T1
	REAL(KIND=LDP) FL_LOW,FL_HIGH,FL_MID
!
	IF(FIRST)THEN
	  READ(LU_EDD,REC=EDD_CONT_REC)START_REC,NCF_RD,ND_RD
	  IF(.NOT. ALLOCATED(RJ_START))THEN
	    ALLOCATE (RJ_START(ND_RD))
	    ALLOCATE (RJ_END(ND_RD))
	    ALLOCATE (RJ_LOW(ND_RD))
	    ALLOCATE (RJ_HIGH(ND_RD))
	    ALLOCATE (RJ_MID(ND_RD))
	  END IF
	  READ(LU_EDD,REC=START_REC)RJ_START,FL_START
	  READ(LU_EDD,REC=START_REC+NCF_RD-1)RJ_END,FL_END
	  FIRST=.FALSE.
	  ILOW=1; IHIGH=NCF_RD
!	  WRITE(171,*)FL_START,FL_END
!	  WRITE(171,*)NCF_RD,ND_RD
	END IF
!
! This routine assumes NU monotonically decreases with frequency.
!
	IF(FREQ .GE. FL_START)THEN
	  IF(ND .EQ. ND_RD)THEN
	    RJ=RJ_START
	  ELSE
	    CALL UNGRID(RJ,ND,RJ_START,ND_RD,POS_IN_R_GRID)
	  END IF
	  RETURN
	END IF
	IF(FREQ .LE. FL_END)THEN
	  T1=(FREQ/FL_END)**2
	  IF(ND .EQ. ND_RD)THEN
	    RJ=RJ_END*T1
	  ELSE
	    CALL UNGRID(RJ,ND,RJ_END,ND_RD,POS_IN_R_GRID)
	    RJ=RJ*T1
	  END IF
	  RETURN
	END IF
!
! This handles the case where we do not have to do a search.
!
	IF(LST_REC .GT. 0 .AND. LST_REC .LT. NCF_RD)THEN
	  IREC=START_REC+LST_REC-1
	  READ(LU_EDD,REC=IREC,ERR=100)RJ_LOW,FL_LOW
	  READ(LU_EDD,REC=IREC+1,ERR=100)RJ_HIGH,FL_HIGH
	  IF(FREQ .LE. FL_LOW .AND. FREQ .GE. FL_HIGH)THEN
	    T1=(FL_LOW-FREQ)/(FL_LOW-FL_HIGH)
	    IF(ND .EQ. ND_RD)THEN
	      RJ=T1*RJ_HIGH+(1.0_LDP-T1)*RJ_LOW
	    ELSE
	      RJ_MID=T1*RJ_HIGH+(1.0_LDP-T1)*RJ_LOW
	      CALL UNGRID(RJ,ND,RJ_MID,ND_RD,POS_IN_R_GRID)
	    END IF
	    RETURN
	  END IF
	END IF
100	CONTINUE
!
	ILOW=LST_REC; IHIGH=LST_REC+1
	IF(LST_REC .LT. 1 .OR. LST_REC .GT. NCF_RD-1)THEN
	  ILOW=1
	  IHIGH=NCF_RD
	  RJ_LOW=RJ_START
	  RJ_HIGH=RJ_END
	ELSE
!
! Start search from previous location, expanding search window until
! current frequency is contained within that window.
!
! NB: Here LOW and HIGH refer to the size of the INDEX - not FREQ which
! gets smaller as the index decreases.
!
	  K=1
	  READ(LU_EDD,REC=START_REC+ILOW-1)RJ_LOW,FL_LOW
	  READ(LU_EDD,REC=START_REC+IHIGH-1)RJ_HIGH,FL_HIGH
	  DO WHILE(FREQ .LT. FL_HIGH)
	    ILOW=IHIGH;  FL_LOW=FL_HIGH;   RJ_LOW=RJ_HIGH
	    IHIGH=MIN(IHIGH+K,NCF_RD)
	    READ(LU_EDD,REC=START_REC+IHIGH-1)RJ_HIGH,FL_HIGH
	    K=K*2
	  END DO
	  DO WHILE(FREQ .GT. FL_LOW)
	    IHIGH=ILOW; RJ_HIGH=RJ_LOW; FL_HIGH=FL_LOW
	    ILOW=MAX(ILOW-K,1)
	    READ(LU_EDD,REC=START_REC+ILOW-1)RJ_LOW,FL_LOW
	    K=K*2
	  END DO
	END IF
!
	DO WHILE( (IHIGH-ILOW) .GT. 1)
	  J=(ILOW+IHIGH)/2
	  READ(LU_EDD,REC=START_REC+J-1)RJ_MID,FL_MID
	  IF(FREQ .LT. FL_MID)THEN
	    ILOW=J
	    RJ_LOW=RJ_MID
	    FL_LOW=FL_MID
	  ELSE
	    IHIGH=J
	    RJ_HIGH=RJ_MID
	    FL_HIGH=FL_MID
	  END IF
	END DO
	LST_REC=ILOW
!
!	WRITE(171,'(2I7,3ES18.8)')IHIGH,ILOW,FL_HIGH,FREQ,FL_LOW
!	FLUSH(UNIT=171)
	T1=(FL_LOW-FREQ)/(FL_LOW-FL_HIGH)
	IF(ND .EQ. ND_RD)THEN
	  RJ=T1*RJ_HIGH+(1.0_LDP-T1)*RJ_LOW
	ELSE
	  RJ_MID=T1*RJ_HIGH+(1.0_LDP-T1)*RJ_LOW
	  CALL UNGRID(RJ,ND,RJ_MID,ND_RD,POS_IN_R_GRID)
	END IF
!
	RETURN
	END
