!
! Subroutine to compute the derivative of a vector.
!
	  SUBROUTINE DO_PG_DERIV(IN1,OUT,METHOD)
	  USE SET_KIND_MODULE
	  USE MOD_CURVE_DATA
	  IMPLICIT NONE
!
! Created 19-Jan-2020
!
	INTEGER IN1
	INTEGER OUT
	LOGICAL LIN_INT
	CHARACTER(LEN=*) METHOD
!
! Local variables
!
	REAL(KIND=LDP), ALLOCATABLE :: XV(:)
	REAL(KIND=LDP), ALLOCATABLE :: YV(:)
	REAL(KIND=LDP), ALLOCATABLE :: ZV(:)
!
	INTEGER NX
!
	INTEGER, PARAMETER :: IONE=1
	INTEGER, PARAMETER :: T_OUT=6
!
! Check validity of maps:
!
	IF(NPTS(IN1) .EQ. 0)THEN
	  WRITE(T_OUT,*)'Invalid Plot ID in DO_VEC_OP'
	  WRITE(T_OUT,*)'Plot ID=',IN1,'  NPTS=',NPTS(IN1)
	  RETURN
	END IF
!
	NX=NPTS(IN1)
	ALLOCATE(XV(NX))
	ALLOCATE(YV(NX))
	ALLOCATE(ZV(NX))
!
	XV=CD(IN1)%XVEC
	YV=CD(IN1)%DATA
	CALL DERIVCHI(ZV,YV,XV,NX,METHOD)
!
	IF(ALLOCATED(CD(OUT)%XVEC))THEN
	  DEALLOCATE (CD(OUT)%XVEC)
	  DEALLOCATE (CD(OUT)%DATA)
	END IF
	ALLOCATE (CD(OUT)%XVEC(NX),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (CD(OUT)%DATA(NX),STAT=IOS)
!
! Store the derivative.
!
	IF(IOS .NE. 0)THEN
	  WRITE(T_OUT,*)'Error in DO_VEC_OP --- unable to allocate',
	1                ' plot storage vectors'
	  WRITE(T_OUT,*)'IOS=',IOS
	ELSE
	  CD(OUT)%XVEC(1:NX)=XV
	  CD(OUT)%DATA(1:NX)=ZV
	  NPTS(OUT)=NX
	  ERR(OUT)=.FALSE.
	  IF(OUT .GT. NPLTS)NPLTS=OUT
	END IF
!
! Clean up.
!
	IF(ALLOCATED(XV))DEALLOCATE(XV)
	IF(ALLOCATED(YV))DEALLOCATE(YV)
	IF(ALLOCATED(ZV))DEALLOCATE(ZV)
!
	RETURN
	END
