	SUBROUTINE FIND_LINES(LINE_CENTER, LINE_HEIGHT, LINE_SIGMA, NO_LINES, NL_MAX,
	1                     NORM,WAVE,N,LAM_ST,LAM_END,TOLERANCE)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER NL_MAX
	INTEGER NO_LINES
	REAL(KIND=LDP) LINE_CENTER(NL_MAX)
	REAL(KIND=LDP) LINE_HEIGHT(NL_MAX)
	REAL(KIND=LDP) LINE_SIGMA(NL_MAX)
!
	INTEGER N
	REAL*4 NORM(N)
	REAL*4 WAVE(N)
!
	REAL*4 LAM_ST
	REAL*4 LAM_END
	REAL*4 TOLERANCE
!
	REAL(KIND=LDP), ALLOCATABLE :: XV(:)
	REAL(KIND=LDP), ALLOCATABLE :: YV(:)
	REAL(KIND=LDP), ALLOCATABLE :: CONT(:)
	REAL(KIND=LDP), ALLOCATABLE :: DERIV(:)
	REAL(KIND=LDP), ALLOCATABLE :: COEF(:,:)
!
	REAL(KIND=LDP) SUM,LAM
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) MEAN,SLOPE
	INTEGER NSM
	INTEGER I,J,K,ICOUNT
	INTEGER IST,IEND
	INTEGER GET_INDX_SP
	EXTERNAL GET_INDX_SP
!
	WRITE(6,*)'N=',N
	WRITE(6,*)'WAVE(1)=',WAVE(1),'WAVE(N)=',WAVE(N)
	WRITE(6,*)'LAM_ST=',LAM_ST,'LAM_END=',LAM_END
!
	IST=GET_INDX_SP(LAM_ST,WAVE,N)
	IEND=GET_INDX_SP(LAM_END,WAVE,N)
	WRITE(6,*)'IST=',IST,WAVE(IST)
	WRITE(6,*)'IEND=',IEND,WAVE(IEND)
!
	NSM=IEND-IST+1
	IF(ALLOCATED(COEF))DEALLOCATE(XV,YV,CONT,DERIV,COEF)
	ALLOCATE (XV(NSM),YV(NSM),CONT(NSM),DERIV(NSM),COEF(NSM,4))
	DO I=IST,IEND
	  XV(I-IST+1)=WAVE(I)
	  YV(I-IST+1)=NORM(I)
	END DO
!
	T1=0.0D0; T2=0.0D0
	DO I=1,5
	  T1=T1+YV(I)
	  T2=T2+YV(NSM-I+1)
	END DO
	T1=T1/5.0D0; T2=T2/5.0D0
	MEAN=0.5D0*(T1+T2)
	SLOPE=(T2-T1)/(XV(NSM)-XV(1))
	DO I=1,NSM
	  CONT(I)=T1+(XV(I)-XV(1))*SLOPE
	END DO
!
! Smooth noise level so that too many Gaussians are not found.
! We smooth if we find more than 10 Gaussians, or if the pixel to pixel variation
! is to high.
!
	J=100; K=0
	DO WHILE(J .GT. 10 .AND. K .LT. 10)
	  J=0; ICOUNT=0
	  DO I=2,NSM-1
	    IF( (YV(I)-YV(I-1))*(YV(I+1)-YV(I)) .LT. 0 .AND. ABS(YV(I)-CONT(I)) .GT. TOLERANCE)J=J+1
	    IF( (YV(I)-YV(I-1))*(YV(I+1)-YV(I)) .LT. 0 )ICOUNT=ICOUNT+1
          END DO
	  IF(J .GT. 10 .OR. ICOUNT .GT. NSM/4)THEN
	    DERIV(1)=0.75*YV(1)+0.25*YV(2)
	    DO I=2,NSM-1
	      DERIV(I)=0.25*YV(I-1)+0.5D0*YV(I)+0.25D0*YV(I+1)
	    END DO
	    DERIV(NSM)=0.75*YV(NSM)+0.25*YV(NSM-1)
	    YV=DERIV
	  END IF
	  K=K+1
	  WRITE(6,*)'Smoothing data: J=,J'
	END DO
!
	CALL MON_INT_FUNS_V2(COEF,YV,XV,NSM)
	DO I=1,NSM
	  DERIV(I)=COEF(I,3)
	END DO
!
	WRITE(6,*)XV(1),XV(NSM)
	WRITE(6,*)YV(1),YV(NSM)
!
	NO_LINES=0
	DO I=1,NSM
	  IF(DERIV(I) .EQ. 0 .AND. ABS(YV(I)-CONT(I)) .GT. TOLERANCE)THEN
	    IF(YV(I) .LT. CONT(I) .AND. YV(I+1) .LT. YV(I))GOTO 100
	    NO_LINES=NO_LINES+1
	    LINE_HEIGHT(NO_LINES)=YV(I)-CONT(I)
	    LINE_CENTER(NO_LINES)=XV(I)
	    DO J=I+1,NSM
	      IF( ABS(YV(J)-CONT(I)) .LT. 0.5D0*ABS(YV(I)-CONT(I)))THEN
	        T1=ABS(XV(J)-XV(I))
	        EXIT
	      END IF
	    END DO
	    DO J=I,1,-1
	      IF( ABS(YV(J)-CONT(I)) .LT. 0.5D0*ABS(YV(I)-CONT(I)))THEN
	        T2=ABS(XV(J)-XV(I))
	        EXIT
	      END IF
	    END DO
	    LINE_SIGMA(NO_LINES)=0.88*MIN(T1,T2)
	  END IF
100	  CONTINUE
	END DO
!
	DO I=1,NO_LINES
	   WRITE(6,'(F12.6,2ES16.4)')LINE_CENTER(I),LINE_HEIGHT(I),LINE_SIGMA(I)
	END DO
	WRITE(6,*)'    Number of lines found is',NO_LINES
	WRITE(6,*)'     Mean continuum level is',MEAN
	WRITE(6,*)'Variation across fit band is',SLOPE*(XV(NSM)-XV(1))
!
	RETURN
	END
