	MODULE GAUS_FIT_DATA
	USE SET_KIND_MODULE
!
	INTEGER NUM_GAUS			!Number of Gaussians
	INTEGER NG_PAR				!Total number of parameters in fit
	INTEGER NG_PAR_MAX		 	!Maximum total number of parameters in fit
	INTEGER NG_DATA				!Number of data points
!
	REAL(KIND=LDP), ALLOCATABLE :: X_GAUS(:)	!Absica data as stored in module
	REAL(KIND=LDP), ALLOCATABLE :: Y_GAUS(:)	!Data to be fitted
!
	REAL(KIND=LDP), ALLOCATABLE :: SIM(:,:)		!Simplex (NG_PAR+1 parameter set estimates)
	REAL(KIND=LDP), ALLOCATABLE :: PAR(:)		!Single parameter set
	REAL(KIND=LDP), ALLOCATABLE :: SUM_SQ(:)
	REAL(KIND=LDP), ALLOCATABLE :: SCALE(:)
	REAL(KIND=LDP), ALLOCATABLE :: EW_TABLE(:,:)
	REAL(KIND=LDP), ALLOCATABLE :: LAM_TABLE(:,:)
	REAL(KIND=LDP), ALLOCATABLE :: EW(:)
	REAL(KIND=LDP), ALLOCATABLE :: EW_CONT(:)
	REAL(KIND=LDP), ALLOCATABLE :: EW_ERROR(:)
	REAL(KIND=LDP), ALLOCATABLE :: ALT_ERROR(:)
	REAL(KIND=LDP), ALLOCATABLE :: MIN_ERROR(:)
	INTEGER, ALLOCATABLE :: INDX_VEC(:)
!
	REAL*4, ALLOCATABLE :: XFIT(:)		!Same as X_GAUS but for PGPLOT routines
	REAL*4, ALLOCATABLE :: YFIT(:)		!Function fit (evaluated by GAUS_FIT_FUNC)
	REAL*4, ALLOCATABLE :: FIT_DIF(:)	!Function fit (evaluated by GAUS_FIT_FUNC)
!
	END MODULE GAUS_FIT_DATA
!
! This subroutined defines the approriate arrrays and stores the data for the
! Gaussin fitting routine. Note the XVEC and YVEC are assumed to be single
! precision as routines is for use with GRAMON_PGPLOT.
!
	SUBROUTINE SET_GAUS_DATA(XVEC,YVEC,XST,XEND,NX,YST,YEND)
	USE SET_KIND_MODULE
	USE GAUS_FIT_DATA
	IMPLICIT NONE
!
	INTEGER NX
	REAL*4 XVEC(NX)
	REAL*4 YVEC(NX)
	REAL(KIND=LDP) XST,XEND
	REAL(KIND=LDP) YST,YEND
!
	INTEGER I
	INTEGER IXST,IXEND
!
	IXST=0
	DO I=1,NX-1
	  IF( (XST-XVEC(I))*(XVEC(I+1)-XST) .GE. 0)THEN
	    IF(ABS(XST-XVEC(I)) .GT. ABS(XVEC(I+1)-XST) )THEN
	      IXST=I
	      EXIT
	    ELSE
	      IXST=I+1
	      EXIT
	    END IF
	  END IF
	END DO
	IF(IXST .EQ. 0)THEN
	  WRITE(6,*)'Error in SET_GAUS_DATA: XST out of range'
	  WRITE(6,'(X,3(A,E15.8,3X))')'XST=',XST,'XVEC(1)=',XVEC(1),'XVEC(NX)=',XVEC(NX)
	  RETURN
	END IF
!
	IXEND=0
	DO I=1,NX-1
	  IF( (XEND-XVEC(I))*(XVEC(I+1)-XEND) .GE. 0)THEN
	    IF(ABS(XEND-XVEC(I)) .GT. ABS(XVEC(I+1)-XEND) )THEN
	      IXEND=I
	      EXIT
	    ELSE
	      IXEND=I+1
	      EXIT
	    END IF
	  END IF
	END DO
	IF(IXEND .EQ. 0)THEN
	  WRITE(6,*)'Error in SET_GAUS_DATA: XEND out of range'
	  WRITE(6,'(X,3(A,E15.8,3X))')'XEND=',XEND,'XVEC(1)=',XVEC(1),'XVEC(NX)=',XVEC(NX)
	  RETURN
	END IF
!
	IF(IXST .GT. IXEND)THEN
	  I=IXEND
	  IXEND=IXST
	  IXST=I
	END IF
	YST=YVEC(IXST)
	YEND=YVEC(IXEND)
!
	NG_DATA=IXEND-IXST+1
	IF(ALLOCATED(X_GAUS))DEALLOCATE(X_GAUS)
	IF(ALLOCATED(Y_GAUS))DEALLOCATE(Y_GAUS)
	IF(ALLOCATED(XFIT))DEALLOCATE(XFIT)
	IF(ALLOCATED(YFIT))DEALLOCATE(YFIT)
	IF(ALLOCATED(FIT_DIF))DEALLOCATE(FIT_DIF)
	ALLOCATE (X_GAUS(NG_DATA),Y_GAUS(NG_DATA))
	ALLOCATE (XFIT(NG_DATA),YFIT(NG_DATA),FIT_DIF(NG_DATA))
	DO I=IXST,IXEND
	  X_GAUS(I-IXST+1)=XVEC(I)
	  Y_GAUS(I-IXST+1)=YVEC(I)
	END DO
!
! Set X-values for later plotting
!
	XFIT(1:NG_DATA)=X_GAUS(1:NG_DATA)
!
	RETURN
	END
