!
! The LENGTH_OF_THE_HC_PLOT should be in cm.
!
	SUBROUTINE MODIFY_PGI_PS(CUR_HARD_FILE,LENGTH_OF_HC_PLOT,LP_ASR)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	REAL*4 LENGTH_OF_HC_PLOT
	REAL*4 LP_ASR
	CHARACTER(LEN=*) CUR_HARD_FILE
!
	INTEGER IOS
	REAL*4 T1,T2
	CHARACTER(LEN=10) TMP1,TMP2
	CHARACTER(LEN=500) STRING
!
	OPEN(UNIT=10,FILE=TRIM(CUR_HARD_FILE),STATUS='OLD',IOSTAT=IOS)
	IF(IOS .NE. 0)THEN
	  WRITE(6,*)'Error unable to open last postcript file'
	  WRITE(6,*)'File is: ',TRIM(CUR_HARD_FILE)
	  RETURN
	END IF
	OPEN(UNIT=11,STATUS='SCRATCH')
!
	READ(10,'(A)',END=100)STRING	
	IF(INDEX(STRING,'%!PS') .EQ. 0)THEN
	  WRITE(6,*)'Error -- invalid PS file'
	  WRITE(6,*)'Unable to modify PS file to make it a LONG_PLOT'
	  CLOSE(UNIT=10)
	  CLOSE(UNIT=11)
	  RETURN
	END IF
	WRITE(11,'(A)')TRIM(STRING)
!
	DO WHILE(1 .EQ. 1)
	   READ(10,'(A)',END=100)STRING	
	   WRITE(11,'(A)')TRIM(STRING)
	END DO
100	CONTINUE
!
! The factor of 1.15 allows for labelling.
!
	REWIND(10)
	REWIND(11)
	DO WHILE(1 .EQ. 1)
	   READ(11,'(A)',END=200)STRING	
	   IF(INDEX(STRING,'%%BeginSetup') .NE. 0)THEN
	     WRITE(10,'(A)')TRIM(STRING)
	     T1=1.15*595.0D0*LP_ASR*LENGTH_OF_HC_PLOT/(8.5D0*2.54D0)
	     T2=842.0D0*LENGTH_OF_HC_PLOT/(11.0D0*2.54D0)
	     WRITE(TMP1,'(I7)')INT(T1)
	     WRITE(TMP2,'(I7)')INT(T2)
	     STRING='<< /PageSize ['//TRIM(ADJUSTL(TMP1))//' '//
	1                 TRIM(ADJUSTL(TMP2))//'] >> setpagedevice'
	   END IF
	   WRITE(10,'(A)')TRIM(STRING)
	END DO
200	CONTINUE
!
	CLOSE(UNIT=10)
	CLOSE(UNIT=11)
!
	RETURN
	END
