!
! Subroutine designed to update the emissivity for anisotropic scattering.
! The quadrature weights must have been previpusly computed.
!
! The ipdated opacitiy and emissivities are retruned via MOD_SPACE_GRID_V2
!
	SUBROUTINE ADD_ETA_DUST(DUST_SCAT_OPAC,ETA,ETA_M_RAY,ETA_P_RAY,IP,NRAY,R,ND,NP)
	USE SET_KIND_MODULE
	USE MOD_SPACE_GRID_V2
	IMPLICIT NONE
!
! Finalized:  09-Mar-2024
!
	INTEGER NP
	INTEGER ND
	INTEGER NRAY
	INTEGER IP
!
	REAL(KIND=LDP)  DUST_SCAT_OPAC(ND)
	REAL(KIND=LDP)  R(ND)
	REAL(KIND=LDP)  ETA(NRAY)
	REAL(KIND=LDP)  ETA_M_RAY(NRAY)
	REAL(KIND=LDP)  ETA_P_RAY(NRAY)
	REAL(KIND=LDP)  ETA_P(ND)
	REAL(KIND=LDP)  ETA_M(ND)
!
	INTEGER, PARAMETER :: IONE=1
	INTEGER I,K,L
	INTEGER NS
	INTEGER NR
	INTEGER NMU
	INTEGER ID
!
	ETA_P=0.0_LDP; ETA_M=0.0_LDP
	DO ID=1,MIN(ND,NP-IP+1)
	  NMU=NP-ID+1
	  DO K=1,NMU
	    ETA_P(ID)=ETA_P(ID) +
	1                   DW(IP)%WGT_P_TO_P(K,ID)*RAY(K)%I_P_SAVE(RAY(K)%LNK(ID)) +
	1                   DW(IP)%WGT_M_TO_P(K,ID)*RAY(K)%I_M_SAVE(RAY(K)%LNK(ID))
	  END DO
	  DO K=1,NMU
	    ETA_M(ID)=ETA_M(ID) +
	1                   DW(IP)%WGT_P_TO_M(K,ID)*RAY(K)%I_P_SAVE(RAY(K)%LNK(ID)) +
	1                   DW(IP)%WGT_M_TO_M(K,ID)*RAY(K)%I_M_SAVE(RAY(K)%LNK(ID))
	  END DO
	  ETA_P(ID)=DUST_SCAT_OPAC(ID)*ETA_P(ID)
	  ETA_M(ID)=DUST_SCAT_OPAC(ID)*ETA_M(ID)
	END DO
!	WRITE(177,'(4ES16.5)')ETA_P(1)/DUST_SCAT_OPAC(1),ETA_P(ND)/DUST_SCAT_OPAC(ND)
!	WRITE(178,'(4ES16.5)')ETA_M(1)/DUST_SCAT_OPAC(1),ETA_M(ND)/DUST_SCAT_OPAC(ND)
!
	L=1
	DO WHILE(RAY(IP)%R_RAY(L) .GT. R(1))
	  L=L+1
	END DO
	NS=RAY(IP)%NZ-L+1
	CALL MON_INTERP(ETA_P_RAY(L),NS,IONE,RAY(IP)%R_RAY(L),NS,ETA_P,ND,R,ND)
	CALL MON_INTERP(ETA_M_RAY(L),NS,IONE,RAY(IP)%R_RAY(L),NS,ETA_M,ND,R,ND)
	DO I=1,L-1
	  ETA_P_RAY(I)=ETA_P_RAY(L)*(R(1)/RAY(IP)%R_RAY(L))**4
	  ETA_M_RAY(I)=ETA_M_RAY(L)*(R(1)/RAY(IP)%R_RAY(L))**4
	END DO
!
	NR=RAY(IP)%NZ
	ETA_P_RAY(1:NR)=ETA(1:NR)+ETA_P_RAY(1:NR)
	ETA_M_RAY(1:NR)=ETA(1:NR)+ETA_M_RAY(1:NR)
!
	RETURN
	END
