	SUBROUTINE GET_HG_FUN(HG_FUN,MU_VEC,NMU,G_VAL,MU_VAL)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER NMU
	REAL(KIND=LDP) MU_VEC(NMU)
	REAL(KIND=LDP) HG_FUN(NMU)
	REAL(KIND=LDP) G_VAL
	REAL(KIND=LDP) MU_VAL
!
	INTEGER, PARAMETER :: NQUAD=20
	REAL(KIND=LDP) X(NQUAD)
	REAL(KIND=LDP) W(NQUAD)
!
	REAL(KIND=LDP) A
	REAL(KIND=LDP) MU_A
	REAL(KIND=LDP) T1
!
	INTEGER I,J
!
	REAL(KIND=LDP) RZERO
	REAL(KIND=LDP) TWO_PI
	REAL(KIND=LDP) FOUR_PI
!
	RZERO=0.0_LDP
	TWO_PI=2.0*ACOS(-1.0_LDP)
	FOUR_PI=2*TWO_PI
	CALL GAULEG(RZERO,TWO_PI,X,W,NQUAD)
!
	MU_A=MU_VAL
	IF(MU_A .LT. -1.0_LDP)MU_A=-1.0_LDP
	IF(MU_A .GT.  1.0_LDP)MU_A=1.0_LDP
	HG_FUN=0.0_LDP
	DO I=1,NMU
	  T1=(1.0_LDP+G_VAL*G_VAL-2*G_VAL*MU_VEC(I)*MU_A)
	  A=2*G_VAL*SQRT(1-MU_A**2)*SQRT(1.0_LDP-MU_VEC(I)**2)/T1
	  DO J=1,NQUAD
	    HG_FUN(I)=HG_FUN(I)+W(J)/SQRT( (1.0_LDP-A*COS(X(J)) )**3 )
	  END DO
	  HG_FUN(I)=HG_FUN(I)*(1.0_LDP-G_VAL*G_VAL)/SQRT(T1**3)/FOUR_PI
	END DO
!
	RETURN
	END
