	SUBROUTINE GET_MOMS_DDT(RSQ_JNU,RSQ_HNU_MID,R, V, FREQ, N_TYPE, ND)
	USE SET_KIND_MODULE
	USE MOD_RAY_MOM_STORE
	IMPLICIT NONE
!
! Altered 16-June-2009 : Fixed bugs with N calculation at boundary, and on nodes.
!
	INTEGER ND
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) FREQ
	CHARACTER(LEN=*) N_TYPE
!
	REAL(KIND=LDP) RSQ_JNU(1:ND)
	REAL(KIND=LDP) RSQ_HNU_MID(1:ND)
!
! Local vectors
!
	REAL(KIND=LDP) RSQ(ND_STORE)
	REAL(KIND=LDP) TMP_VEC(1:ND+1)
!
	REAL(KIND=LDP) T1,T2
	INTEGER, PARAMETER :: IONE=1
	INTEGER I
	INTEGER NS
	INTEGER NDM1
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
!
	NS=ND_STORE
	IF(.NOT. ALLOCATED(K_ON_J))THEN
	   ALLOCATE (RMID(ND))
	   ALLOCATE (H_ON_J(ND))
	   ALLOCATE (N_ON_J(ND))
	   ALLOCATE (K_ON_J(ND))
	   ALLOCATE (KMID_ON_J(ND))
	   ALLOCATE (NMID_ON_J(ND));         NMID_ON_J=0.0_LDP
	   ALLOCATE (NMID_ON_HMID(ND));      NMID_ON_HMID=0.0_LDP
	   ALLOCATE (dlnGRSQJdlnR(ND))
!
	   ALLOCATE (H_ON_J_PREV(ND))
	   ALLOCATE (N_ON_J_PREV(ND))
	   ALLOCATE (K_ON_J_PREV(ND))
	   ALLOCATE (KMID_ON_J_PREV(ND))
	   ALLOCATE (NMID_ON_J_PREV(ND));     NMID_ON_J_PREV=0.0_LDP
	   ALLOCATE (NMID_ON_HMID_PREV(ND));  NMID_ON_HMID_PREV=0.0_LDP
!
	   ALLOCATE (H_ON_J_SAVE(ND))
	   ALLOCATE (N_ON_J_SAVE(ND))
	   ALLOCATE (K_ON_J_SAVE(ND))
	   ALLOCATE (KMID_ON_J_SAVE(ND))
	   ALLOCATE (NMID_ON_J_SAVE(ND));    NMID_ON_J_SAVE=0.0_LDP
	   ALLOCATE (NMID_ON_HMID_SAVE(ND)); NMID_ON_HMID_SAV=0.0_LDP
!
	 END IF
!
	 DO I=1,ND-1
	   RMID(I)=0.5_LDP*(R(I)+R(I+1))
	 END DO
!
	 DO I=1,NS
	   RSQ(I)=R_STORE(I)*R_STORE(I)
	 END DO
!
! Get RSQJ
!
	IF(ND .NE. NS)THEN
	  TMP_VEC(1:NS)=RSQ(1:NS)*JNU_STORE(1:NS)
	  CALL MON_INTERP(RSQ_JNU,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	ELSE
	  RSQ_JNU(1:NS)=RSQ(1:NS)*JNU_STORE(1:NS)
	END IF
!
! The following behaviour depends on whether H & N are defined at the nodes,
! or at the mid-points.
!
	IF(HN_DEF_ON_NODES)THEN
!
	  IF(ND .EQ. NS)THEN
	    H_ON_J(1:ND)=HNU_STORE(1:ND)/JNU_STORE(1:ND)
	  ELSE
	    TMP_VEC(1:NS)=HNU_STORE(1:NS)/JNU_STORE(1:ND)
	    CALL MON_INTERP(H_ON_J,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	  END IF

! Compute r^2.{H,N} at the mid points. These are then used to compute
! Eddington-like factor at the grid mid points.
!
	  NDM1=ND-1
	  TMP_VEC(1:NS)=RSQ(1:NS)*HNU_STORE(1:NS)
	  CALL MON_INTERP(RSQ_HNU_MID,NDM1,IONE,RMID,NDM1,TMP_VEC,NS,R_STORE,NS)
!	
	ELSE
!
! Compute H & N at the grid nodes.
!
	  I=NS+1
	  TMP_VEC(1)=RSQ(1)*HNU_AT_OB; TMP_VEC(NS+1)=RSQ(ND)*HNU_AT_IB
	  TMP_VEC(2:NS)=RSQ_HNU_MID(1:NS-1)
	  CALL MON_INTERP(H_ON_J,ND,IONE,R,ND,TMP_VEC,I,EXT_RMID_STORE,I)
!
	  IF(ND .EQ. NS)THEN

	    DO I=1,NS-1
	      RSQ_HNU_MID(I)=RMID_STORE(I)*RMID_STORE(I)*HNU_STORE(I)
	    END DO
!
	  ELSE
!
! Compute H/J at the mid points in the `new grid.
!
	    I=NS+1
	    TMP_VEC(1)=RSQ(1)*HNU_AT_OB; TMP_VEC(NS+1)=RSQ(NS)*HNU_AT_IB
	    DO I=1,NS-1
	      TMP_VEC(I+1)=RMID_STORE(I)*RMID_STORE(I)*HNU_STORE(I)
	    END DO
	    CALL MON_INTERP(RSQ_HNU_MID,ND,IONE,RMID,ND,TMP_VEC,I,EXT_RMID_STORE,I)
!
	  END IF
!
	END IF
!
	RETURN
	END
