	SUBROUTINE GET_MOMS_REL(R, V, FREQ, N_TYPE, ND)
	USE SET_KIND_MODULE
	USE MOD_RAY_MOM_STORE
	IMPLICIT NONE
!
! Altered 16-June-2009 : Fixed bugs with N calculation at boundary, and on nodes.
!
	INTEGER ND
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) V(ND)
	REAL(KIND=LDP) FREQ
	CHARACTER(LEN=*) N_TYPE
!
! Local vectors
!
	REAL(KIND=LDP) GRSQ(ND_STORE)
!
	REAL(KIND=LDP) TMP_VEC(1:ND+1)
	REAL(KIND=LDP) RSQ_JNU(1:ND)
	REAL(KIND=LDP) RSQ_HNU_MID(1:ND)
	REAL(KIND=LDP) RSQ_NNU_MID(1:ND)
!
	REAL(KIND=LDP) T1,T2
	INTEGER, PARAMETER :: IONE=1
	INTEGER I
	INTEGER NS
	INTEGER NDM1
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
!
	NS=ND_STORE
	IF(.NOT. ALLOCATED(K_ON_J))THEN
	   ALLOCATE (RMID(ND))
	   ALLOCATE (H_ON_J(ND))
	   ALLOCATE (N_ON_J(ND))
	   ALLOCATE (K_ON_J(ND))
	   ALLOCATE (KMID_ON_J(ND))
	   ALLOCATE (NMID_ON_J(ND));    NMID_ON_J=0.0_LDP
	   ALLOCATE (NMID_ON_HMID(ND)); NMID_ON_HMID=0.0_LDP
	   ALLOCATE (dlnGRSQJdlnR(ND))
!
	   ALLOCATE (H_ON_J_PREV(ND))
	   ALLOCATE (N_ON_J_PREV(ND))
	   ALLOCATE (K_ON_J_PREV(ND))
	   ALLOCATE (KMID_ON_J_PREV(ND))
	   ALLOCATE (NMID_ON_J_PREV(ND));    NMID_ON_J_PREV=0.0_LDP
	   ALLOCATE (NMID_ON_HMID_PREV(ND)); NMID_ON_HMID_PREV=0.0_LDP
!
	   ALLOCATE (H_ON_J_SAVE(ND))
	   ALLOCATE (N_ON_J_SAVE(ND))
	   ALLOCATE (K_ON_J_SAVE(ND))
	   ALLOCATE (KMID_ON_J_SAVE(ND))
	   ALLOCATE (NMID_ON_J_SAVE(ND));     NMID_ON_J_SAVE=0.0_LDP
	   ALLOCATE (NMID_ON_HMID_SAVE(ND));  NMID_ON_HMID_SAVE=0.0_LDP
!
	 END IF
!
	 DO I=1,ND-1
	   RMID(I)=0.5_LDP*(R(I)+R(I+1))
	 END DO
!
	 DO I=1,NS
	   GRSQ(I)=GAM_REL_STORE(I)*R_STORE(I)*R_STORE(I)
	 END DO
!
! Compute FEDD=K/J. Since J & K are always computed at the nodes,
! this calculaton is independent of HN_DEFNU_AT_NODES.
!
	IF(ND .NE. NS)THEN
	  TMP_VEC(1:NS)=GRSQ(1:NS)*JNU_STORE(1:NS)
	  CALL MON_INTERP(RSQ_JNU,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	  TMP_VEC(1:NS)=KNU_STORE(1:NS)/JNU_STORE(1:NS)
	  CALL MON_INTERP(K_ON_J,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	ELSE
	  RSQ_JNU(1:NS)=GRSQ(1:NS)*JNU_STORE(1:NS)
	  K_ON_J(1:NS)=KNU_STORE(1:NS)/JNU_STORE(1:NS)
	END IF
!
! Compute K(mid point)/J(node)
!
	NDM1=ND-1
	TMP_VEC(1:NS)=GRSQ(1:NS)*KNU_STORE(1:NS)
        CALL MON_INTERP(KMID_ON_J,NDM1,IONE,RMID,NDM1,TMP_VEC,NS,R_STORE,NS)
        KMID_ON_J(1:NDM1)=KMID_ON_J(1:NDM1)/(RSQ_JNU(1:NDM1)+RSQ_JNU(2:ND))
!
! The following behaviour depends on whether H & N are defined at the nodes,
! or at the mid-points.
!
	IF(HN_DEF_ON_NODES)THEN
!
	  IF(ND .EQ. NS)THEN
	    H_ON_J(1:ND)=HNU_STORE(1:ND)/JNU_STORE(1:ND)
	    N_ON_J(1:ND)=NNU_STORE(1:ND)/JNU_STORE(1:ND)
	  ELSE
!
! Bug fix: 2-Mar-2024 (main version 19-MAr-2024)
!
	    TMP_VEC(1:NS)=HNU_STORE(1:NS)/JNU_STORE(1:NS)
	    CALL MON_INTERP(H_ON_J,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	    TMP_VEC(1:NS)=NNU_STORE(1:NS)/JNU_STORE(1:NS)
	    CALL MON_INTERP(N_ON_J,ND,IONE,R,ND,TMP_VEC,NS,R_STORE,NS)
	  END IF

! Compute r^2.{H,N} at the mid points. These are then used to compute
! Eddington-like factor at the grid mid points.
!
	  NDM1=ND-1
	  TMP_VEC(1:NS)=GRSQ(1:NS)*HNU_STORE(1:NS)
	  CALL MON_INTERP(RSQ_HNU_MID,NDM1,IONE,RMID,NDM1,TMP_VEC,NS,R_STORE,NS)
	  TMP_VEC(1:NS)=GRSQ(1:NS)*NNU_STORE(1:NS)
	  CALL MON_INTERP(RSQ_NNU_MID,NDM1,IONE,RMID,NDM1,TMP_VEC,NS,R_STORE,NS)
!	
	ELSE
!
! Compute H & N at the grid nodes.
!
	  I=NS+1
	  TMP_VEC(1)=GRSQ(1)*HNU_AT_OB; TMP_VEC(NS+1)=GRSQ(ND)*HNU_AT_IB
	  TMP_VEC(2:NS)=RSQ_HNU_MID(1:NS-1)
	  CALL MON_INTERP(H_ON_J,ND,IONE,R,ND,TMP_VEC,I,EXT_RMID_STORE,I)
!
	  TMP_VEC(1)=GRSQ(1)*NNU_AT_OB; TMP_VEC(NS+1)=GRSQ(ND)*NNU_AT_IB
	  TMP_VEC(2:NS)=RSQ_NNU_MID(1:NS-1)
	  CALL MON_INTERP(N_ON_J,ND,IONE,R,ND,TMP_VEC,I,EXT_RMID_STORE,I)
!
	  DO I=1,ND
	    H_ON_J(I)=MIN(1.0_LDP,H_ON_J(I))
	    H_ON_J(I)=MAX(-1.0_LDP,H_ON_J(I))
   	  END DO
!
	  IF(ND .EQ. NS)THEN

	    DO I=1,NS-1
	      T1=0.5_LDP*(GAM_REL_STORE(I)+GAM_REL_STORE(I+1))
	      RSQ_HNU_MID(I)=T1*RMID_STORE(I)*RMID_STORE(I)*HNU_STORE(I)
	      RSQ_NNU_MID(I)=T1*RMID_STORE(I)*RMID_STORE(I)*NNU_STORE(I)
	    END DO
!
	  ELSE
!
! Compute H/J at the mid points in the `new grid.
!
	    I=NS+1
	    TMP_VEC(1)=GRSQ(1)*HNU_AT_OB; TMP_VEC(NS+1)=GRSQ(NS)*HNU_AT_IB
	    DO I=1,NS-1
	      T1=0.5_LDP*(GAM_REL_STORE(I)+GAM_REL_STORE(I+1))
	      TMP_VEC(I+1)=T1*RMID_STORE(I)*RMID_STORE(I)*HNU_STORE(I)
	    END DO
	    CALL MON_INTERP(RSQ_HNU_MID,ND,IONE,RMID,ND,TMP_VEC,I,EXT_RMID_STORE,I)
!
	    TMP_VEC(1)=GRSQ(1)*NNU_AT_OB; TMP_VEC(NS+1)=GRSQ(NS)*NNU_AT_IB
	    DO I=1,NS-1
	      T1=0.5_LDP*(GAM_REL_STORE(I)+GAM_REL_STORE(I+1))
	      TMP_VEC(I+1)=T1*RMID_STORE(I)*RMID_STORE(I)*NNU_STORE(I)
	    END DO
	    CALL MON_INTERP(RSQ_NNU_MID,ND,IONE,RMID,ND,TMP_VEC,I,EXT_RMID_STORE,I)
	  END IF
!
	END IF
!
! Now compute the "G" Eddington factors. Because H may be zero we have to
! be careful. Depending on N_TYPE we can specify N in terms of J, N in
! terms of H, or N in terms of J and H.
!
	IF(N_TYPE .EQ. 'N_ON_J')THEN
	  NMID_ON_HMID(1:NDM1)=0.0_LDP
	  DO I=1,NDM1
	   NMID_ON_J(I)=RSQ_NNU_MID(I)/(RSQ_JNU(I)+RSQ_JNU(I+1))
	  END DO
	ELSE IF(N_TYPE .EQ. 'MIXED')THEN
	 NMID_ON_J(1:NDM1)=0.0_LDP
	  DO I=1,NDM1
	    IF(RSQ_HNU_MID(I) .NE. 0)THEN
	      T1=RSQ_NNU_MID(I)/RSQ_HNU_MID(I)
	    ELSE
	      T1=100.0_LDP
	    END IF
	    IF(T1 .GT. 1.1_LDP .OR. T1 .LT. 0.05_LDP)THEN
	      NMID_ON_J(I)=RSQ_NNU_MID(I)/(RSQ_JNU(I)+RSQ_JNU(I+1))
	      NMID_ON_HMID(I)=0.0_LDP
	    ELSE
	      NMID_ON_HMID(I)=T1
	    END IF
	  END DO
	ELSE IF(N_TYPE .EQ. 'G_ONLY')THEN
!
! Compute G Eddington factor storing in N. We also check the validity of
! the Eddington factor in case strange values are occurring because H
! is near zero (switching sign?).
!
	 NMID_ON_J(1:NDM1)=0.0_LDP
	  DO I=1,NDM1
	    IF(RSQ_HNU_MID(I) .NE. 0)THEN
	      NMID_ON_HMID(I)=RSQ_NNU_MID(I)/RSQ_HNU_MID(I)
	      IF(NMID_ON_HMID(I) .GT. 1.0_LDP)THEN
	        NMID_ON_HMID(I)=1.0_LDP
	      ELSE IF(NMID_ON_HMID(I) .LT. 0.01_LDP) THEN
	        NMID_ON_HMID(I)=0.01_LDP
	      END IF
	    ELSE
	      NMID_ON_HMID(I)=0.0_LDP              !Later replaced by average.
	      LUER=ERROR_LU()
	      WRITE(LUER,'(1X,A,1PE16.8)')'HNU zero for frequency:',FREQ
	      WRITE(LUER,'(1X,A,I4)')'Error occurred at depth:',I
	    END IF
	  END DO
	END IF
!
!	IF(FREQ .LT. 11.44807D0 .AND. FREQ .GT. 11.44805D0 .AND. ND .EQ. ND_STORE)THEN
!	  WRITE(200,*)FREQ
!	  DO I=1,ND
!	    WRITE(200,'(I5,7ES14.4)')I,JNU_STORE(I),HNU_STORE(I),KNU_STORE(I),NNU_STORE(I),
!	1                 K_ON_J(I),NMID_ON_J(I),NMID_ON_HMID(I)
!	  END DO
!	END IF
!
	RETURN
	END
