        MODULE MOD_VAR_MOM_J_CMF
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER VEC_LENGTH
	REAL(KIND=LDP), ALLOCATABLE :: TA(:)
	REAL(KIND=LDP), ALLOCATABLE :: TB(:)
	REAL(KIND=LDP), ALLOCATABLE :: TC(:)
	REAL(KIND=LDP), ALLOCATABLE :: DTAU(:)
	REAL(KIND=LDP), ALLOCATABLE :: RSQ_DTAUONQ(:)
	REAL(KIND=LDP), ALLOCATABLE :: XM(:)
	REAL(KIND=LDP), ALLOCATABLE :: SOURCE(:)
	REAL(KIND=LDP), ALLOCATABLE :: Q(:)
	REAL(KIND=LDP), ALLOCATABLE :: JNU(:)
	REAL(KIND=LDP), ALLOCATABLE :: RSQ_HNU(:)
	REAL(KIND=LDP), ALLOCATABLE :: VB(:)
	REAL(KIND=LDP), ALLOCATABLE :: VC(:)
	REAL(KIND=LDP), ALLOCATABLE :: HU(:)
	REAL(KIND=LDP), ALLOCATABLE :: HL(:)
	REAL(KIND=LDP), ALLOCATABLE :: HS(:)
	REAL(KIND=LDP), ALLOCATABLE :: GAM(:)
	REAL(KIND=LDP), ALLOCATABLE :: GAMH(:)
	REAL(KIND=LDP), ALLOCATABLE :: W(:)
	REAL(KIND=LDP), ALLOCATABLE :: WPREV(:)
	REAL(KIND=LDP), ALLOCATABLE :: PSI(:)
	REAL(KIND=LDP), ALLOCATABLE :: PSIPREV_MOD(:)
	REAL(KIND=LDP), ALLOCATABLE :: PSIPREV(:)
	REAL(KIND=LDP), ALLOCATABLE :: EPS_A(:)
	REAL(KIND=LDP), ALLOCATABLE :: EPS_B(:)
	REAL(KIND=LDP), ALLOCATABLE :: EPS_PREV_A(:)
	REAL(KIND=LDP), ALLOCATABLE :: EPS_PREV_B(:)
	REAL(KIND=LDP), ALLOCATABLE :: TX_OLD_d_T(:)
	REAL(KIND=LDP), ALLOCATABLE :: TX_OLD_d_dTdR(:)
	REAL(KIND=LDP), ALLOCATABLE :: JNUM1(:)
	REAL(KIND=LDP), ALLOCATABLE :: RSQ_HNUM1(:)
!
	END MODULE MOD_VAR_MOM_J_CMF
!
	SUBROUTINE MOD_VAR_MOM_ALLOC(ND)
	USE SET_KIND_MODULE
	USE MOD_VAR_MOM_J_CMF
	IMPLICIT NONE
!
	INTEGER ND
	INTEGER IOS
	INTEGER LUER
	INTEGER ERROR_LU
	EXTERNAL ERROR_LU
!
	IF(.NOT. ALLOCATED(TA))THEN
	  ALLOCATE (TA(ND),TB(ND),TC(ND),DTAU(ND),RSQ_DTAUONQ(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (XM(ND),SOURCE(ND),Q(ND),JNU(ND),RSQ_HNU(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (VB(ND),VC(ND),HU(ND),HL(ND),HS(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (GAM(ND),GAMH(ND),W(ND),WPREV(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (PSI(ND),PSIPREV_MOD(ND),PSIPREV(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (EPS_A(ND),EPS_B(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (EPS_PREV_A(ND),EPS_PREV_B(ND),STAT=IOS)
	  IF(IOS .EQ. 0)ALLOCATE (TX_OLD_d_T(ND),TX_OLD_d_dTdR(ND),STAT=IOS)
!
! NB: JNUM1 and RSQHNUM1 must not be zeroed in the routine.
!
	  IF(IOS .EQ. 0)ALLOCATE (JNUM1(ND),RSQ_HNUM1(ND),STAT=IOS)
	  VEC_LENGTH=ND
!
	  IF(IOS .NE. 0)THEN
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Unable to allocate memory in MOD_VAR_MOM_ALLOC'
	    WRITE(LUER,*)'STAT=',IOS
	    STOP
	  END IF
	END IF
!
! Initialize all vectors.
!
	TA=0.0_LDP; TB=0.0_LDP; TC=0.0_LDP; DTAU=0.0_LDP; RSQ_DTAUONQ=0.0_LDP
	XM=0.0_LDP; SOURCE=0.0_LDP; Q=0.0_LDP; JNU=0.0_LDP; RSQ_HNU=0.0_LDP
	VB=0.0_LDP; VC=0.0_LDP; HU=0.0_LDP; HL=0.0_LDP; HS=0.0_LDP
	EPS_A=0.0_LDP; EPS_B=0.0_LDP; EPS_PREV_A=0.0_LDP; EPS_PREV_B=0.0_LDP
	TX_OLD_d_T=0.0_LDP; TX_OLD_d_dTdR=0.0_LDP
	GAM=0.0_LDP; GAMH=0.0_LDP; W=0.0_LDP; WPREV=0.0_LDP
	PSI=0.0_LDP; PSIPREV_MOD=0.0_LDP; PSIPREV=0.0_LDP
!
	RETURN
	END	
