!
! Simple program to many models using the last record from the SCRTEMP record.
!
	PROGRAM PLT_MAN_MODL
	USE SET_KIND_MODULE
	USE MOD_COLOR_PEN_DEF
	USE GEN_IN_INTERFACE
	IMPLICIT NONE
	INTEGER ND,NT,NIT
!
	INTEGER, PARAMETER :: NUM_IONS_MAX=200
	TYPE MODEL_DATA
	  INTEGER ND
	  INTEGER NT
	  REAL(KIND=LDP), ALLOCATABLE :: POPS(:,:)
	  REAL(KIND=LDP), ALLOCATABLE :: R(:)			!ND
	  REAL(KIND=LDP), ALLOCATABLE :: V(:)			!ND
	  REAL(KIND=LDP), ALLOCATABLE :: SIGMA(:)		!ND
!
	  REAL(KIND=LDP), ALLOCATABLE :: X(:)			!ND
	  REAL(KIND=LDP), ALLOCATABLE :: Y(:)			!ND
	  REAL(KIND=LDP), ALLOCATABLE :: Z(:)			!ND
!
	  REAL(KIND=LDP), ALLOCATABLE :: ZION(:)
	  REAL(KIND=LDP), ALLOCATABLE :: AT_NO(:)
	  INTEGER, ALLOCATABLE :: ION_INDEX(:)
          INTEGER, ALLOCATABLE :: NION(:)
          INTEGER NUM_IONS
          CHARACTER(LEN=10), ALLOCATABLE :: ION_ID(:)
          CHARACTER(LEN=132) DIRECTORY
	END TYPE MODEL_DATA
!
	INTEGER, PARAMETER :: MAX_MODS=100
	TYPE (MODEL_DATA) MODS(MAX_MODS)
!
	INTEGER, PARAMETER :: IZERO=0
	INTEGER, PARAMETER :: IONE=1
	INTEGER, PARAMETER :: T_OUT=6
	INTEGER, PARAMETER :: LU_IN=10
	INTEGER, PARAMETER :: LU_OUT=20
C
	INTEGER, PARAMETER :: NLIM_MAX=10
	INTEGER LIMITS(NLIM_MAX)
	INTEGER NPLTS
	INTEGER RD_NMOD
	INTEGER NMOD
	INTEGER IREC
	INTEGER LST_IREC
	INTEGER IVAR
	INTEGER IV1,IV2
	INTEGER ID1,ID2
	INTEGER LOW_ID,UP_ID
	INTEGER I
	INTEGER J
	INTEGER K
	INTEGER ID
	INTEGER IT,IT2
	INTEGER NY
	INTEGER NITSF
	INTEGER LST_NG
	INTEGER RITE_N_TIMES
	INTEGER LUSCR
	INTEGER IOS
C
	LOGICAL LOG_Y_AXIS
	LOGICAL NEWMOD
	LOGICAL RVSIG_WRITTEN
	LOGICAL DO_ABS
	LOGICAL, PARAMETER :: L_TRUE=.TRUE.
	CHARACTER*10 TMP_STR
	CHARACTER*10 OPTION
	CHARACTER*80 YLABEL
	CHARACTER*200 STRING
	CHARACTER(LEN=200) FILENAME
	CHARACTER(LEN=200) DIR_NAME(MAX_MODS)
C
	INTEGER IMAX,IMIN
	REAL(KIND=LDP) RMAX,RMIN
	REAL(KIND=LDP) T1,T2,T3
	REAL(KIND=LDP) MAX_CHANGE
	REAL(KIND=LDP) AVE_NEG_CHANGE, MIN_NEG_CHANGE
	REAL(KIND=LDP) AVE_POS_CHANGE, MAX_POS_CHANGE
	LOGICAL COR_READ
	LOGICAL READ_IN_STEQ
	LOGICAL READ_AGAIN
	LOGICAL FILE_EXISTS
C
	LUSCR=26
	RITE_N_TIMES=1
	NEWMOD=.TRUE.
	COR_READ=.FALSE.
	READ_AGAIN=.FALSE.
	READ_IN_STEQ=.TRUE.
	NMOD=0
!
	WRITE(T_OUT,*)' '
	WRITE(T_OUT,*)'This routine should be run in a CLEAB directory'
	WRITE(T_OUT,*)'The following files:'
	WRITE(T_OUT,*)'                  POINT1.DAT'
	WRITE(T_OUT,*)'                  POINT2.DAT'
	WRITE(T_OUT,*)'                  SCRTEMP.DAT'
	WRITE(T_OUT,*)'cannot be in the directory'
	WRITE(T_OUT,*)' '
!
	INQUIRE(FILE='SCRTEMP',EXIST=FILE_EXISTS)
	IF(.NOT. FILE_EXISTS)INQUIRE(FILE='POINT1',EXIST=FILE_EXISTS)
	IF(.NOT. FILE_EXISTS)INQUIRE(FILE='POINT2',EXIST=FILE_EXISTS)
	IF(FILE_EXISTS)THEN
	   WRITE(6,*)'Error -- SCRTEMP altready occurs in this dirctory'
	   STOP
	END IF
!
	OPTION=' '
1000	CONTINUE
	IF(OPTION .EQ. ' ')THEN
	  OPTION='RD_MOD'
	ELSE
	  OPTION='P'
	END IF
	CALL GEN_IN(OPTION,'Option: RD_DIRS, RD_MOD, PV, PL, WR, H, EX')
	CALL SET_CASE_UP(OPTION,0,0)
!
	IF(OPTION .EQ. 'H')THEN
	  WRITE(T_OUT,*)' '
	  WRITE(T_OUT,*)' For the next 4 options, we plot versus iteration number '
	  WRITE(T_OUT,*)' '
!
	  WRITE(T_OUT,*)' '
	  WRITE(T_OUT,*)'LY  :: Switch to/from Log(Y) for options where appropriate (not full implemented)'
	  WRITE(T_OUT,*)' '
	  WRITE(T_OUT,*)'E   :: EXIT'
	  WRITE(T_OUT,*)' '
!
	ELSE IF(OPTION .EQ. 'RD_MOD' .OR. OPTION .EQ. 'RD_DIRS')THEN
!
	  IF(OPTION .EQ. 'RD_DIRS')THEN
	    FILENAME='DIRECTORIES'
	    CALL GEN_IN(FILENAME,'File with list of directories')
	    OPEN(UNIT=10,FILE=FILENAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
	    IF(IOS .NE. 0)THEN
	      WRITE(6,*)'Unable to open file: IOSTAT=',IOS
	      GOTO 1000
	    END IF
	    DO I=1,MAX_MODS
	      READ(10,'(A)',END=200)DIR_NAME(I)
	      RD_NMOD=I
	   END DO
200        CLOSE(UNIT=10)
           WRITE(6,*)'Number of directory names read is:',NMOD
	  ELSE
	    RD_NMOD=1
	    CALL GEN_IN(DIR_NAME(1),'Input model directory/')
	  END IF
!
	  DO I=1,RD_NMOD
	    ID=NMOD+1
	    K=LEN_TRIM(DIR_NAME(I))
	    IF(DIR_NAME(I)(K:K) .NE. '/')DIR_NAME(I)(K+1:K+1)='/'
	    MODS(ID)%DIRECTORY=DIR_NAME(I)
	    FILENAME=TRIM(MODS(ID)%DIRECTORY)//'MODEL'
	    WRITE(6,*)TRIM(FILENAME)	
	    OPEN(UNIT=12,FILE=FILENAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
	      IF(IOS .NE. 0)THEN
	        WRITE(6,*)'Unable to open file: IOSTAT=',IOS
	        GOTO 1000
	      END IF
	      STRING=' '
	      DO WHILE(INDEX(STRING,'!Number of depth') .EQ. 0)
	        READ(12,'(A)',IOSTAT=IOS)STRING
	        IF(IOS .NE. 0)GOTO 100
	      END DO
	      READ(STRING,*)MODS(ID)%ND
	      DO WHILE(INDEX(STRING,'!Total number of variables') .EQ. 0)
	        READ(12,'(A)',IOSTAT=IOS)STRING
	        IF(IOS .NE. 0)GOTO 100
	      END DO
	      READ(STRING,*)MODS(ID)%NT
	      WRITE(6,*)'ND,NT',MODS(ID)%ND,MODS(ID)%NT
100	      IF(IOS .NE. 0)THEN
	        WRITE(T_OUT,*)'Unable to read MODEL file'
	        CALL GEN_IN(NT,'Total number of levels')
	        CALL GEN_IN(ND,'Number of depth points')
	      ELSE
	        CLOSE(UNIT=12)
	        ALLOCATE (MODS(ID)%ZION(NUM_IONS_MAX))
	        ALLOCATE (MODS(ID)%AT_NO(NUM_IONS_MAX))
	        ALLOCATE (MODS(ID)%ION_INDEX(NUM_IONS_MAX))
	        ALLOCATE (MODS(ID)%NION(NUM_IONS_MAX))
	        ALLOCATE (MODS(ID)%ION_ID(NUM_IONS_MAX))
	        WRITE(6,*)'Reading in ion data'
	        CALL RD_ION_LOCATIONS_V2(FILENAME,MODS(ID)%ION_ID,MODS(ID)%NION,MODS(ID)%ION_INDEX,
	1                             MODS(ID)%ZION,MODS(ID)%AT_NO,
	1                             MODS(ID)%NUM_IONS,NUM_IONS_MAX,LU_IN)
	        WRITE(6,*)'Read in ion data'
	      END IF
!
	      FILENAME=TRIM(MODS(ID)%DIRECTORY)//'POINT1'
	      OPEN(UNIT=12,FILE=FILENAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
	      IF(IOS .EQ. 0)READ(12,'(A)',IOSTAT=IOS)STRING
	      IF(IOS .EQ. 0)THEN
                IF(INDEX(STRING,'!Format date') .EQ. 0)THEN
                  READ(STRING,*,IOSTAT=IOS)K,NIT
	        ELSE
                  READ(12,*,IOSTAT=IOS)K,NIT
	        END IF
	      END IF
	      IF(IOS .NE. 0)THEN
	        WRITE(T_OUT,*)'Possible error reading ',TRIM(FILENAME)
	        STOP
	      END IF
	    CLOSE(UNIT=12)
!
	    NT=MODS(ID)%NT; ND=MODS(ID)%ND
	    ALLOCATE (MODS(ID)%POPS(NT,ND))
	    ALLOCATE (MODS(ID)%R(ND))
	    ALLOCATE (MODS(ID)%V(ND))
	    ALLOCATE (MODS(ID)%SIGMA(ND))
C
	    J=MAX(NT,ND)
	    ALLOCATE (MODS(ID)%X(J))
	    ALLOCATE (MODS(ID)%Y(J))
	    ALLOCATE (MODS(ID)%Z(J))
!
	    WRITE(6,*)'   Number of depth points is:',ND
	    WRITE(6,*)'Number of variables/depth is:',NT
	    WRITE(6,*)'        Number of iterations:',NIT
!
	    STRING='ln -sf '//TRIM(MODS(ID)%DIRECTORY)//'SCRTEMP  '//'SCRTEMP'
	    WRITE(6,*)TRIM(STRING)
	    CALL SYSTEM(STRING)
	    STRING='ln -sf '//TRIM(MODS(ID)%DIRECTORY)//'POINT1   '//'POINT1'
	    CALL SYSTEM(STRING)
	    STRING='ln -sf '//TRIM(MODS(ID)%DIRECTORY)//'POINT2   '//'POINT2'
	    CALL SYSTEM(STRING)
	    CALL SCR_READ_V2(MODS(ID)%R,MODS(ID)%V,MODS(ID)%SIGMA,MODS(ID)%POPS,
	1                NIT,NITSF,RITE_N_TIMES,LST_NG,RVSIG_WRITTEN,
	1                NT,ND,LUSCR,NEWMOD)
	    STRING='unlink SCRTEMP'; CALL SYSTEM(STRING)
	    STRING='unlink POINT1' ; CALL SYSTEM(STRING)
	    STRING='unlink POINT2' ; CALL SYSTEM(STRING)
!
	    NMOD=NMOD+1
	    WRITE(6,*)'Number of mods is',NMOD
	    WRITE(6,*)MODS(ID)%R(1)
	  END DO
	  GOTO 1000
!
	ELSE IF(OPTION .EQ. 'PV')THEN
	  WRITE(6,*)NMOD
	  DO ID=1,NMOD
	    ND=MODS(ID)%ND
	    DO I=1,ND
	      MODS(ID)%Z(I)=SUM(MODS(ID)%POPS(1:21,I))
	    END DO
	    MODS(ID)%Y(1:ND)=MODS(ID)%POPS(1,1:ND)  !/MODS(ID)%Z(1:ND)
	    WRITE(6,*)MODS(ID)%ND,MODS(ID)%V(1),MODS(ID)%POPS(1,1)
	    CALL DP_CURVE(ND,MODS(ID)%V,MODS(ID)%Y)
	  END DO
	  GOTO 1000
!
	ELSE IF(OPTION .EQ. 'FDG')THEN
	  CALL GEN_IN(ID,'Model to shift')
	  CALL GEN_IN(T1,'Velocity shift')
	  ND=MODS(ID)%ND
	  DO I=1,ND
	    MODS(ID)%Z(I)=SUM(MODS(ID)%POPS(1:21,I))
	  END DO
	  DO I=1,ND
	    T2=MAX(T1,ABS(MODS(ID)%V(I)-4620.0_LDP))
	    MODS(ID)%X(I)=MODS(ID)%V(I)-T1/MAX(1.0_LDP,T2/T1)
	  END DO
	  CALL DP_CURVE(ND,MODS(ID)%X,MODS(ID)%Y)
	  GOTO 1000
!
	ELSE IF(OPTION .EQ. 'IH')THEN
	  WRITE(6,*)NMOD
	  DO ID=1,NMOD
	    ND=MODS(ID)%ND
	    DO I=1,ND
	      MODS(ID)%Z(I)=SUM(MODS(ID)%POPS(1:21,I))
	    END DO
	    MODS(ID)%Y(1:ND)=MODS(ID)%POPS(1,1:ND)/MODS(ID)%POPS(21,1:ND)  !/MODS(ID)%Z(1:ND)
	    CALL DP_CURVE(ND,MODS(ID)%V,MODS(ID)%Y)
	  END DO
	  GOTO 1000
!
	ELSE IF(OPTION .EQ. 'PL')THEN
	  CALL GEN_IN(I,'Level to plot')
	  DO ID=1,NMOD
	    J=MIN(I,MODS(ID)%NT); ND=MODS(ID)%ND
	    MODS(ID)%Y(1:ND)=MODS(ID)%POPS(J,1:NT)
	    CALL DP_CURVE(ND,MODS(ID)%V,MODS(ID)%Y)
	  END DO
	  GOTO 1000
!
	ELSE IF(OPTION(1:2) .EQ. 'WR')THEN
	  ID=1
	  WRITE(6,*)'NT=',NT
	  DO I=1,MODS(ID)%NUM_IONS
	    WRITE(6,'(A,T12,I4,3X,I4,3X,F4.1)')TRIM(MODS(ID)%ION_ID(I)), MODS(ID)%ION_INDEX(I),
	1               MODS(ID)%NION(I), MODS(ID)%ZION(I)
	  END DO
	  GOTO 1000
!
	ELSE IF(OPTION .EQ. 'P')THEN
	  CALL GRAMON_PGPLOT(' ',' ',' ',' ')
	  GOTO 1000
!
	ELSE IF(OPTION(1:2) .EQ. 'LY')THEN
	   WRITE(6,*)RED_PEN
	  IF(LOG_Y_AXIS)WRITE(6,*)'Switching to linear Y axis'
	  IF(.NOT. LOG_Y_AXIS)WRITE(6,*)'Switching to logarithmic Y axis'
	  WRITE(6,'(A)')DEF_PEN
	  TMP_STR=' '; CALL GEN_IN(TMP_STR,'Hit any character to continue')
	  LOG_Y_AXIS=.NOT. LOG_Y_AXIS
	  GOTO 1000
!
	ELSE IF(OPTION(1:2) .EQ. 'E ' .OR. OPTION(1:2) .EQ. 'EX')THEN
	  STOP
!
	ELSE
	  WRITE(6,*)'Unrecognized option'
	  GOTO 1000
	END IF
!
	STOP
	END
