!
	SUBROUTINE ADJUST_JES(NU,J_ES,NCF,T_ELEC,ONE_PAR,OPTION)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER NCF
	REAL(KIND=LDP) NU(NCF)
	REAL(KIND=LDP) J_ES(NCF)
	REAL(KIND=LDP) T_ELEC
	LOGICAL ONE_PAR
	CHARACTER*(*) OPTION
!
	REAL(KIND=LDP) PLANCK_FN(NCF)
	REAL(KIND=LDP) PLANCK_ES(NCF)
	REAL(KIND=LDP) LOG_J_ES(NCF)
	REAL(KIND=LDP) PLANCK_NU(NCF)
	REAL(KIND=LDP) D(NCF)
!
	COMMON/CONSTANTS/ CHIBF,CHIFF,HDKT,TWOHCSQ
	COMMON/LINE/ OPLIN,EMLIN
	REAL(KIND=LDP) CHIBF,CHIFF,HDKT,TWOHCSQ,OPLIN,EMLIN
!
	REAL(KIND=LDP) T1
	INTEGER ML,I
!
	PLANCK_FN(1:NCF)=TWOHCSQ*(NU(1:NCF)**3)/
	1                    (EXP(HDKT*NU(1:NCF)/T_ELEC)-1.0_LDP)
	IF(ONE_PAR)THEN
	  CALL CNVLV_ES_ONE_PAR(NU,PLANCK_FN,PLANCK_ES,NCF,T_elec)
	ELSE
	  CALL CNVLV_ES_TWO_PAR(NU,PLANCK_FN,PLANCK_ES,NCF,T_elec)
	END IF
	PLANCK_FN=LOG(PLANCK_FN)
	PLANCK_ES=LOG(PLANCK_ES)
!
! Shift and scale e.s. funtion so still have Planck function
!
	PLANCK_NU(1)=NU(1)
	I=2
	ML=1
	DO WHILE(NU(I) .GT. 1.5_LDP*T_ELEC)
	  DO WHILE(PLANCK_ES(I) .GT. PLANCK_FN(ML))
	    ML=ML+1
	  END DO
	  DO WHILE(PLANCK_ES(I) .LT. PLANCK_FN(ML-1))
	    ML=ML+1
	  END DO
	  T1=(PLANCK_ES(I)-PLANCK_FN(ML))/(PLANCK_FN(ML-1)-PLANCK_FN(ML))
          PLANCK_NU(I)=T1*NU(ML-1)+(1.0_LDP-T1)*NU(ML)
	  I=I+1
	END DO
C
	T1=1/NU(I-1)-1/PLANCK_NU(I-1)		!Wavelength shift
	DO ML=I,NCF
	  PLANCK_NU(ML)=1.0_LDP/( 1.0_LDP/NU(ML) - T1)
	END DO
C
C Perform a simple linear interpolation back onto the old frequency grid.
C
	LOG_J_ES(:)=LOG(J_ES(:))
	J_ES(:)=LOG_J_ES(:)		!Boundary points
	D(:)=PLANCK_ES(:)
	I=1
	DO ML=2,NCF-2
	  DO WHILE (NU(ML) .LT. PLANCK_NU(I+1))
	    I=I+1
	  END DO
	  T1=(NU(ML)-PLANCK_NU(I))/(PLANCK_NU(I+1)-PLANCK_NU(I))
	  PLANCK_ES(ML)=T1*D(I+1)+(1.0_LDP-T1)*D(I)
	  J_ES(ML)=T1*LOG_J_ES(I+1)+(1.0_LDP-T1)*LOG_J_ES(I)
	END DO
C
	J_ES(:)=EXP( J_ES(:)+PLANCK_FN(:)-PLANCK_ES(:) )
C
	RETURN
	END
