	SUBROUTINE COMP_IP_EW(IP,NU,LAM,P,R,DISTANCE,NCF,NP,ND)
	USE SET_KIND_MODULE
	USE MOD_USR_OPTION
	IMPLICIT NONE
!
	INTEGER NCF,NP,ND
	REAL(KIND=LDP) IP(NP,NCF)
	REAL(KIND=LDP) NU(NCF),LAM(NCF)
	REAL(KIND=LDP) P(NP)
	REAL(KIND=LDP) R(ND)
	REAL(KIND=LDP) DISTANCE
!
	REAL(KIND=LDP), ALLOCATABLE :: XV(:)
	REAL(KIND=LDP), ALLOCATABLE :: YV(:)
	REAL(KIND=LDP), ALLOCATABLE :: CONT_FLUX(:)
	REAL(KIND=LDP), ALLOCATABLE :: EW(:)
!
	REAL(KIND=LDP) CONT_LAM_B,CONT_LAM_R
	REAL(KIND=LDP) LINE_LAM_B,LINE_LAM_R
	REAL(KIND=LDP) LINE_WAVELENGTH
	REAL(KIND=LDP) LINE_FREQUENCY
!
	REAL(KIND=LDP) CONT_SLOPE
	REAL(KIND=LDP) CONT_FLUX_R
	REAL(KIND=LDP) CONT_FLUX_B
!
	INTEGER ICONT_B,ICONT_R
	INTEGER ILINE_B,ILINE_R
	INTEGER ILINE
!
	REAL(KIND=LDP) T1,T2,PI
	REAL(KIND=LDP) ANG_TO_HZ
	REAL(KIND=LDP) PARSEC
	REAL(KIND=LDP) SPEED_OF_LIGHT
	INTEGER GET_INDX_DP
	CHARACTER(LEN=30) UC
	EXTERNAL UC,PARSEC,GET_INDX_DP,SPEED_OF_LIGHT
!
	INTEGER SM_NP
	INTEGER P_INDX
	INTEGER J,L,ML
	INTEGER, PARAMETER :: T_OUT=6
	CHARACTER(LEN=5) XUNIT,FLUX_OPT
	CHARACTER(LEN=20) XLAB,YLAB
!	
!	T1=P(I)*1.0E+10*206265.0D0/(DISTANCE*1.0E+03*PARSEC())
!	WRITE(T_OUT,'(1X,A,1P,E14.6,A)')'       P(I)=',P(I)*1.0E+10,' cm'
!	WRITE(T_OUT,'(1X,A,1P,E14.6,A)')'       P(I)=',T1,' arcsec'
!	WRITE(T_OUT,'(1X,A,1P,E14.6,A)')'       P(I)=',P(I)/6.96D0,' Rsun'
!	WRITE(T_OUT,'(1X,A,1P,E14.6)')'    P(I)/R*=',P(I)/R(ND)
!	WRITE(T_OUT,'(1X,A,1P,E14.6,A)')'          d=',DISTANCE,' kpc'
!

	ANG_TO_HZ=SPEED_OF_LIGHT()*1.0E-07_LDP      !10^8/10^15
	CALL USR_OPTION(CONT_LAM_B,'CLAMB',' ','Continuum wavelength on blue side')
	CALL USR_OPTION(CONT_LAM_R,'CLAMR',' ','Continuum wavelength on red  side')
	CALL USR_OPTION(LINE_LAM_B,'LLAMB',' ','Line wavelength on blue side')
	CALL USR_OPTION(LINE_LAM_R,'LLAMR',' ','Line wavelength on red  side')
	CALL USR_OPTION(LINE_WAVELENGTH,'LLAM',' ','Line wavelength')
	LINE_FREQUENCY=ANG_TO_HZ/LINE_WAVELENGTH
!
	IF(.NOT. ALLOCATED(XV))THEN
	  ALLOCATE (XV(NP))
	  ALLOCATE (EW(NP))
	  ALLOCATE (CONT_FLUX(NP))
	  ALLOCATE (YV(NCF))
	END IF
!
	ICONT_B=GET_INDX_DP(CONT_LAM_B,LAM,NCF)
	ICONT_R=GET_INDX_DP(CONT_LAM_R,LAM,NCF)
	ILINE_B=GET_INDX_DP(LINE_LAM_B,LAM,NCF)
	ILINE_R=GET_INDX_DP(LINE_LAM_R,LAM,NCF)
	ILINE=GET_INDX_DP(LINE_WAVELENGTH,LAM,NCF)
!
	SM_NP=NP-5
	WRITE(6,*)'SM_NP=',SM_NP
	DO P_INDX=1,SM_NP
!
	  YV(1:NCF)=0.0_LDP
	  DO ML=MAX(1,ICONT_B-5),MIN(NCF,ICONT_R+5)
	    DO J=P_INDX,NP-1
	      YV(ML)=YV(ML)+0.5_LDP*(IP(J,ML)*P(J)+IP(J+1,ML)*P(J+1))*(P(J+1)-P(J))
	    END DO
	  END DO
!
! Converted to Jy.
!
	  PI=4.0_LDP*ATAN(1.0_LDP)
          T1=DISTANCE*1.0E+03_LDP*PARSEC()
	  T1=2.0_LDP*PI*1.0E+23_LDP*(1.0E+10_LDP/T1)**2
	  YV(1:NCF)=YV(1:NCF)*T1
!
! Now convert to erg/cm^/s/Ang
!
	  T1=1.0E-23_LDP*1.0E+15_LDP
	  YV(1:NCF)=T1*YV(1:NCF)*NU(1:NCF)/LAM(1:NCF)
!
	  L=0; CONT_FLUX_B=0.0_LDP
	  DO ML=MAX(1,ICONT_B-1),MIN(NCF,ICONT_B+1)
	    L=L+1
	    CONT_FLUX_B=CONT_FLUX_B+YV(ML)
	  END DO
	  CONT_FLUX_B=CONT_FLUX_B/L
!
	  L=0; CONT_FLUX_R=0.0_LDP
	  DO ML=MAX(1,ICONT_R-1),MIN(NCF,ICONT_R+1)
	    L=L+1
	    CONT_FLUX_R=CONT_FLUX_R+YV(ML)
	  END DO
	  CONT_FLUX_R=CONT_FLUX_R/L
!
! Compute the straight line that defines the continuum.
!
	  CONT_SLOPE=(CONT_FLUX_R-CONT_FLUX_B)/(CONT_LAM_R-CONT_LAM_B)
!
! Get the flux at the central line wavelength.
!
	  CONT_FLUX(P_INDX)=CONT_FLUX_B+CONT_SLOPE*(LINE_WAVELENGTH-CONT_LAM_B)
!
! Normalize the continuum to unity, and subtract 1.0D0
!
	  DO ML=MAX(1,ICONT_B-1),MIN(NCF,ICONT_R+1)
	     T2=CONT_FLUX_B+CONT_SLOPE*(LAM(ML)-CONT_LAM_B)
	     YV(ML)=YV(ML)/T2-1.0_LDP
	   END DO
!
! Compute the line equivalent width.
!
	   EW(P_INDX)=0.0_LDP
	   DO ML=ILINE_B,ILINE_R-1
	     EW(P_INDX)=EW(P_INDX)+0.5_LDP*(YV(ML)+YV(ML+1))*(LAM(ML+1)-LAM(ML))
	   END DO
!
! Get next index
!
	END DO
!
	CALL USR_OPTION(XUNIT,'XUNIT',' ','Unit for X-axis - AU, arc(sec), PONR, N')
	P(1)=0.1_LDP*P(2)
	IF( UC(XUNIT) .EQ. 'AU')THEN
	  XV(1:NP)=LOG10(P(1:NP)*1.0E+10_LDP/1.49597E+13_LDP)
	  XLAB='Log d(AU)'
	ELSE IF(UC(XUNIT(1:3)) .EQ. 'ARC')THEN
	  T1=1.0E+10_LDP*206265.0_LDP/(DISTANCE*1.0E+03_LDP*PARSEC())
	  XV(1:NP)=LOG10(T1*P(1:NP))
	  XLAB='Log(arc seconds)'
	ELSE IF( UC(XUNIT) .EQ. 'PONR')THEN
	  XV(1:NP)=LOG10(P(1:NP)/R(ND))
	  XLAB='Log(P/R\d*\u)'
	ELSE IF( UC(XUNIT) .EQ. 'N')THEN
	  DO J=1,NP
	    XV(J)=J
	  END DO
	  XLAB='P index'
	ELSE
	  WRITE(6,*)'Unrecognized unit'
	END IF
!
! Plot line EW.
!
	YLAB='EW(\gA)'
	CALL DP_CURVE(SM_NP,XV,EW)
	CALL GRAMON_PGPLOT(XLAB,YLAB,' ',' ')
!
! Plot continuum fluxs (if wanted).
!
	CALL USR_OPTION(FLUX_OPT,'FLUX_OPT',' ','Flux option -- J(y) , E(rg) or skip')
	IF(UC(FLUX_OPT(1:1)) .EQ. 'J')THEN
	  CONT_FLUX=1.0E+23_LDP*CONT_FLUX*LINE_WAVELENGTH/(1.0E+15_LDP*LINE_FREQUENCY)
	  CALL DP_CURVE(SM_NP,XV,CONT_FLUX)
	  CALL GRAMON_PGPLOT(XLAB,'Jy',' ',' ')
	ELSE IF(UC(FLUX_OPT(1:1)) .EQ. 'E')THEN
	  CALL DP_CURVE(SM_NP,XV,CONT_FLUX)
	  CALL GRAMON_PGPLOT(XLAB,'erg/cm\u2\d/s',' ',' ')
	ELSE
	  WRITE(6,*)'Unknown unit - skipping continuum flux plot'
	END IF
	
	RETURN
	END
