	SUBROUTINE GET_ND_NT_NIT(FILE_NAME,ND,NT,NIT,LUIN,IOS)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER ND
	INTEGER NT
	INTEGER NIT
	INTEGER LUIN
	INTEGER IOS
	CHARACTER(LEN=*) FILE_NAME
!
	INTEGER, PARAMETER :: T_OUT=6
	INTEGER K
	CHARACTER(LEN=132) NEW_FILE_NAME
	CHARACTER(LEN=132) STRING
!
! We need to get ND and NT from the MODEL file. This will exist if SCRTEMP exists.
!
	K=INDEX(FILE_NAME,'SCRTEMP')
	IF(K .EQ. 1)THEN
	  NEW_FILE_NAME='MODEL'
	ELSE
	  NEW_FILE_NAME=FILE_NAME(1:K-1)//'MODEL'
	END IF
	OPEN(UNIT=LUIN,FILE=NEW_FILE_NAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
	  IF(IOS .NE. 0)THEN
	    WRITE(T_OUT,*)'Unable to open MODEL file in GET_ND_NT_NIT'
	    RETURN
	  END IF
!
	  STRING=' '
	  DO WHILE(INDEX(STRING,'!Number of depth') .EQ. 0)
	    READ(LUIN,'(A)',IOSTAT=IOS)STRING
	    IF(IOS .NE. 0)GOTO 100
	  END DO
	  READ(STRING,*)ND
	  DO WHILE(INDEX(STRING,'!Total number of variables') .EQ. 0)
	    READ(LUIN,'(A)',IOSTAT=IOS)STRING
	    IF(IOS .NE. 0)GOTO 100
	  END DO
	  READ(STRING,*)NT
!
100	IF(IOS .NE. 0)THEN
	  WRITE(T_OUT,*)'Unable to read MODEL file'
	  CLOSE(UNIT=LUIN)
	  RETURN
	END IF
!
! We can now READ the pointer file to get the number of iterations that
! have been completed.
!
	K=INDEX(FILE_NAME,'SCRTEMP')
	IF(K .EQ. 1)THEN
	  NEW_FILE_NAME='POINT1'
	ELSE
	  NEW_FILE_NAME=FILE_NAME(1:K-1)//'POINT1'
	END IF
	OPEN(UNIT=LUIN,FILE=NEW_FILE_NAME,STATUS='OLD',ACTION='READ',IOSTAT=IOS)
	  IF(IOS .NE. 0)THEN
	    WRITE(T_OUT,*)'Error opening POINT1'
	    RETURN
	  END IF
	  READ(LUIN,'(A)',IOSTAT=IOS)STRING
	  IF(IOS .EQ. 0)THEN
            IF(INDEX(STRING,'!Format date') .EQ. 0)THEN
              READ(STRING,*,IOSTAT=IOS)K,NIT
	    ELSE
              READ(LUIN,*,IOSTAT=IOS)K,NIT
	    END IF
	  END IF
	CLOSE(UNIT=LUIN)
!
	RETURN
	END
