	SUBROUTINE GET_PROF_PARAMS_V2(XV,YV,NCF,LINE_WAVE,EST_VEL_MIN,DO_EMISS,SN_AGE,DIR_NAME,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER NCF
	INTEGER LU
	REAL*4 XV(NCF)
	REAL*4 YV(NCF)
	REAL*4 DATA(NCF)                !Local storage
	REAL(KIND=LDP) SN_AGE
	REAL(KIND=LDP) LINE_WAVE
	REAL(KIND=LDP) EST_VEL_MIN
	LOGICAL DO_EMISS
	CHARACTER(LEN=*) DIR_NAME
!
	REAL*4 SP_T1
	REAL(KIND=LDP) T1,T2
	REAL(KIND=LDP) QW
	REAL(KIND=LDP) MAXIMUM,MINIMUM
	REAL(KIND=LDP) XEMIS_MEAN
	REAL(KIND=LDP) C_Mms
	REAL(KIND=LDP) SPEED_OF_LIGHT
	INTEGER GET_INDX_SP
	EXTERNAL SPEED_OF_LIGHT,GET_INDX_SP
!
	INTEGER I,J,K
	INTEGER IMIN,IMAX
!
	C_MMS=1.0E-08_LDP*SPEED_OF_LIGHT()
!
	MAXIMUM=-1000.0_LDP; MINIMUM=10000.0_LDP
!
	IF(EST_VEL_MIN .LE. 0D0)THEN
	  DO J=1,NCF
	    IF(XV(J) .GT. 0.96_LDP*LINE_WAVE .AND. XV(J) .LT. 0.997_LDP*LINE_WAVE)THEN
	      IF(YV(J) .LT. MINIMUM)THEN
	       MINIMUM=YV(J)
	        IMIN=J
	      END IF
	    END IF
	  END DO
	ELSE
	  T1=SQRT( (1.0_LDP+EST_VEL_MIN/C_MMS)/(1.0_LDP-EST_VEL_MIN/C_MMS))
	  SP_T1=LINE_WAVE*T1
	  K=GET_INDX_SP(SP_T1,XV,NCF)
	  MINIMUM=YV(K); IMIN=K
	  DO I=K+1,NCF
	    IF(YV(K) .LT. MINIMUM)THEN
	     MINIMUM=YV(I); IMIN=I
	    ELSE
	      EXIT
	    END IF
	  END DO
	  IF(IMIN .EQ. K)THEN
	    DO I=K-1,1,-1
	      IF(YV(K) .LT. MINIMUM)THEN
	        MINIMUM=YV(I); IMIN=I
	      ELSE
	        EXIT
	      END IF
	    END DO
	  END IF
	END IF
!
	DO J=IMIN,NCF
	  IF(XV(J) .LT. 1.1_LDP*LINE_WAVE)THEN
	    IF(YV(J) .GT. MAXIMUM)THEN
	      MAXIMUM=YV(J)
	      IMAX=J
	    END IF
	  END IF
	END DO
!
! Find centroid, integrating between the limits set by Y=0
!
	DATA=YV-1.0_LDP
	IF(MINIMUM .GT. 1.0_LDP .AND. SN_AGE .GT. 30.0_LDP)DATA=DATA-MINIMUM
	T1=0.0_LDP; T2=0.0_LDP
	DO J=IMIN,1,-1
	  IF(DATA(J) .GT. 0.0_LDP)THEN
	    DO K=J,IMIN-1
	      QW=0.5_LDP*(XV(K+1)-XV(K))
	      T1=T1+QW*(XV(K)*DATA(K)+XV(K+1)*DATA(K+1))
	      T2=T2+QW*(DATA(K)+DATA(K+1))
	    END DO
	    EXIT
	  END IF
	END DO
	DO J=IMIN,IMAX
	  IF(DATA(J) .GT. 0.0_LDP)THEN
	    DO K=IMIN,J-1
	      QW=0.5_LDP*(XV(K+1)-XV(K))
	      T1=T1+QW*(XV(K)*DATA(K)+XV(K+1)*DATA(K+1))
	      T2=T2+QW*(DATA(K)+DATA(K+1))
	    END DO
	    EXIT
	  END IF
	END DO
	IF(T2 .NE. 0)THEN
	  T1=T1/T2
	ELSE
	  WRITE(6,*)'Normalization for absorption is zero'
	  T1=0.0_LDP
	END IF
!
!
! Find emission centroid, integreating between the limits set by Y=0.75D*PEAK
!
	IF(DO_EMISS)THEN
	  XEMIS_MEAN=0.0_LDP; T2=0.0_LDP
	  DO J=IMAX,IMIN,-1
	    IF(DATA(J) .LT. 0.75_LDP*DATA(IMAX))THEN
	      DO K=J,IMAX-1
	        QW=0.5_LDP*(XV(K+1)-XV(K))
	        XEMIS_MEAN=XEMIS_MEAN+QW*(XV(K)*DATA(K)+XV(K+1)*DATA(K+1))
	        T2=T2+QW*(DATA(K)+DATA(K+1))
	      END DO
	      EXIT
	    END IF
	  END DO
	  DO J=IMAX,NCF
	    IF(DATA(J) .LT. 0.75_LDP*DATA(IMAX))THEN
	      DO K=IMAX,J-1
	        QW=0.5_LDP*(XV(K+1)-XV(K))
	        XEMIS_MEAN=XEMIS_MEAN+QW*(XV(K)*DATA(K)+XV(K+1)*DATA(K+1))
	        T2=T2+QW*(DATA(K)+DATA(K+1))
	      END DO
	      EXIT
	    END IF
	  END DO
	  IF(T2 .NE. 0)THEN
	    XEMIS_MEAN=XEMIS_MEAN/T2
	  ELSE
	    WRITE(6,*)'Normalization for emission is zero'
	    XEMIS_MEAN=0.0_LDP
	  END IF
	END IF
!
	IF(DO_EMISS)THEN
	  WRITE(6,*)XV(IMIN),XV(IMAX)
	  WRITE(LU,'(F7.3,8ES14.4)')SN_AGE,
	1         XV(IMIN),YV(IMIN),
	1         C_Mms*(XV(IMIN)/LINE_WAVE-1.0D0),
	1         C_Mms*(T1/LINE_WAVE-1.0D0),
	1         XV(IMAX),YV(IMAX),
	1         C_Mms*(XV(IMAX)/LINE_WAVE-1.0D0),
	1         C_Mms*(XEMIS_MEAN/LINE_WAVE-1.0D0)
	ELSE
	  T1=(T1-LINE_WAVE)/LINE_WAVE; T1=2*T1+T1*T1
	  T2=(XV(IMIN)-LINE_WAVE)/LINE_WAVE; T2=2*T2+T2*T2
	  WRITE(LU,'(F7.3,8ES14.4)')SN_AGE,
	1         XV(IMIN),YV(IMIN),
	1         C_Mms*T2/(2.0D0+T2),
	1         C_Mms*T1/(2.0D0+T1)
	  EST_VEL_MIN=C_Mms*T2/(2.0_LDP+T2)
	END IF
!
	RETURN
	END
