	SUBROUTINE RD_ZM_DATA(FILENAME,EDD_CONT_REC,RV_REC,IOS)
	USE SET_KIND_MODULE
	USE ZM_DATA_MODULE
	IMPLICIT NONE
!
	INTEGER, PARAMETER :: IZERO=0
	INTEGER, PARAMETER :: T_OUT=6
	INTEGER EDD_CONT_REC
	INTEGER RV_REC
	INTEGER IOS
	CHARACTER(LEN=*) FILENAME
!
	INTEGER ID
	INTEGER I
	INTEGER ML 
	INTEGER LU_IN
	INTEGER NCF,ND
!
	INTEGER ST_REC
	INTEGER REC_LENGTH
	LOGICAL FILE_OPEN
	CHARACTER(LEN=200) STRING
!
	ID=NUM_FILES+1
	ZM(ID)%FILENAME=FILENAME
	CALL READ_DIRECT_INFO_V3(I,REC_LENGTH,ZM(ID)%FILE_DATE,ZM(ID)%FILENAME,LU_IN,IOS)
	IF(IOS .NE. 0)THEN
	  WRITE(T_OUT,*)'Error opening/reading INFO file: check format'
	  WRITE(T_OUT,*)'Also check error file or fort.2'
	  WRITE(T_OUT,*)'File is '//TRIM(ZM(ID)%FILENAME)//'_INFO'
	  GOTO 999
	END IF
	OPEN(UNIT=LU_IN,FILE=ZM(ID)%FILENAME,STATUS='OLD',ACTION='READ',
	1                 RECL=REC_LENGTH,ACCESS='DIRECT',FORM='UNFORMATTED',IOSTAT=IOS)
	  IF(IOS .NE. 0)THEN
	     WRITE(T_OUT,*)'Error opening ',TRIM(ZM(ID)%FILENAME)
	     WRITE(T_OUT,*)'IOS=',IOS
	     GOTO 999
	  END IF
	  READ(LU_IN,REC=EDD_CONT_REC)ST_REC,ZM(ID)%NCF,ZM(ID)%ND
	  ND=ZM(ID)%ND; NCF=ZM(ID)%NCF
	  ALLOCATE (ZM(ID)%RJ(ND,NCF))
	  ALLOCATE (ZM(ID)%NU(NCF))
	  ALLOCATE (ZM(ID)%R(ND));            ZM(ID)%R=0.0_LDP
	  ALLOCATE (ZM(ID)%V(ND));            ZM(ID)%V=0.0_LDP
	  ALLOCATE (ZM(ID)%LANG_COORD(ND));   ZM(ID)%LANG_COORD=0.0_LDP
	  ALLOCATE (ZM(ID)%XV(ND))
	  ALLOCATE (ZM(ID)%ED(ND));           ZM(ID)%ED=0.0_LDP
	  ALLOCATE (ZM(ID)%T(ND));            ZM(ID)%T=0.0_LDP
	  ALLOCATE (ZM(ID)%TAU_ES(ND));       ZM(ID)%TAU_ES=0.0_LDP
	  DO ML=1,ZM(ID)%NCF
	    READ(LU_IN,REC=ST_REC+ML-1,IOSTAT=IOS)(ZM(ID)%RJ(I,ML),I=1,ZM(ID)%ND),ZM(ID)%NU(ML)
	    IF(IOS .NE. 0)THEN
	      WRITE(T_OUT,*)'Error reading all frequencies'
	      ZM(ID)%NCF=ML-1
	      EXIT
	    END IF
	  END DO
	  READ(LU_IN,REC=RV_REC)ST_REC
	  WRITE(T_OUT,*)'RECORD for reading R, V and SIGMA is',ST_REC
	  IF(ST_REC .EQ. 0)THEN
	    ZM(ID)%RV_PRES=.FALSE.
	    ZM(ID)%R=0.0_LDP; ZM(ID)%V=0.0_LDP; ZM(ID)%LANG_COORD=0.0_LDP
	  ELSE
	    ZM(ID)%RV_PRES=.TRUE.
	    READ(LU_IN,REC=ST_REC)ZM(ID)%R
	    READ(LU_IN,REC=ST_REC+1)ZM(ID)%V
	    READ(LU_IN,REC=ST_REC+2)ZM(ID)%LANG_COORD
	    WRITE(T_OUT,*)ZM(ID)%R(1),ZM(ID)%R(ND)
	    WRITE(T_OUT,*)ZM(ID)%V(1),ZM(ID)%V(ND)
	    WRITE(T_OUT,*)ZM(ID)%LANG_COORD(1),ZM(ID)%LANG_COORD(ND)
	  END IF
	CLOSE(LU_IN)
!
	WRITE(T_OUT,*)'Successfully read in ',TRIM(ZM(ID)%FILENAME),' file as MODEL A (default)'
	WRITE(T_OUT,*)'    Number of depth points is',ZM(ID)%ND
	WRITE(T_OUT,*)'Number of frequencies read is',ZM(ID)%NCF
	NUM_FILES=NUM_FILES+1
!
! Set default data types
!
	STRING=ZM(ID)%FILENAME
        CALL SET_CASE_UP(STRING,IZERO,IZERO)
        IF(INDEX(STRING,'EDDFACTOR') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='J'
        ELSE IF(INDEX(STRING,'ES_J_CONV') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='J'
        ELSE IF(INDEX(STRING,'FLUX') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='H'
        ELSE IF(INDEX(STRING,'FORCE') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='M(t)'
        ELSE IF(INDEX(STRING,'ETA') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='ETA'
        ELSE IF(INDEX(STRING,'CHI') .NE. 0)THEN
           ZM(ID)%DATA_TYPE='CHI'
        ELSE
           ZM(ID)%DATA_TYPE='UNKNOWN'
        END IF
	WRITE(T_OUT,*)'Default data type is: ',TRIM(ZM(ID)%DATA_TYPE)
!
	RETURN
!
999	INQUIRE(UNIT=LU_IN,OPENED=FILE_OPEN)
	IF(FILE_OPEN)CLOSE(LU_IN)
	RETURN
	END
