	SUBROUTINE READ_CORRECTIONS(CORRECTIONS,POPS,ND,NT,NIT,LU_IN)
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	INTEGER ND
	INTEGER NT
	INTEGER NIT
	INTEGER LU_IN
	REAL(KIND=LDP) CORRECTIONS(NT,ND)
	REAL(KIND=LDP)  POPS(NT,NT,NIT)
!
	INTEGER I,J,K,IOS
	LOGICAL READ_IN_STEQ
	LOGICAL READ_AGAIN
	LOGICAL, SAVE :: COR_READ=.FALSE.
	CHARACTER(LEN=200) STRING
!
	READ_IN_STEQ=.TRUE.
	CALL GEN_IN(READ_IN_STEQ,
	1           'Read in STEQ to get changes on the last iteration (pref. opt.)?')
	IF(COR_READ .AND. READ_IN_STEQ)THEN
	  READ_AGAIN=.FALSE.
	  CALL GEN_IN(READ_AGAIN,'Read in STEQ again?')
	ELSE
	  READ_AGAIN=.TRUE.
	END IF
!
	IF(READ_IN_STEQ .AND. READ_AGAIN)THEN
	  OPEN(UNIT=LU_IN,FILE='STEQ_VALS',STATUS='OLD',ACTION='READ')
	    DO WHILE(1 .EQ. 1)
	      READ(LU_IN,'(A)',IOSTAT=IOS)STRING
	      IF(IOS .NE. 0)EXIT
	      IF(INDEX(STRING,'STEQ SOLUTION ARRAY') .NE. 0)THEN
	         COR_READ=.FALSE.
	         DO J=1,ND,10
	           DO I=1,NT
	              READ(LU_IN,'(A)')STRING
	              K=INDEX(STRING,'#')
	              IF(K .NE. 0)READ(STRING(K+1:),*)(CORRECTIONS(I,K),K=J,MIN(J+9,ND))
	           END DO
	         END DO
	         COR_READ=.TRUE.
	         WRITE(6,*)'Successuly read in last set of corrections'
	      END IF
	    END DO
	  CLOSE(LU_IN)
	END IF
!
	IF(.NOT. READ_IN_STEQ .OR. (.NOT. COR_READ))THEN
	  DO J=1,ND
	    DO I=1,NT
	      CORRECTIONS(I,J)=(POPS(IVAR,J,IT-1)-POPS(IVAR,J,IT))/POPS(IVAR,J,IT)
	    END DO
	  END DO
	END IF
!
	RETURN
	END
