	SUBROUTINE SET_IP_XSPAT_UNIT(XV,P,XAXIS,RSTAR,DISTANCE,NP)
	USE SET_KIND_MODULE
	USE MOD_USR_OPTION
	IMPLICIT NONE
!
	INTEGER NP
	REAL(KIND=LDP) XV(NP)
	REAL(KIND=LDP) P(NP)
	REAL(KIND=LDP) RSTAR
	REAL(KIND=LDP) DISTANCE
	CHARACTER(LEN=*) XAXIS
!
	CHARACTER(LEN=30) UC
	REAL(KIND=LDP) PARSEC
	EXTERNAL UC,PARSEC
!
	REAL(KIND=LDP) T1
	INTEGER K
	CHARACTER(LEN=10) XSPAT_UNIT
!
	CALL USR_OPTION(XSPAT_UNIT,'XSPAT','AU','Arc, CM, AU, P/R*')
	XSPAT_UNIT=UC(XSPAT_UNIT)
	IF(XSPAT_UNIT(1:3) .EQ. 'ARC')THEN
	  T1=1.0E+10_LDP*206265.0_LDP/(DISTANCE*1.0E+03_LDP*PARSEC())
	  DO K=1,NP-1
	    XV(K)=LOG10(P(K+1)*T1)
	  END DO
	  XAXIS='Log P(")'
	ELSE IF(XSPAT_UNIT(1:2) .EQ. 'AU')THEN
	  T1=1.496E+03_LDP
	  DO K=1,NP-1
	    XV(K)=LOG10(P(K+1)/T1)
	  END DO
	  XAXIS='Log P(AU)'
	ELSE IF(XSPAT_UNIT(1:2) .EQ. 'CM')THEN
	  DO K=1,NP-1
	    XV(K)=LOG10(P(K+1))
	  END DO
	  XAXIS='Log P(10\u10\d cm))'
	ELSE
	  XV(1:NP-1)=LOG10(P(2:NP)/RSTAR)
	  XAXIS='Log P/R\d*\u'
	END IF
!
	RETURN
	END
