!
! This routine allocates the memory for the module used by SET_PROF.
! Data vectors are also initialized.
!
	SUBROUTINE INIT_PROF_MODULE_V2(ND,NLINES,NFREQ,NVGT_LINES,MAX_SIM)
	USE SET_KIND_MODULE
	USE PROF_MOD
	IMPLICIT NONE
!
! Altered: 05-Jul-2022	Call changed
! 			Added NVGT_LINES,MAX_SIM
!			Routine now allocates memory to store Voigt profiles.
!			Based on INIT_PROF_MODULE
! Input: Note that NLINES only has to be large enough to handle overlapping
!        HI and HeII profiles.
!
	INTEGER ND		!Number of depth points
	INTEGER NLINES	!Maximum number of profiles to be stored
	INTEGER NFREQ		!Maximum number of frequencies / profile
	INTEGER NVGT_LINES
	INTEGER MAX_SIM
!
	INTEGER IOS
	INTEGER ERROR_LU
	INTEGER IS
	REAL(KIND=LDP) SPEED_OF_LIGHT
	REAL(KIND=LDP) FUN_PI
	EXTERNAL ERROR_LU,SPEED_OF_LIGHT
!
! Memory allocation. This should not be a problem, unless no more
! memory available. We simply insure all memory can be allocated.
!
	IOS=0
	ALLOCATE (PROF_STORE(ND,NFREQ,NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (NU_STORE(NFREQ,NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (AMASS_STORE(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (NU_ZERO_STORE(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (NL_STORE(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (NUP_STORE(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (NF_STORE(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (LST_FREQ_LOC(NLINES),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (STORE_AVAIL(NLINES),STAT=IOS)
!
	IF(IOS .EQ. 0)ALLOCATE (PR_GRIEM(NFREQ),STAT=IOS)
	IF(IOS .EQ. 0)ALLOCATE (DWS_GRIEM(NFREQ),STAT=IOS)
!
	IF(IOS .NE. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error allocating arrays in INIT_PROF_MOD'
	  WRITE(LUER,*)'IOS=',IOS
	  STOP
	END IF
!
! Only vectors that needs to be initialized. Other locations will be
! set when line is available.
!
	NSTORE_MAX=NLINES
	NFREQ_MAX=NFREQ
	STORE_AVAIL(:)=.TRUE.
	PROF_STORE(:,:,:)=0.0_LDP
	LST_FREQ_LOC(:)=0
	C_KMS=1.0E-05_LDP*SPEED_OF_LIGHT()
	PI=FUN_PI()
	LUER=ERROR_LU()
!
	NVGT_ST=NVGT_LINES
	ALLOCATE(VGT(NVGT_LINES))
	ALLOCATE(VGT_POINTER(MAX_SIM)); VGT_POINTER=0
	DO IS=1,NVGT_ST
	  VGT(IS)%NF=0
	END DO
!
	RETURN
	END
